/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.repository.ejb.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

import javax.ejb.FinderException;
import javax.naming.NamingException;

/**
 *
 * <!-- begin-user-doc --> ファシリティ情報を管理するEntity Bean '<em><b>FacilityBean</b></em>'. <!-- end-user-doc --> *
 *
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="Facility"
 *	jndi-name="Facility"
 *	type="BMP"
 *
 * @ejb.dao class="com.clustercontrol.repository.dao.FacilityDAO"
 * impl-class="com.clustercontrol.repository.dao.FacilityDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 * 
 * <!-- end-xdoclet-defintion -->
 * @generated
 **/
public abstract class FacilityBean implements javax.ejb.EntityBean {
	public String dn;
	public String facilityId;
	public String cn;
	public String description;
	public Boolean pingWatch;
	public Boolean pingWatchStatus;
	public Boolean agentWatch;
	public Boolean agentWatchStatus;
	public Boolean statusWatch;
	public Boolean logWatch;
	public Boolean agentControl;
	public Boolean dhcpClient;
	public Integer ipType;
	public Integer ipProtocolNumber;
	public String ipNetworkNumber;
	public String ipNetworkNumberV6;
	public ArrayList host;
	public String machine;
	public String platform;
	public String osName;
	public String nodeName;
	public String osRelease;
	public String osVersion;
	public String charSet;
	public String managerName;
	public String managerContact;
	public String creatorsName;
	public Date createTimestamp;
	public String modifiersName;
	public Date modifyTimestamp;
	
	public Integer snmpPort;
	public String snmpCommunity;
	public String snmpVersion;
	
	//表示上の並び順を規定するデータ(Integerで値の大きい順にソートする。)
	public Integer sortValue;
	
	// ノード単位の有効/無効フラグ
	public Boolean valid;
	
	public Integer snmpTimeout;
	public Integer snmpRetries;
	public String snmpProxy;
	
	public ArrayList note;
	
	public String iconImage;
	
	public String virtNodeType;
	public String vmManagementNode;
	public Integer vmIndex;
	public String vmName;
	public String virtSolution;
	
	public int type;
	
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the type.
	 */
	public int getType() {
		return type;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param type The type to set.
	 */
	public void setType(int type) {
		this.type = type;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the dn.
	 */
	public String getDn() {
		return dn;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param dn The dn to set.
	 */
	public void setDn(String dn) {
		this.dn = dn;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the agentControl.
	 */
	public Boolean getAgentControl() {
		return agentControl;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param agentControl The agentControl to set.
	 */
	public void setAgentControl(Boolean agentControl) {
		this.agentControl = agentControl;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the agentWatch.
	 */
	public Boolean getAgentWatch() {
		return agentWatch;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param agentWatch The agentWatch to set.
	 */
	public void setAgentWatch(Boolean agentWatch) {
		this.agentWatch = agentWatch;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the agentWatchStatus.
	 */
	public Boolean getAgentWatchStatus() {
		return agentWatchStatus;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param agentWatchStatus The agentWatchStatus to set.
	 */
	public void setAgentWatchStatus(Boolean agentWatchStatus) {
		this.agentWatchStatus = agentWatchStatus;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the charSet.
	 */
	public String getCharSet() {
		return charSet;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param charSet The charSet to set.
	 */
	public void setCharSet(String charSet) {
		this.charSet = charSet;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the cn.
	 */
	public String getCn() {
		return cn;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param cn The cn to set.
	 */
	public void setCn(String cn) {
		this.cn = cn;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the createTimestamp.
	 */
	public Date getCreateTimestamp() {
		return createTimestamp;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param createTimestamp The createTimestamp to set.
	 */
	public void setCreateTimestamp(Date createTimestamp) {
		this.createTimestamp = createTimestamp;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the creatorsName.
	 */
	public String getCreatorsName() {
		return creatorsName;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param creatorsName The creatorsName to set.
	 */
	public void setCreatorsName(String creatorsName) {
		this.creatorsName = creatorsName;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the description.
	 */
	public String getDescription() {
		return description;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param description The description to set.
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the dhcpClient.
	 */
	public Boolean getDhcpClient() {
		return dhcpClient;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param dhcpClient The dhcpClient to set.
	 */
	public void setDhcpClient(Boolean dhcpClient) {
		this.dhcpClient = dhcpClient;
	}
	/**
	 * @ejb.persistence
	 * @ejb.pk-field
	 * @ejb.interface-method
	 * 
	 * @return Returns the facilityId.
	 */
	public String getFacilityId() {
		return facilityId;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param facilityId The facilityId to set.
	 */
	public void setFacilityId(String facilityId) {
		this.facilityId = facilityId;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the host.
	 */
	public ArrayList getHost() {
		return host;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param host The host to set.
	 */
	public void setHost(ArrayList host) {
		this.host = host;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the ipNetworkNumber.
	 */
	public String getIpNetworkNumber() {
		return ipNetworkNumber;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param ipNetworkNumber The ipNetworkNumber to set.
	 */
	public void setIpNetworkNumber(String ipNetworkNumber) {
		this.ipNetworkNumber = ipNetworkNumber;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the ipNetworkNumberV6.
	 */
	public String getIpNetworkNumberV6() {
		return ipNetworkNumberV6;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param ipNetworkNumberV6 The ipNetworkNumberV6 to set.
	 */
	public void setIpNetworkNumberV6(String ipNetworkNumberV6) {
		this.ipNetworkNumberV6 = ipNetworkNumberV6;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the ipProtocolNumber.
	 */
	public Integer getIpProtocolNumber() {
		return ipProtocolNumber;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param ipProtocolNumber The ipProtocolNumber to set.
	 */
	public void setIpProtocolNumber(Integer ipProtocolNumber) {
		this.ipProtocolNumber = ipProtocolNumber;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the ipType.
	 */
	public Integer getIpType() {
		return ipType;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param ipType The ipType to set.
	 */
	public void setIpType(Integer ipType) {
		this.ipType = ipType;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the logWatch.
	 */
	public Boolean getLogWatch() {
		return logWatch;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param logWatch The logWatch to set.
	 */
	public void setLogWatch(Boolean logWatch) {
		this.logWatch = logWatch;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the machine.
	 */
	public String getMachine() {
		return machine;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param machine The machine to set.
	 */
	public void setMachine(String machine) {
		this.machine = machine;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the managerContact.
	 */
	public String getManagerContact() {
		return managerContact;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param managerContact The managerContact to set.
	 */
	public void setManagerContact(String managerContact) {
		this.managerContact = managerContact;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the managerName.
	 */
	public String getManagerName() {
		return managerName;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param managerName The managerName to set.
	 */
	public void setManagerName(String managerName) {
		this.managerName = managerName;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the modifiersName.
	 */
	public String getModifiersName() {
		return modifiersName;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param modifiersName The modifiersName to set.
	 */
	public void setModifiersName(String modifiersName) {
		this.modifiersName = modifiersName;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the modifyTimestamp.
	 */
	public Date getModifyTimestamp() {
		return modifyTimestamp;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param modifyTimestamp The modifyTimestamp to set.
	 */
	public void setModifyTimestamp(Date modifyTimestamp) {
		this.modifyTimestamp = modifyTimestamp;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the nodeName.
	 */
	public String getNodeName() {
		return nodeName;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param nodeName The nodeName to set.
	 */
	public void setNodeName(String nodeName) {
		this.nodeName = nodeName;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the osName.
	 */
	public String getOsName() {
		return osName;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param osName The osName to set.
	 */
	public void setOsName(String osName) {
		this.osName = osName;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the osRelease.
	 */
	public String getOsRelease() {
		return osRelease;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param osRelease The osRelease to set.
	 */
	public void setOsRelease(String osRelease) {
		this.osRelease = osRelease;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the osVersion.
	 */
	public String getOsVersion() {
		return osVersion;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param osVersion The osVersion to set.
	 */
	public void setOsVersion(String osVersion) {
		this.osVersion = osVersion;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the pingWatch.
	 */
	public Boolean getPingWatch() {
		return pingWatch;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param pingWatch The pingWatch to set.
	 */
	public void setPingWatch(Boolean pingWatch) {
		this.pingWatch = pingWatch;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the pingWatchStatus.
	 */
	public Boolean getPingWatchStatus() {
		return pingWatchStatus;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param pingWatchStatus The pingWatchStatus to set.
	 */
	public void setPingWatchStatus(Boolean pingWatchStatus) {
		this.pingWatchStatus = pingWatchStatus;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the platform.
	 */
	public String getPlatform() {
		return platform;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param platform The platform to set.
	 */
	public void setPlatform(String platform) {
		this.platform = platform;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the statusWatch.
	 */
	public Boolean getStatusWatch() {
		return statusWatch;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param statusWatch The statusWatch to set.
	 */
	public void setStatusWatch(Boolean statusWatch) {
		this.statusWatch = statusWatch;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the snmpPort.
	 */
	public Integer getSnmpPort() {
		return snmpPort;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param snmpPort The snmpPort to set.
	 */
	public void setSnmpPort(Integer snmpPort) {
		this.snmpPort = snmpPort;
	}	
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the Community.
	 */
	public String getSnmpCommunity() {
		return snmpCommunity;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param snmpCommunity The snmpCommunity to set.
	 */
	public void setSnmpCommunity(String snmpCommunity) {
		this.snmpCommunity = snmpCommunity;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the snmpVersion.
	 */
	public String getSnmpVersion() {
		return snmpVersion;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param snmpVersion The snmpVersion to set.
	 */
	public void setSnmpVersion(String snmpVersion) {
		this.snmpVersion = snmpVersion;
	}
	/**
	 * 	@ejb.persistence
	 *  @ejb.interface-method
	 * @return
	 */
	public Integer getSortValue() {
		return sortValue;
	}
	/**
	 *  @ejb.interface-method
	 * @param srotValue
	 */
	public void setSortValue(Integer sortValue) {
		this.sortValue = sortValue;
	}
	
	/**
	 * 	@ejb.persistence
	 *  @ejb.interface-method
	 * @return
	 */
	public Boolean getValid() {
		return valid;
	}
	/**
	 *  @ejb.interface-method
	 * @param srotValue
	 */
	public void setValid(Boolean valid) {
		this.valid = valid;
	}
	

	
	
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * @return the snmpTimeout
	 */
	public Integer getSnmpTimeout() {
		return snmpTimeout;
	}
	/**
	 * @ejb.interface-method
	 * @param snmpTimeout the snmpTimeout to set
	 */
	public void setSnmpTimeout(Integer snmpTimeout) {
		this.snmpTimeout = snmpTimeout;
	}
	
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * @return the snmpRetries
	 */
	public Integer getSnmpRetries() {
		return snmpRetries;
	}
	/**
	 * @ejb.interface-method
	 * @param snmpRetries the snmpRetries to set
	 */
	public void setSnmpRetries(Integer snmpRetries) {
		this.snmpRetries = snmpRetries;
	}
	
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * @return the snmpProxy
	 */
	public String getSnmpProxy() {
		return snmpProxy;
	}
	/**
	 * @ejb.interface-method
	 * @param snmpProxy the snmpProxy to set
	 */
	public void setSnmpProxy(String snmpProxy) {
		this.snmpProxy = snmpProxy;
	}
	
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * @return the note
	 */
	public ArrayList getNote() {
		return note;
	}
	/**
	 * @ejb.interface-method
	 * @param note the note to set
	 */
	public void setNote(ArrayList note) {
		this.note = note;
	}
	
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * @return the iconImage
	 */
	public String getIconImage() {
		return iconImage;
	}
	/**
	 * @ejb.interface-method
	 * @param iconImage the iconImage to set
	 */
	public void setIconImage(String iconImage) {
		this.iconImage = iconImage;
	}
	
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * @return the virtNodeType
	 */
	public String getVirtNodeType() {
		return virtNodeType;
	}
	/**
	 * @ejb.interface-method
	 * @param virtNodeType the virtNodeType to set
	 */
	public void setVirtNodeType(String virtNodeType) {
		this.virtNodeType = virtNodeType;
	}
	
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * @return the virtManagementNode
	 */
	public String getVMManagementNode() {
		return vmManagementNode;
	}
	/**
	 * @ejb.interface-method
	 * @param vmManagementNode the virtManagementNode to set
	 */
	public void setVMManagementNode(String vmManagementNode) {
		this.vmManagementNode = vmManagementNode;
	}
	
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * @return the vmIndex
	 */
	public Integer getVmIndex() {
		return vmIndex;
	}
	/**
	 * @ejb.interface-method
	 * @param vmId the vmIndex to set
	 */
	public void setVmIndex(Integer vmIndex) {
		this.vmIndex = vmIndex;
	}
	
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * @return the vmName
	 */
	public String getVmName() {
		return vmName;
	}
	/**
	 * @ejb.interface-method
	 * @param vmName the vmName to set
	 */
	public void setVmName(String vmName) {
		this.vmName = vmName;
	}
	
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * @return the virtSolution
	 */
	public String getVirtSolution() {
		return virtSolution;
	}
	/**
	 * @ejb.interface-method
	 * @param virtSolution the virtSolution to set
	 */
	public void setVirtSolution(String virtSolution) {
		this.virtSolution = virtSolution;
	}
	
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public FacilityPK ejbCreate(String facilityId, String cn, int type ) throws javax.ejb.CreateException {
		setFacilityId(facilityId);
		setCn(cn);
		setType(type);
		return null;
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * The container invokes this method immediately after it calls ejbCreate.
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void ejbPostCreate() throws javax.ejb.CreateException {
		
	}
	
	public Collection ejbFindAll() throws FinderException{ 
		return null; 
	}
	
	public Collection ejbFindAllNode() throws FinderException{ 
		return null; 
	}
	
	public Collection ejbFindNode(
			String facilityId ,
			String facilityName, 
			String description, 
			String ipAddressV4, 
			String ipAddressV6, 
			String osName, 
			String osRelease, 
			String managerName, 
			String managerContact) throws FinderException{ 
		return null; 
	}
	
	public FacilityPK ejbFindByPrimaryKey(FacilityPK pk) throws FinderException {
		return null;
	}
	
	public FacilityPK ejbFindByFacilityId(String facilityId) throws FinderException {
		return null;
	}
	
	public Collection ejbFindByIpAddress(String ipAddress) throws FinderException {
		return null;
	}
	
	public Collection ejbFindByNodeName(String nodeName) throws FinderException {
		return null;
	}
	
	/**
	 * @ejb.interface-method
	 *  view-type="local"
	 * 
	 * @generated
	 */
	public Collection getDeviceInfo() throws FinderException, NamingException{ 
		Collection collection = null;
		try {
			collection = DeviceInfoUtil.getLocalHome().findByFacilityId(getFacilityId());
		} catch (FinderException e) {
			//TODO FinderException未実装
		} catch (NamingException e) {
			//TODO NamingException未実装
		}
		return collection;
	}
	
	/**
	 * @ejb.interface-method
	 *  view-type="local"
	 * 
	 * @generated
	 */
	public Collection getFacilityTree() throws FinderException, NamingException{ 
		Collection collection = null;
		try {
			collection = FacilityTreeUtil.getLocalHome().findByFacilityId(getFacilityId());
		} catch (FinderException e) {
			//TODO FinderException未実装
		} catch (NamingException e) {
			//TODO NamingException未実装
		}
		return collection;
	}
	
	/**
	 * @ejb.interface-method
	 *  view-type="local"
	 * 
	 * @generated
	 */
	public Collection getFileSystemInfo() throws FinderException, NamingException{ 
		Collection collection = null;
		try {
			collection = FileSystemInfoUtil.getLocalHome().findByFacilityId(getFacilityId());
		} catch (FinderException e) {
			//TODO FinderException未実装
		} catch (NamingException e) {
			//TODO NamingException未実装
		}
		return collection;
	}

	
}
