/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.sql.ejb.entity;

import javax.ejb.EntityBean;

/**
 * SQL監視設定情報を管理するEntity Bean <BR>
 * @ejb.bean name="MonitorSqlInfo"
 *           jndi-name="MonitorSqlInfo"
 *           type="CMP"
 *           schema="MonitorSqlInfo" 
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           primkey-field="monitorTypeId","monitorId"
 *           
 *  @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *  
 *  @ejb.permission
 *     unchecked="true"
 *     
 *  @ejb.persistence 
 *   table-name="cc_monitor_sql_info"  
 *           
 *  @ejb.finder 
 *    query="SELECT OBJECT(a) FROM MonitorSqlInfo as a"  
 *    signature="java.util.Collection findAll()"  
 *
 *  @ejb.pk class="com.clustercontrol.sql.ejb.entity.MonitorSqlInfoPK"
 *   
 */
public abstract class MonitorSqlInfoBean implements EntityBean {
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public MonitorSqlInfoPK ejbCreate(
			String monitorTypeId,
			String monitorId, 
			String connection_url, 
			String connection_user, 
			String connection_password, 
			String query, 
			String jdbc_driver
			) throws javax.ejb.CreateException {
		
		this.setMonitorTypeId(monitorTypeId);
		this.setMonitorId(monitorId);
		this.setConnection_url(connection_url);
		this.setConnection_user(connection_user);
		this.setConnection_password(connection_password);
		this.setQuery(query);
		this.setJdbc_driver(jdbc_driver);

		return null;
	}
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the monitorId.
	 */
	public abstract String getMonitorId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorId The monitorId to set.
	 */
	public abstract void setMonitorId(String monitorId);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_type_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the monitorTypeId.
	 */
	public abstract String getMonitorTypeId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorTypeId The monitorTypeId to set.
	 */
	public abstract void setMonitorTypeId(String monitorTypeId);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="connection_url"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the connection_url.
	 */
	public abstract String getConnection_url();

	/**
	 * @ejb.interface-method
	 * 
	 * @param connection_url The connection_url to set.
	 */
	public abstract void setConnection_url(String connection_url);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="connection_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the connection_user.
	 */
	public abstract String getConnection_user();

	/**
	 * @ejb.interface-method
	 * 
	 * @param connection_user The connection_user to set.
	 */
	public abstract void setConnection_user(String connection_user);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="connection_password"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the connection_password.
	 */
	public abstract String getConnection_password();

	/**
	 * @ejb.interface-method
	 * 
	 * @param connection_password The connection_password to set.
	 */
	public abstract void setConnection_password(String connection_password);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="query"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(1024)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the query.
	 */
	public abstract String getQuery();

	/**
	 * @ejb.interface-method
	 * 
	 * @param query The query to set.
	 */
	public abstract void setQuery(String query);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="jdbc_driver"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the jdbc_driver.
	 */
	public abstract String getJdbc_driver();

	/**
	 * @ejb.interface-method
	 * 
	 * @param jdbc_driver The jdbc_driver to set.
	 */
	public abstract void setJdbc_driver(String jdbc_driver);
}
