/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms.implementations;

import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityRuntimeException;
import org.apache.xml.security.signature.NodeFilter;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.utils.CachedXPathAPIHolder;
import org.apache.xml.security.utils.CachedXPathFuncHereAPI;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TransformXPath
extends TransformSpi {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$transforms$implementations$TransformXPath == null ? (class$org$apache$xml$security$transforms$implementations$TransformXPath = TransformXPath.class$("org.apache.xml.security.transforms.implementations.TransformXPath")) : class$org$apache$xml$security$transforms$implementations$TransformXPath).getName());
    public static final String implementedTransformURI = "http://www.w3.org/TR/1999/REC-xpath-19991116";
    static /* synthetic */ Class class$org$apache$xml$security$transforms$implementations$TransformXPath;

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput xMLSignatureInput) throws TransformationException {
        try {
            CachedXPathAPIHolder.setDoc(this._transformObject.getElement().getOwnerDocument());
            Element element = XMLUtils.selectDsNode(this._transformObject.getElement().getFirstChild(), "XPath", 0);
            if (element == null) {
                Object[] objectArray = new Object[]{"ds:XPath", "Transform"};
                throw new TransformationException("xml.WrongContent", objectArray);
            }
            Node node = element.getChildNodes().item(0);
            String string = CachedXPathFuncHereAPI.getStrFromNode(node);
            xMLSignatureInput.setNeedsToBeExpanded(this.needsCircunvent(string));
            if (node == null) {
                throw new DOMException(3, "Text must be in ds:Xpath");
            }
            xMLSignatureInput.addNodeFilter(new XPathNodeFilter(element, node, string));
            xMLSignatureInput.setNodeSet(true);
            return xMLSignatureInput;
        }
        catch (DOMException dOMException) {
            throw new TransformationException("empty", dOMException);
        }
    }

    private boolean needsCircunvent(String string) {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class XPathNodeFilter
    implements NodeFilter {
        PrefixResolverDefault prefixResolver;
        CachedXPathFuncHereAPI xPathFuncHereAPI = new CachedXPathFuncHereAPI(CachedXPathAPIHolder.getCachedXPathAPI());
        Node xpathnode;
        String str;

        XPathNodeFilter(Element element, Node node, String string) {
            this.xpathnode = node;
            this.str = string;
            this.prefixResolver = new PrefixResolverDefault((Node)element);
        }

        public boolean isNodeInclude(Node node) {
            try {
                XObject xObject = this.xPathFuncHereAPI.eval(node, this.xpathnode, this.str, (PrefixResolver)this.prefixResolver);
                return xObject.bool();
            }
            catch (TransformerException transformerException) {
                Object[] objectArray = new Object[]{node};
                throw new XMLSecurityRuntimeException("signature.Transform.node", objectArray, transformerException);
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{node, new Short(node.getNodeType())};
                throw new XMLSecurityRuntimeException("signature.Transform.nodeAndType", objectArray, exception);
            }
        }
    }
}

