/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.vm;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;

public class SqlTokenizer
extends StreamTokenizer {
    private boolean pushedBack;
    private boolean m_endFls = false;
    protected StringBuffer m_sqlFragment = new StringBuffer();
    private boolean m_inSingleQuotes = false;
    private boolean m_inDoubleQuotes = false;
    private int m_inParen = 0;
    private ArrayList m_fragmentList = new ArrayList(15);

    public SqlTokenizer(InputStream is) {
        super(is);
    }

    public SqlTokenizer(Reader r) {
        super(r);
    }

    public int nextToken() throws IOException {
        int token = super.nextToken();
        if (this.pushedBack) {
            this.pushedBack = false;
            return token;
        }
        if (token == -3) {
            this.m_sqlFragment.append(this.sval);
        } else if (token == -1) {
            if (!this.m_endFls) {
                this.m_fragmentList.add(this.m_sqlFragment.toString());
                this.m_endFls = true;
            }
        } else {
            switch (token) {
                case 39: {
                    this.m_inSingleQuotes = !this.m_inDoubleQuotes && !this.m_inSingleQuotes;
                    this.m_sqlFragment.append((char)token);
                    break;
                }
                case 34: {
                    this.m_inDoubleQuotes = !this.m_inSingleQuotes && !this.m_inDoubleQuotes;
                    this.m_sqlFragment.append((char)token);
                    break;
                }
                case 63: {
                    if (!this.m_inSingleQuotes && !this.m_inDoubleQuotes) {
                        this.m_fragmentList.add(this.m_sqlFragment.toString());
                        this.m_sqlFragment.delete(0, this.m_sqlFragment.length());
                        break;
                    }
                    this.m_sqlFragment.append((char)token);
                    break;
                }
                case 40: {
                    if (!this.m_inSingleQuotes && !this.m_inDoubleQuotes) {
                        ++this.m_inParen;
                    }
                    this.m_sqlFragment.append((char)token);
                    break;
                }
                case 41: {
                    if (!this.m_inSingleQuotes && !this.m_inDoubleQuotes) {
                        --this.m_inParen;
                    }
                    this.m_sqlFragment.append((char)token);
                    break;
                }
                default: {
                    this.m_sqlFragment.append((char)token);
                }
            }
        }
        return token;
    }

    public void pushBack() {
        super.pushBack();
        this.pushedBack = true;
    }

    public int getParamNum() {
        return this.m_fragmentList.size();
    }

    public static void main(String[] args) {
        String a = "SELECT name,count(?) FROM t1 WHERE uid IN ( SELECT uid FROM t2 WHERE uid>1000 ) and item_cd='?' ant item_name=?";
        for (int i = 0; i < 1000; ++i) {
            SqlTokenizer.test1(a);
        }
    }

    private static void test1(String a) {
        StringReader fr = new StringReader(a);
        SqlTokenizer m_tokenizer = new SqlTokenizer(fr);
        m_tokenizer.resetSyntax();
        m_tokenizer.wordChars(97, 122);
        m_tokenizer.wordChars(65, 90);
        m_tokenizer.wordChars(95, 95);
        m_tokenizer.wordChars(46, 46);
        m_tokenizer.wordChars(48, 57);
        m_tokenizer.ordinaryChar(47);
        m_tokenizer.eolIsSignificant(true);
        int token = -1;
        StringBuffer b = new StringBuffer();
        boolean flg = true;
        try {
            while ((token = m_tokenizer.nextToken()) != -1) {
                System.out.println(m_tokenizer.getParamNum());
                if (token == -3) {
                    b.append(m_tokenizer.sval);
                    if (flg) {
                        m_tokenizer.pushBack();
                    }
                    flg = !flg;
                    continue;
                }
                b.append((char)token);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(m_tokenizer.m_fragmentList);
        System.out.println(b);
    }

    public ArrayList getFragmentList() {
        return this.m_fragmentList;
    }
}

