/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.examples;

import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.opennms.protocols.snmp.SnmpHandler;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpParameters;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduRequest;
import org.opennms.protocols.snmp.SnmpPeer;
import org.opennms.protocols.snmp.SnmpSession;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpVarBind;

public class SnmpWalkExample
implements SnmpHandler {
    int m_version = 0;
    String m_community = null;
    int m_retries = -1;
    int m_timeout = -1;
    int m_port = -1;
    String m_host = "127.0.0.1";
    String m_startOid = ".1.3";
    SnmpObjectId m_stopAt = null;

    void parseOptions(String[] args) throws IllegalArgumentException {
        int lastArg = 0;
        for (int x = 0; x < args.length; ++x) {
            if (!args[x].startsWith("-")) continue;
            if (args[x].equals("-c")) {
                this.m_community = args[++x];
            } else if (args[x].equals("-v")) {
                if (args[++x].equals("1")) {
                    this.m_version = 0;
                } else if (args[x].equals("2") || args[x].equals("2c")) {
                    this.m_version = 1;
                }
            } else if (args[x].equals("-r")) {
                try {
                    this.m_retries = Integer.parseInt(args[++x]);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Malformed retry number");
                }
            } else if (args[x].equals("-t")) {
                try {
                    float f = Float.parseFloat(args[++x]);
                    this.m_timeout = (int)(f * 1000.0f);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Malformed timeout period");
                }
            } else if (args[x].equals("-p")) {
                try {
                    this.m_port = Integer.parseInt(args[++x]);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Malformed port number");
                }
            } else {
                if (args[x].equals("--")) {
                    lastArg = x + 1;
                    break;
                }
                throw new IllegalArgumentException("Unknown Option " + args[x]);
            }
            lastArg = x + 1;
        }
        if (args.length - lastArg == 1) {
            this.m_host = args[lastArg++];
        } else if (args.length - lastArg == 2) {
            this.m_host = args[lastArg++];
            this.m_startOid = args[lastArg++];
        } else {
            throw new IllegalArgumentException("Invalid number of arguments");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snmpInternalError(SnmpSession session, int err, SnmpSyntax pdu) {
        System.err.println("An unexpected error occured with the SNMP Session");
        System.err.println("The error code is " + err);
        SnmpSession snmpSession = session;
        synchronized (snmpSession) {
            session.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snmpTimeoutError(SnmpSession session, SnmpSyntax pdu) {
        System.err.println("The session timed out trying to communicate with the remote host");
        SnmpSession snmpSession = session;
        synchronized (snmpSession) {
            session.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snmpReceivedPdu(SnmpSession session, int cmd, SnmpPduPacket pdu) {
        SnmpPduRequest req = null;
        if (pdu instanceof SnmpPduRequest) {
            req = (SnmpPduRequest)pdu;
        }
        if (pdu.getCommand() != 162) {
            System.err.println("Error: Received non-response command " + pdu.getCommand());
            SnmpSession snmpSession = session;
            synchronized (snmpSession) {
                session.notify();
            }
            return;
        }
        if (req.getErrorStatus() != 0) {
            System.out.println("End of mib reached");
            SnmpSession snmpSession = session;
            synchronized (snmpSession) {
                session.notify();
            }
            return;
        }
        SnmpVarBind vb = pdu.getVarBindAt(0);
        if (vb.getValue().typeId() == -126 || this.m_stopAt != null && this.m_stopAt.compare(vb.getName()) < 0) {
            System.out.println("End of mib reached");
            SnmpSession snmpSession = session;
            synchronized (snmpSession) {
                session.notify();
            }
            return;
        }
        System.out.println(vb.getName().toString() + ": " + vb.getValue().toString());
        SnmpVarBind[] vblist = new SnmpVarBind[]{new SnmpVarBind(vb.getName())};
        SnmpPduRequest newReq = new SnmpPduRequest(161, vblist);
        newReq.setRequestId(SnmpPduPacket.nextSequence());
        session.send((SnmpPduPacket)newReq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        SnmpWalkExample walker = new SnmpWalkExample();
        InetAddress remote = null;
        try {
            walker.parseOptions(args);
            remote = InetAddress.getByName(walker.m_host);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (UnknownHostException e) {
            System.err.println("UnknownHostException: " + e.getMessage());
            System.exit(1);
        }
        SnmpPeer peer = new SnmpPeer(remote);
        if (walker.m_port != -1) {
            peer.setPort(walker.m_port);
        }
        if (walker.m_timeout != -1) {
            peer.setTimeout(walker.m_timeout);
        }
        if (walker.m_retries != -1) {
            peer.setRetries(walker.m_retries);
        }
        SnmpParameters parms = peer.getParameters();
        parms.setVersion(walker.m_version);
        if (walker.m_community != null) {
            parms.setReadCommunity(walker.m_community);
        }
        SnmpSession session = null;
        try {
            session = new SnmpSession(peer);
        }
        catch (SocketException e) {
            System.err.println("SocketException creating the SNMP session");
            System.err.println("SocketException: " + e.getMessage());
            System.exit(1);
        }
        session.setDefaultHandler((SnmpHandler)walker);
        SnmpObjectId id = new SnmpObjectId(walker.m_startOid);
        int[] ids = id.getIdentifiers();
        int n = ids.length - 1;
        ids[n] = ids[n] + 1;
        id.setIdentifiers(ids);
        walker.m_stopAt = id;
        SnmpVarBind[] vblist = new SnmpVarBind[]{new SnmpVarBind(walker.m_startOid)};
        SnmpPduRequest pdu = new SnmpPduRequest(161, vblist);
        pdu.setRequestId(SnmpPduPacket.nextSequence());
        try {
            SnmpSession snmpSession = session;
            synchronized (snmpSession) {
                session.send((SnmpPduPacket)pdu);
                session.wait();
            }
        }
        catch (InterruptedException e) {
        }
        finally {
            session.close();
        }
    }
}

