/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.ejb.session;

import java.rmi.RemoteException;

import javax.ejb.EJBException;
import javax.ejb.SessionContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * アクセスチェックを行う Session Bean クラス<BR>
 * 
 * クライアントにて、ログイン後に、ログインが行われたかのアクセスチェックを行います。
 * 
 * @ejb.bean name="AccessCheck"	
 *           jndi-name="AccessCheck"
 *           type="Stateless" 
 *           transaction-type="Container"
 * 
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.permission
 *     role-name="HinemosUser"
 */
public abstract class AccessCheckBean implements javax.ejb.SessionBean {
	/** ログ出力のインスタンス */
	protected static Log m_log = LogFactory.getLog( AccessCheckBean.class ); 
	
	/** コンテキスト情報 */
	@SuppressWarnings("unused")
	private SessionContext m_context;
	
	/**
	 * コンテキスト情報を設定します。<BR>
	 * Session Bean がインスタンスプールに格納される際に行う処理を実装します。
	 * @see javax.ejb.SessionBean#setSessionContext(javax.ejb.SessionContext)
	 */
	public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
		m_context = ctx;
	}

	/**
	 * ログインチェックの為、本メソッドを使用します。
	 * 
	 * @ejb.interface-method
	 */
	public void checkLogin() {

	}
}
