/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.composite;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import com.clustercontrol.calendar.action.GetCalendarList;
import com.clustercontrol.util.Messages;


/**
 * カレンダIDコンポジットクラス<BR>
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class CalendarIdListComposite extends Composite {

    // ----- instance フィールド ----- //

    /** カレンダIDラベル */
	private Label labelCalendarId = null;
	
    /** カレンダIDコンボボックス */
    private Combo comboCalendarId = null;

    // ----- コンストラクタ ----- //

    /**
     * インスタンスを返します。<BR>
     * 
     * @param parent 親のコンポジット
     * @param style スタイル
     * @param labelFlg カレンダIDラベル表示フラグ
     */
    public CalendarIdListComposite(Composite parent, int style, boolean labelFlg) {
        super(parent, style);
        
        this.initialize(parent, labelFlg);
    }
    

    // ----- instance メソッド ----- //

    /**
     * コンポジットを生成・構築します。<BR>
     */
    private void initialize(Composite parent, boolean labelFlg) {
    	
        // 変数として利用されるグリッドデータ
        GridData gridData = null;
        
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        if(labelFlg){
        	layout.numColumns = 15;	
        }
        else{
        	layout.numColumns = 10;
        }
        this.setLayout(layout);
        
        /*
         * カレンダID
         */
        if(labelFlg){
            // ラベル
            this.labelCalendarId = new Label(this, SWT.NONE);
            gridData = new GridData();
            gridData.horizontalSpan = 5;
            gridData.horizontalAlignment = GridData.FILL;
            gridData.grabExcessHorizontalSpace = true;
            this.labelCalendarId.setLayoutData(gridData);
            this.labelCalendarId.setText(Messages.getString("calendar.id") + " : ");
        }
        
        // コンボボックス
        this.comboCalendarId = new Combo(this, SWT.DROP_DOWN | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.comboCalendarId.setLayoutData(gridData);
                
        this.update();
    }

    /**
     * コンポジットを更新します。<BR>
     * <p>
     * 
     */
    public void update() {
    	
    	// 空欄
    	this.comboCalendarId.add("");
        
    	// データ取得
        ArrayList list = new GetCalendarList().getCalendarIdList();
        if(list != null){
        	// カレンダIDリスト
        	for(int index=0; index<list.size(); index++){
        		this.comboCalendarId.add((String)list.get(index));
        	}
        }
    }

	/* (非 Javadoc)
	 * @see org.eclipse.swt.widgets.Control#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean enabled) {
		this.comboCalendarId.setEnabled(enabled);
	}

	/* (非 Javadoc)
	 * @see org.eclipse.swt.widgets.Combo#getText()
	 */
	public String getText() {
		return this.comboCalendarId.getText();
	}

	/* (非 Javadoc)
	 * @see org.eclipse.swt.widgets.Combo#setText(java.lang.String)
	 */
	public void setText(String string) {
		this.comboCalendarId.setText(string);
	}
}