/*
                                                                                                
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.util;

import java.io.Serializable;
import java.util.Date;

/**
 * データテーブルにつめるオブジェクトクラス<BR>
 * 
 * @author Yosuke Miyamoto
 * 
 * @version 2.3.0
 * @since 2.1.2
 */
public class ValueObject implements Serializable {
	private static final long serialVersionUID = 6308719037477348275L;

	private final String key;
	private final long date;
	private final Object value;
	
	public ValueObject(String key, long date, Object value){
		this.key = key;
		this.date = date;
		this.value = value;
	}
	

	/**
	 * 日時を取得します。<BR>
	 * @return
	 */
	public long getDate() {
		return date;
	}
	
	 /**
	  * 値を取得します。<BR>
	  * @return
	  */
	public Object getValue() {
		return value;
	}
	
	/**
	 * キーを取得します。<BR>
	 * @return
	 */
	public String getKey() {
		return key;
	}

	/**
	 * 
	 */
	public String toString(){
		return new Date(this.date) + " : "  + key+ " : " + this.value.toString();
	}
}
