/*
                                                                                                
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
*/

package com.clustercontrol.poller;

/**
 * ファシリティ情報の取得に失敗した場合の例外クラス
 *  
 * @version 3.0.0
 * @since 2.0.0
 */
public class FacilityNotFoundException extends Exception {
	private static final long serialVersionUID = 1495550933270242958L;

	private String m_facilityId;
	
	public FacilityNotFoundException(String facilityId){
		m_facilityId = facilityId;
	}
	
	@Override
	public String getMessage() {
		return "FacilityID:" + m_facilityId + " is not found.";
	}
}
