//
// This file is part of the joeSNMP Java Library.
//
// joeSNMP is Copyright (C) 2002-2003 Blast Internet Services, Inc.  All rights reserved.
// joeSNMP is a derivative work, containing both original code, included code and modified
// code that was published under the GNU Lesser General Public License. Copyrights for modified 
// and included code are below.
//
// Copyright (C) 1999-2001 Oculan Corp. All rights reserved.
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// See: http://www.fsf.org/copyleft/lesser.html
//
// For more information contact:
//      joeSNMP Licensing       <joesnmp-license@lists.sourceforge.net>
//      http://sourceforge.net/projects/joesnmp/
//
// Modifications:
//
// $Id: AsnEncodingException.java,v 1.1 2004/09/19 23:01:12 andd Exp $
//

package org.opennms.protocols.snmp.asn1;


/**
 * The AsnEncodingException is generated whenever an error
 * occurs in ASN.1 encoding of data types. The errors are
 * generally buffer overflow errors.
 *
 * @author	<a href="http://www.opennms.org>OpenNMS</a>
 * @author	<a href="mailto:weave@oculan.com">Brian Weaver</a>
 * @version	1.1.1.1
 *
 */
public class AsnEncodingException extends Exception
{
	/**
	 * The default exception constructor
	 */
	public AsnEncodingException( )
	{
		super();
	}

	/**
	 * The exception constructor
	 *
	 * @param why The reason the exception is being raised
	 *
	 */
	public AsnEncodingException(String why)
	{
		super(why);
	}
}
