/*

 Copyright (C) 2009 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.vm.ejb.entity;

import javax.ejb.EntityBean;

/**
 * cc_vm_solution_mst情報を管理するEntity Bean <BR>
 * @ejb.bean name="VmSolutionMst"
 *           jndi-name="VmSolutionMst"
 *           type="CMP"
 *           schema="VmSolutionMst" 
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           primkey-field="vmSolutionId"
 *           
 *  @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *  
 *  @jboss.read-only read-only="true"
 *  
 *  @ejb.permission
 *     unchecked="true"
 *     
 *  @ejb.persistence 
 *   table-name="cc_vm_solution_mst"  
 *           
 *  @ejb.finder 
 *    query="SELECT OBJECT(a) FROM VmSolutionMst as a ORDER BY a.orderNo"  
 *    signature="java.util.Collection findAll()"  
 *
 *  @ejb.pk class="java.lang.String"
 *   
 */
public abstract class VmSolutionMstBean implements EntityBean {
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public java.lang.String ejbCreate(
			String vmSolutionId,
			Short orderNo,
			String platformId,
			String vmSolutionName
			) throws javax.ejb.CreateException {
		
		this.setVmSolutionId(vmSolutionId);
		this.setOrderNo(orderNo);
		this.setPlatformId(platformId);
		this.setVmSolutionName(vmSolutionName);
		
		return null;
	}
	
	/**
	 * コンストラクター
	 * @param vmSolutionId 仮想化ソリューション種別
	 * @param orderNo 表示順
	 * @param platformId プラットフォーム種別
	 * @param vmSolutionName 仮想化ソリューション名称
	 * @throws javax.ejb.CreateException
	 */
	public void ejbPostCreate(
			String vmSolutionId,
			Short orderNo,
			String platformId,
			String vmSolutionName
			) throws javax.ejb.CreateException {
	}
	
	
	
	
	
	/**
	 * 仮想化ソリューション種別を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="vm_solution_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="true"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the vmSolutionId.
	 */
	public abstract String getVmSolutionId();

	/**
	 * 仮想化ソリューション種別を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param vmSolutionId The vmSolutionId to set.
	 */
	public abstract void setVmSolutionId(String vmSolutionId);

	
	
	
	/**
	 * 表示順を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="order_no"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="SMALLINT"
	 *     read-only="true"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the orderNo.
	 */
	public abstract Short getOrderNo();

	
	/**
	 * 表示順を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param orderNo The orderNo to set.
	 */
	public abstract void setOrderNo(Short orderNo);
	
	
	
	
	/**
	 * プラットフォーム種別を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="platform_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="true"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the platformId.
	 */
	public abstract String getPlatformId();

	/**
	 * プラットフォーム種別を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param platformId The platformId to set.
	 */
	public abstract void setPlatformId(String platformId);

	
	
	
	/**
	 * 仮想化ソリューション名称を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="vm_solution_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="true"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the vmSolutionName.
	 */
	public abstract String getVmSolutionName();

	/**
	 * 仮想化ソリューション名称を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param vmSolutionName The vmSolutionName to set.
	 */
	public abstract void setVmSolutionName(String vmSolutionName);

}
