/*
 
Copyright (C) 2009 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.vm.ejb.mdb;

import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.commons.util.SendQueue;
import com.clustercontrol.vm.bean.NodeOperationStatusConstant;
import com.clustercontrol.vm.bean.QueueConstant;
import com.clustercontrol.vm.ejb.entity.VmOperationDetailData;
import com.clustercontrol.vm.factory.NodeOperationController;


/**
 *
 * <!-- begin-user-doc --> You can insert your documentation for '<em><b>VmExecuteBean</b></em>'. <!-- end-user-doc --> *
 *
 *
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="VmExecuteBean" 
 *     acknowledge-mode="Auto-acknowledge"
 *     destination-type="javax.jms.Queue"
 *     transaction-type="Bean"
 *     destination-jndi-name="queue/clustercontrolVmControlExecute"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=RepositoryController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=JobController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=QuartzManager"
 * 
 * @jboss.container-configuration 
 *     name="CollectiveRun Message Driven Bean" 
 *
 *--
 * Server Runtime Specific Tags
 * If you are not using a specific runtime, you can safely remove the tags below.
 * @jonas.message-driven-destination jndi-name="queue/clustercontrolVmControlExecute"
 * @jboss.destination-jndi-name name="queue/clustercontrolVmControlExecute"
 *
 *--
 * <!-- end-xdoclet-definition -->
 * @generated
 **/
public class VmOperationBean implements javax.ejb.MessageDrivenBean, javax.jms.MessageListener {
	protected static Log m_log = LogFactory.getLog( VmOperationBean.class );
    
    /** 
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * The context for the message-driven bean, set by the EJB container. 
     * @generated
     */
    private javax.ejb.MessageDrivenContext messageContext = null;

    /** 
     * Required method for container to set context.
     * @generated 
     */
    public void setMessageDrivenContext(
            javax.ejb.MessageDrivenContext messageContext)
            throws javax.ejb.EJBException {
        this.messageContext = messageContext;
    }

    /** 
     * Required creation method for message-driven beans. 
     *
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition -->
     * @ejb.create-method 
     * <!-- end-xdoclet-definition -->
     * @generated
     */
    public void ejbCreate() {
        //no specific action required for message-driven beans 
    }

    /** 
     * Required removal method for message-driven beans. 
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void ejbRemove() {
        messageContext = null;
    }

    /** 
     * This method implements the business logic for the EJB. 
     * 
     * <p>Make sure that the business logic accounts for asynchronous message processing. 
     * For example, it cannot be assumed that the EJB receives messages in the order they were 
     * sent by the client. Instance pooling within the container means that messages are not 
     * received or processed in a sequential order, although individual onMessage() calls to 
     * a given message-driven bean instance are serialized. 
     * 
     * <p>The <code>onMessage()</code> method is required, and must take a single parameter 
     * of type javax.jms.Message. The throws clause (if used) must not include an application 
     * exception. Must not be declared as final or static. 
     *
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void onMessage(javax.jms.Message message) {
    	
    	//残作業//
    	//infoログをdebugに変更
    	
    	m_log.debug("onMessage() : start");

    	//受信オブジェクトの確認(ObjectMessage)
        if (message instanceof ObjectMessage) {
            ObjectMessage objectMessage = (ObjectMessage) message;
            Object obj;
            try {
                obj = objectMessage.getObject();
            } catch (JMSException e) {
                m_log.error("onMessage() : An illegal message was received.", e);
                return;
            }

            //受信オブジェクトの確認(VmOperationDetailData)
            if (obj instanceof VmOperationDetailData) {
                
            	VmOperationDetailData data = (VmOperationDetailData) obj;

            	m_log.debug("onMessage() : VmOperationDetailData was received. : SessionID = " + data.getSessionId());

                //---------------------------
                //-- キュー作成
                //---------------------------
            	SendQueue send = null;
                try {
                    send = new SendQueue(QueueConstant.QUEUE_NAME_STATUS);
                } catch (NamingException e) {
                    m_log.error("exec() : キュー作成 : " + e.getMessage(),e);
                    return;
                } catch (JMSException e) {
                    m_log.error("exec() : キュー作成 : " + e.getMessage(),e);
                    return;
                }

                //---------------------------
                //-- メイン処理実行
                //---------------------------
                try {
            		
            		//メイン処理のコマンド実行
            		exec(send, data);
            		
                } catch (JMSException e) {
					// TODO: handle exception
                	
                	//内部でキュー送信エラーの際に実行するエラー処理は何もしないでfinallyへ

                } catch (Exception e) {
					
					//コマンド実行等にて、想定外のExceptionが発生した場合、実行失敗とする
					
					m_log.error(e);
					
			        //メッセージ作成(status,endDate,endValue,message)
					VmOperationDetailData data2 = null;
			        data2 = new VmOperationDetailData(
			        			data.getSessionId(),
			        			data.getFacilityId(),
			        			data.getScopeText(),
			        			data.getNodeType(),
			        			data.getCommandId(),
			        			NodeOperationStatusConstant.FAIL, // status = FAIL(起動失敗)
			        			data.getStartDate(),
			        			null,
			        			new Date(), // endDateを現在時刻に設定
			        			null,
			        			e.getMessage()
			        	);
			    	
			        //送信
			        try {
			            //Queueに送信
			            send.put(data2);
			        } catch (JMSException e1) {
			            m_log.error("exec() : 実行失敗のメッセージ送信エラー : " + e1.getMessage(),e1);
			        }
		            
				} finally {
					
	                //---------------------------
	                //-- キュー終了処理
	                //---------------------------
					if ( send != null ){
						try {
							send.terminate();
						} catch (JMSException e) {
							m_log.error("Terminate SendQueue Failed : " + e);
			                return;
						}
					}

				}

            } else {
                m_log.error("onMessage() : An illegal message was received." + obj.toString());
                return;
            }
        } else {
            m_log.error("onMessage() : An illegal message was received." + message.getClass());
            return;
        }
        
        m_log.debug("onMessage() : end");
        
    }
    
    

    /**
     * 
     * @param send QUEUE_NAME_STATUSキュー
     * @param data 対象オブジェクト
     * @throws NamingException
     * @throws CreateException
     * @throws FinderException
     * @throws JMSException
     */
    public void exec(SendQueue send , VmOperationDetailData data) throws NamingException,CreateException,FinderException,JMSException{

		m_log.debug("exec() : start sessionId = " + data.getSessionId() + ", facilityId = " + data.getFacilityId());

    	
    	//状態変更処理をシリアライズして実行するMDBへ送信するオブジェクト
		VmOperationDetailData data2 = null;
    	
		
    	
        //---------------------------
        //-- 開始メッセージ送信
        //---------------------------

        //メッセージ作成(status,startDateを変更)
        data2 = new VmOperationDetailData(
        			data.getSessionId(),
        			data.getFacilityId(),
        			data.getScopeText(),
        			data.getNodeType(),
        			data.getCommandId(),
        			NodeOperationStatusConstant.RUNNING, // statusを実行中にする
        			new Date(), // startDateを現在時刻に設定
        			null,
        			data.getEndDate(),
        			data.getEndValue(),
        			data.getMessage()
        	);
    	
        //送信
        try {
            //Queueに送信
            send.put(data2);
        } catch (JMSException e) {
            m_log.error("exec() : 開始メッセージ送信エラー : " + e.getMessage(),e);
            throw e;
        }

    	
        //---------------------------
        //-- コマンド実行
        //---------------------------

		NodeOperationController controller = new NodeOperationController();
        try{
            controller.action(data);
            data.setStatus(NodeOperationStatusConstant.STOP);
            data.setEndValue(0);
        } catch (Exception e) {
        	m_log.error(e);
        	if(data.getMessage() == null) {
        		data.setMessage(e.getMessage());
        	}
        	if(data.getStatus() == null) {
        		data.setStatus(NodeOperationStatusConstant.FAIL);
        	}
		}
        m_log.debug("exec() : end run command" +
        		", status=" + data.getStatus() +
        		", endStatus=" + data.getEndStatus() +
        		", message=" + data.getMessage());
        
        //---------------------------
        //-- 終了メッセージ送信
        //---------------------------

        //メッセージ作成(status,endDate,endValue,message)
        data2 = new VmOperationDetailData(
        			data.getSessionId(),
        			data.getFacilityId(),
        			data.getScopeText(),
        			data.getNodeType(),
        			data.getCommandId(),
        			data.getStatus(),
        			data.getStartDate(),
        			data.getEndStatus(),
        			new Date(), // endDateを現在時刻に設定
        			data.getEndValue(),
        			data.getMessage()
        	);
        
        //送信
        try {
            //Queueに送信
            send.put(data2);
        } catch (JMSException e) {
            m_log.error("exec() : 終了メッセージ送信エラー : " + e.getMessage());
            throw e;
        }

        
		m_log.debug("exec() : end sessionId = " + data.getSessionId() + ", facilityId = " + data.getFacilityId());

    }

}
