package org.postgresforest.util;

import java.io.*;
import java.util.*;
import java.util.concurrent.*;


public class SimpleCopyParallelInputStream {
    
    // FIXME 最初にストリームを全読み出しする実装になっているため、OutOfMemoryになる可能性有り
    
    public static List<InputStream> createParallelInputStream(InputStream originalStream, int length)
    throws IOException {
        final List<InputStream> streamList = new CopyOnWriteArrayList<InputStream>();
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int buf = originalStream.read();
        int count = 0;
        for (count = 0; buf != -1 && count < length; count++) {
            baos.write(buf);
            buf = originalStream.read();
        }
        streamList.add(new ByteArrayInputStream(baos.toByteArray()));
        streamList.add(new ByteArrayInputStream(baos.toByteArray()));
        
        return streamList;
    }
}
