/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import javax.transaction.Transaction;
import org.jboss.cache.CacheException;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeNode;
import org.jboss.cache.config.Option;
import org.jboss.cache.factories.NodeFactory;
import org.jboss.cache.interceptors.OptimisticInterceptor;
import org.jboss.cache.marshall.JBCMethodCall;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jgroups.blocks.MethodCall;

public class OptimisticNodeInterceptor
extends OptimisticInterceptor {
    public void setCache(TreeCache cache) {
        super.setCache(cache);
    }

    public Object invoke(MethodCall call) throws Throwable {
        JBCMethodCall m = (JBCMethodCall)call;
        InvocationContext ctx = this.getInvocationContext();
        Transaction tx = ctx.getTransaction();
        Method meth = m.getMethod();
        Object[] args = m.getArgs();
        if (this.isBuddyGroupOrganisationMethod(m)) {
            return super.invoke(m);
        }
        Object result = null;
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        TransactionWorkspace workspace = this.getTransactionWorkspace(gtx);
        if (MethodDeclarations.isCrudMethod(meth)) {
            if (tx == null || !this.isValid(tx)) {
                throw new CacheException("Must be in a valid transaction " + (Object)((Object)m));
            }
            WorkspaceNode workspaceNode = this.getOrCreateWorkspaceNode(this.getFqn(args), workspace, true);
            if (workspaceNode == null && m.getMethodId() == 34) {
                workspaceNode = this.getOrCreateWorkspaceNode(this.getBackupFqn(args), workspace, true);
            }
            if (workspaceNode != null) {
                if (ctx.getOptionOverrides() != null && ctx.getOptionOverrides().getDataVersion() != null) {
                    workspace.setVersioningImplicit(false);
                    DataVersion version = ctx.getOptionOverrides().getDataVersion();
                    workspaceNode.setVersion(version);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Setting versioning for node " + workspaceNode.getFqn() + " to explicit"));
                    }
                    workspaceNode.setVersioningImplicit(false);
                } else {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Setting versioning for node " + workspaceNode.getFqn() + " to implicit"));
                    }
                    workspaceNode.setVersioningImplicit(true);
                }
            } else {
                if ((ctx.getOptionOverrides() == null || !ctx.getOptionOverrides().isFailSilently()) && MethodDeclarations.isOptimisticPutMethod(meth)) {
                    throw new CacheException("Unable to set node version for " + this.getFqn(args) + ", node is null.");
                }
                this.log.trace((Object)"Workspace node is null.  Perhaps it has been deleted?");
                return null;
            }
            switch (m.getMethodId()) {
                case 1: {
                    Boolean erase = (Boolean)args[3];
                    this.putDataMap(args, erase, workspace, workspaceNode);
                    break;
                }
                case 2: {
                    this.putDataMap(args, true, workspace, workspaceNode);
                    break;
                }
                case 3: {
                    result = this.putDataKeyValue(args, workspace, workspaceNode);
                    break;
                }
                case 5: {
                    this.removeNode(workspace, workspaceNode);
                    break;
                }
                case 6: {
                    result = this.removeKey(args, workspace, workspaceNode);
                    break;
                }
                case 7: {
                    this.removeData(workspace, workspaceNode);
                    break;
                }
                case 34: {
                    result = super.invoke(m);
                }
                default: {
                    if (!this.log.isInfoEnabled()) break;
                    this.log.info((Object)("Cannot Handle Method " + (Object)((Object)m)));
                }
            }
            Option opt = ctx.getOptionOverrides();
            if (opt == null || !opt.isCacheModeLocal()) {
                this.txTable.addModification(gtx, m);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Adding Method " + (Object)((Object)m) + " to modification list"));
                }
            }
            if (this.cache.getCacheLoaderManager() != null) {
                this.txTable.addCacheLoaderModification(gtx, m);
            }
        } else {
            switch (m.getMethodId()) {
                case 26: {
                    result = this.getValueForKey(args, workspace);
                    break;
                }
                case 25: {
                    result = this.getKeys(args, workspace);
                    break;
                }
                case 23: {
                    result = this.getChildNames(args, workspace);
                    break;
                }
                case 31: {
                    result = this.getNode(args, workspace);
                    break;
                }
                case 8: 
                case 9: {
                    result = super.invoke(m);
                    break;
                }
                default: {
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)("read Method " + (Object)((Object)m) + " called - don't know how to handle, passing on!"));
                    }
                    result = super.invoke(m);
                }
            }
        }
        return result;
    }

    private Fqn getFqn(Object[] args) {
        return (Fqn)args[1];
    }

    private Fqn getBackupFqn(Object[] args) {
        return (Fqn)args[2];
    }

    private void putDataMap(Object[] args, boolean eraseExisitng, TransactionWorkspace workspace, WorkspaceNode workspaceNode) {
        Map data = (Map)args[2];
        if (workspaceNode == null) {
            return;
        }
        workspaceNode.put(data, eraseExisitng);
        workspace.addNode(workspaceNode);
    }

    private Object putDataKeyValue(Object[] args, TransactionWorkspace workspace, WorkspaceNode workspaceNode) {
        Object key = args[2];
        Object value = args[3];
        if (workspaceNode == null) {
            return null;
        }
        Object old = workspaceNode.put(key, value);
        workspace.addNode(workspaceNode);
        return old;
    }

    private void removeNode(TransactionWorkspace workspace, WorkspaceNode workspaceNode) throws CacheException {
        WorkspaceNode toDelete;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("removeNode " + workspace + " node=" + workspaceNode));
        }
        if (workspaceNode == null) {
            return;
        }
        TreeNode temp = workspaceNode.getParent();
        if (temp == null) {
            return;
        }
        boolean debug = this.log.isDebugEnabled();
        Fqn parentFqn = temp.getFqn();
        WorkspaceNode parentNode = this.getOrCreateWorkspaceNode(parentFqn, workspace, false);
        if (!(parentNode != null || (parentNode = workspace.getNode(parentFqn)) != null && parentNode.isDeleted())) {
            throw new CacheException("Unable to find parent node with Fqn " + parentFqn);
        }
        parentNode.removeChild(workspaceNode.getName());
        workspace.addNode(parentNode);
        if (debug) {
            this.log.debug((Object)("added parent node " + parentNode.getFqn() + " to workspace"));
        }
        Fqn nodeFqn = workspaceNode.getFqn();
        workspace.addNode(workspaceNode);
        SortedMap tailMap = workspace.getNodesAfter(workspaceNode.getFqn());
        Iterator it = tailMap.entrySet().iterator();
        while (it.hasNext() && (toDelete = (WorkspaceNode)it.next().getValue()).getFqn().isChildOrEquals(nodeFqn)) {
            if (debug) {
                this.log.debug((Object)("marking node " + toDelete.getFqn() + " as deleted"));
            }
            toDelete.markAsDeleted(true);
        }
    }

    private Object removeKey(Object[] args, TransactionWorkspace workspace, WorkspaceNode workspaceNode) {
        if (workspaceNode == null) {
            return null;
        }
        Object removeKey = args[2];
        Object old = workspaceNode.remove(removeKey);
        workspace.addNode(workspaceNode);
        return old;
    }

    private void removeData(TransactionWorkspace workspace, WorkspaceNode workspaceNode) {
        if (workspaceNode == null) {
            return;
        }
        workspaceNode.clear();
        workspace.addNode(workspaceNode);
    }

    private Object getValueForKey(Object[] args, TransactionWorkspace workspace) {
        Fqn fqn = (Fqn)args[0];
        Object key = args[1];
        WorkspaceNode workspaceNode = this.getOrCreateWorkspaceNode(fqn, workspace, false);
        if (workspaceNode == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("unable to find node " + fqn + " in workspace."));
            }
            return null;
        }
        Object val = workspaceNode.get(key);
        workspace.addNode(workspaceNode);
        return val;
    }

    private Object getNode(Object[] args, TransactionWorkspace workspace) {
        Fqn fqn = (Fqn)args[0];
        WorkspaceNode workspaceNode = this.getOrCreateWorkspaceNode(fqn, workspace, false);
        if (workspaceNode == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("unable to find node " + fqn + " in workspace."));
            }
            return null;
        }
        workspace.addNode(workspaceNode);
        return workspaceNode.getNode();
    }

    private Object getKeys(Object[] args, TransactionWorkspace workspace) {
        Fqn fqn = (Fqn)args[0];
        WorkspaceNode workspaceNode = this.getOrCreateWorkspaceNode(fqn, workspace, false);
        if (workspaceNode == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("unable to find node " + fqn + " in workspace."));
            }
            return null;
        }
        Set keySet = workspaceNode.getKeys();
        workspace.addNode(workspaceNode);
        return keySet;
    }

    private Object getChildNames(Object[] args, TransactionWorkspace workspace) {
        Fqn fqn = (Fqn)args[0];
        WorkspaceNode workspaceNode = this.getOrCreateWorkspaceNode(fqn, workspace, false);
        if (workspaceNode == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("unable to find node " + fqn + " in workspace."));
            }
            return null;
        }
        Set nameSet = workspaceNode.getChildrenNames();
        workspace.addNode(workspaceNode);
        return nameSet;
    }

    private WorkspaceNode getOrCreateWorkspaceNode(Fqn fqn, TransactionWorkspace workspace, boolean undeleteIfNecessary) {
        WorkspaceNode workspaceNode;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Attempting to get node " + fqn + " into the workspace"));
        }
        if ((workspaceNode = workspace.getNode(fqn)) == null) {
            DataNode node = this.cache.peek(fqn);
            if (node == null) {
                return null;
            }
            workspaceNode = NodeFactory.getInstance().createWorkspaceNode(node, workspace);
            workspace.addNode(workspaceNode);
        }
        if (workspaceNode.isDeleted()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Node " + fqn + " has been deleted in the workspace."));
            }
            if (undeleteIfNecessary) {
                workspaceNode.markAsDeleted(false);
                WorkspaceNode parent = this.getOrCreateWorkspaceNode(fqn.getParent(), workspace, true);
                parent.addChild(workspaceNode);
            } else {
                workspaceNode = null;
            }
        }
        if (workspaceNode != null && !(workspaceNode.getVersion() instanceof DefaultDataVersion)) {
            this.log.trace((Object)"Setting versioning to explicit");
            workspaceNode.setVersioningImplicit(false);
        }
        return workspaceNode;
    }
}

