/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.dao;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.jobmanagement.dao.JobSessionDAO;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionBean;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionPK;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobSessionDAOImpl
implements JobSessionDAO {
    protected static Log m_log = LogFactory.getLog(JobSessionDAOImpl.class);

    public void init() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(JobSessionPK pk, JobSessionBean ejb) throws EJBException {
        m_log.debug((Object)("load() start : " + pk.toString()));
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_job_session WHERE session_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.getSession_id());
                res = stmt.executeQuery();
                if (!res.next()) {
                    String msg = "JobSession data is not found.";
                    m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + msg));
                    throw new EJBException(msg);
                }
                ejb.setJob_id(res.getString("job_id"));
                ejb.setOperation_flg(res.getInt("operation_flg"));
                ejb.setTrigger_type(res.getInt("trigger_type"));
                ejb.setTrigger_info(res.getString("trigger_info"));
                if (res.getTimestamp("schedule_date") != null) {
                    ejb.setSchedule_date(new Date(res.getTimestamp("schedule_date").getTime()));
                } else {
                    ejb.setSchedule_date(null);
                }
                ejb.setSession_id(res.getString("session_id"));
                Object var9_9 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("load() end : " + pk.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store(JobSessionBean ejb) throws EJBException {
        m_log.debug((Object)("store() start : " + ejb.getSession_id()));
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("UPDATE cc_job_session SET ");
                sql.append("job_id = ?, ");
                sql.append("schedule_date = ?, ");
                sql.append("operation_flg = ?, ");
                sql.append("trigger_type = ?, ");
                sql.append("trigger_info = ? ");
                sql.append("WHERE session_id = ?");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setString(1, ejb.getJob_id());
                if (ejb.getSchedule_date() instanceof Date) {
                    stmt.setTimestamp(2, new Timestamp(ejb.getSchedule_date().getTime()));
                } else {
                    stmt.setTimestamp(2, null);
                }
                stmt.setInt(3, ejb.getOperation_flg());
                stmt.setInt(4, ejb.getTrigger_type());
                stmt.setString(5, ejb.getTrigger_info());
                stmt.setString(6, ejb.getSession_id());
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("store() error : " + ejb.getSession_id() + " SQLException" + msg));
                    throw new EJBException(msg);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("store() error : " + ejb.getSession_id() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("store() error : " + ejb.getSession_id() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("store() error : " + ejb.getSession_id() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("store() end : " + ejb.getSession_id()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(JobSessionPK pk) throws RemoveException, EJBException {
        m_log.debug((Object)("remove() start : " + pk.toString()));
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "DELETE FROM cc_job_session WHERE session_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.getSession_id());
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                    throw new EJBException(msg);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("remove() end : " + pk.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JobSessionPK create(JobSessionBean ejb) throws CreateException, EJBException {
        JobSessionPK pk;
        m_log.debug((Object)("create() start : " + ejb.getSession_id()));
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("INSERT INTO cc_job_session (");
                sql.append("session_id, ");
                sql.append("job_id, ");
                sql.append("schedule_date, ");
                sql.append("operation_flg, ");
                sql.append("trigger_type, ");
                sql.append("trigger_info) ");
                sql.append("VALUES (?,?,?,?,?,?)");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setString(1, ejb.getSession_id());
                stmt.setString(2, ejb.getJob_id());
                if (ejb.getSchedule_date() instanceof Date) {
                    stmt.setTimestamp(3, new Timestamp(ejb.getSchedule_date().getTime()));
                } else {
                    stmt.setTimestamp(3, null);
                }
                stmt.setInt(4, ejb.getOperation_flg());
                stmt.setInt(5, ejb.getTrigger_type());
                stmt.setString(6, ejb.getTrigger_info());
                int row = stmt.executeUpdate();
                pk = new JobSessionPK(ejb.getSession_id());
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("create() error : " + ejb.getSession_id() + " SQLException"));
                    throw new EJBException(msg);
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                if (!e.getSQLState().equals("23505")) throw new CreateException(e.getMessage());
                m_log.error((Object)("create() error : " + ejb.getSession_id() + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("create() error : " + ejb.getSession_id() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("create() error : " + ejb.getSession_id() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("create() end : " + ejb.getSession_id()));
        return pk;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findAll() throws FinderException {
        m_log.debug((Object)"findAll() start");
        ArrayList<JobSessionPK> ret = new ArrayList<JobSessionPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT * FROM cc_job_session");
                stmt = conn.prepareStatement(sql.toString());
                res = stmt.executeQuery();
                while (res.next()) {
                    JobSessionPK pk = new JobSessionPK(res.getString("session_id"));
                    ret.add(pk);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)"findAll() end");
        return ret;
    }

    public JobSessionPK findByPrimaryKey(JobSessionPK pk) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findByPrimaryKey() start : " + pk.toString()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_session WHERE session_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getSession_id());
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            JobSessionPK jobSessionPK = pk;
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            return jobSessionPK;
        }
        try {
            try {
                String msg = "id " + pk.toString() + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findHistory(Date startFromDate, Date startToDate, Date endFromDate, Date endToDate, String jobId, Integer status, Integer triggerType, String triggerInfo, Integer limit) throws FinderException {
        m_log.debug((Object)("findHistory() start : " + startFromDate + ", " + startToDate + ", " + endFromDate + ", " + endToDate + ", " + jobId + ", " + status + ", " + triggerType + ", " + triggerInfo + ", " + limit));
        ArrayList<JobSessionPK> ret = new ArrayList<JobSessionPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("SELECT a.session_id FROM cc_job_session as a, cc_job_session_job as b ");
                sql.append("WHERE a.session_id = b.session_id AND a.job_id = b.job_id");
                if (startFromDate instanceof Date) {
                    sql.append(" AND b.start_date >= ?");
                }
                if (startToDate instanceof Date) {
                    sql.append(" AND b.start_date <= ?");
                }
                if (endFromDate instanceof Date) {
                    sql.append(" AND b.end_date >= ?");
                }
                if (endToDate instanceof Date) {
                    sql.append(" AND b.end_date <= ?");
                }
                if (jobId != null && jobId.length() > 0) {
                    sql.append(" AND b.job_id = ?");
                }
                if (status instanceof Integer && status != -1) {
                    sql.append(" AND b.status = ?");
                }
                if (triggerType instanceof Integer && triggerType != -1) {
                    sql.append(" AND a.trigger_type = ?");
                }
                if (triggerInfo != null && triggerInfo.length() > 0) {
                    sql.append(" AND a.trigger_info like ?");
                }
                sql.append(" ORDER BY b.session_id DESC");
                if (limit != null) {
                    sql.append(" LIMIT " + limit.toString());
                }
                stmt = conn.prepareStatement(sql.toString());
                int count = 1;
                if (startFromDate instanceof Date) {
                    stmt.setTimestamp(count, new Timestamp(startFromDate.getTime()));
                    ++count;
                }
                if (startToDate instanceof Date) {
                    stmt.setTimestamp(count, new Timestamp(startToDate.getTime()));
                    ++count;
                }
                if (endFromDate instanceof Date) {
                    stmt.setTimestamp(count, new Timestamp(endFromDate.getTime()));
                    ++count;
                }
                if (endToDate instanceof Date) {
                    stmt.setTimestamp(count, new Timestamp(endToDate.getTime()));
                    ++count;
                }
                if (jobId != null && jobId.length() > 0) {
                    stmt.setString(count, jobId);
                    ++count;
                }
                if (status instanceof Integer && status != -1) {
                    stmt.setInt(count, status);
                    ++count;
                }
                if (triggerType instanceof Integer && triggerType != -1) {
                    stmt.setInt(count, triggerType);
                    ++count;
                }
                if (triggerInfo != null && triggerInfo.length() > 0) {
                    stmt.setString(count, "%" + triggerInfo + "%");
                    ++count;
                }
                res = stmt.executeQuery();
                while (res.next()) {
                    JobSessionPK pk = new JobSessionPK(res.getString("session_id"));
                    ret.add(pk);
                }
                Object var18_18 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("findHistory() error : " + startFromDate + ", " + startToDate + ", " + endFromDate + ", " + endToDate + ", " + jobId + ", " + status + ", " + triggerType + ", " + triggerInfo + ", " + limit + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("findHistory() error : " + startFromDate + ", " + startToDate + ", " + endFromDate + ", " + endToDate + ", " + jobId + ", " + status + ", " + triggerType + ", " + triggerInfo + ", " + limit + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("findHistory() error : " + startFromDate + ", " + startToDate + ", " + endFromDate + ", " + endToDate + ", " + jobId + ", " + status + ", " + triggerType + ", " + triggerInfo + ", " + limit + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("findHistory() end : " + startFromDate + ", " + startToDate + ", " + endFromDate + ", " + endToDate + ", " + jobId + ", " + status + ", " + triggerType + ", " + triggerInfo + ", " + limit));
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int countHistory(Date startFromDate, Date startToDate, Date endFromDate, Date endToDate, String jobId, Integer status, Integer triggerType, String triggerInfo) throws SQLException {
        m_log.debug((Object)("countHistory() start : " + startFromDate + ", " + startToDate + ", " + endFromDate + ", " + endToDate + ", " + jobId + ", " + status + ", " + triggerType + ", " + triggerInfo));
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        int total = 0;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("SELECT COUNT(*) FROM cc_job_session as a, cc_job_session_job as b ");
                sql.append("WHERE a.session_id = b.session_id AND a.job_id = b.job_id");
                if (startFromDate instanceof Date) {
                    sql.append(" AND b.start_date >= ?");
                }
                if (startToDate instanceof Date) {
                    sql.append(" AND b.start_date <= ?");
                }
                if (endFromDate instanceof Date) {
                    sql.append(" AND b.end_date >= ?");
                }
                if (endToDate instanceof Date) {
                    sql.append(" AND b.end_date <= ?");
                }
                if (jobId != null && jobId.length() > 0) {
                    sql.append(" AND b.job_id = ?");
                }
                if (status instanceof Integer && status != -1) {
                    sql.append(" AND b.status = ?");
                }
                if (triggerType instanceof Integer && triggerType != -1) {
                    sql.append(" AND a.trigger_type = ?");
                }
                if (triggerInfo != null && triggerInfo.length() > 0) {
                    sql.append(" AND a.trigger_info like ?");
                }
                stmt = conn.prepareStatement(sql.toString());
                int count = 1;
                if (startFromDate instanceof Date) {
                    stmt.setTimestamp(count, new Timestamp(startFromDate.getTime()));
                    ++count;
                }
                if (startToDate instanceof Date) {
                    stmt.setTimestamp(count, new Timestamp(startToDate.getTime()));
                    ++count;
                }
                if (endFromDate instanceof Date) {
                    stmt.setTimestamp(count, new Timestamp(endFromDate.getTime()));
                    ++count;
                }
                if (endToDate instanceof Date) {
                    stmt.setTimestamp(count, new Timestamp(endToDate.getTime()));
                    ++count;
                }
                if (jobId != null && jobId.length() > 0) {
                    stmt.setString(count, jobId);
                    ++count;
                }
                if (status instanceof Integer && status != -1) {
                    stmt.setInt(count, status);
                    ++count;
                }
                if (triggerType instanceof Integer && triggerType != -1) {
                    stmt.setInt(count, triggerType);
                    ++count;
                }
                if (triggerInfo != null && triggerInfo.length() > 0) {
                    stmt.setString(count, "%" + triggerInfo + "%");
                    ++count;
                }
                if ((res = stmt.executeQuery()).next()) {
                    total = res.getInt(1);
                }
            }
            catch (SQLException e) {
                m_log.error((Object)("countHistory() error : " + startFromDate + ", " + startToDate + ", " + endFromDate + ", " + endToDate + ", " + jobId + ", " + status + ", " + triggerType + ", " + triggerInfo + " SQLException"));
                throw e;
            }
            Object var16_16 = null;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("countHistory() error : " + startFromDate + ", " + startToDate + ", " + endFromDate + ", " + endToDate + ", " + jobId + ", " + status + ", " + triggerType + ", " + triggerInfo + " SQLException"));
                throw e1;
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("countHistory() error : " + startFromDate + ", " + startToDate + ", " + endFromDate + ", " + endToDate + ", " + jobId + ", " + status + ", " + triggerType + ", " + triggerInfo + " SQLException"));
            throw e1;
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("countHistory() end : " + startFromDate + ", " + startToDate + ", " + endFromDate + ", " + endToDate + ", " + jobId + ", " + status + ", " + triggerType + ", " + triggerInfo));
        return total;
    }
}

