/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.ejb.bmp;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.performance.bean.CollectedDataInfo;
import com.clustercontrol.performance.bean.CollectorItemInfo;
import com.clustercontrol.performance.bean.EventCode;
import com.clustercontrol.performance.bean.QuartzConstant;
import com.clustercontrol.performance.bean.ScopeTree;
import com.clustercontrol.performance.dao.CalculatedDataDAO;
import com.clustercontrol.performance.dao.CollectorItemDAO;
import com.clustercontrol.performance.ejb.bmp.CollectorPK;
import com.clustercontrol.performance.ejb.bmp.CollectorStatusLocal;
import com.clustercontrol.performance.ejb.bmp.CollectorStatusPK;
import com.clustercontrol.performance.ejb.bmp.CollectorStatusUtil;
import com.clustercontrol.performance.ejb.bmp.RecordCollectorData;
import com.clustercontrol.performance.job.CollectJob;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorDeviceInfoData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorDeviceInfoLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorDeviceInfoUtil;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorScopeRelationLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorScopeRelationUtil;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorScopeSnapLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorScopeSnapUtil;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorSnmpMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorSnmpMstUtil;
import com.clustercontrol.performance.monitor.ejb.entity.MonitorPerfInfoLocal;
import com.clustercontrol.performance.monitor.ejb.entity.MonitorPerfInfoUtil;
import com.clustercontrol.performance.monitor.factory.RunMonitorPerformance2;
import com.clustercontrol.performance.util.FacilityTreeDB;
import com.clustercontrol.performance.util.JNDIConnectionManager;
import com.clustercontrol.performance.util.Repository;
import com.clustercontrol.poller.CollectorAlreadyExistException;
import com.clustercontrol.poller.FacilityNotFoundException;
import com.clustercontrol.poller.NotInitializedException;
import com.clustercontrol.poller.snmp.PollingInterval;
import com.clustercontrol.poller.snmp.SnmpPoller;
import com.clustercontrol.poller.snmp.SnmpPollerManager;
import com.clustercontrol.sharedtable.DataTableNotFoundException;
import com.clustercontrol.sharedtable.SharedTable;
import com.clustercontrol.util.apllog.AplLogger;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectorBean
implements EntityBean {
    protected static Log m_log = LogFactory.getLog(CollectorBean.class);
    public static final String SHARED_TABLE_JNDI_NAME = "SharedTable";
    public static final String POLLER_MANAGER_JNDI_NAME = "SnmpPollerManager";
    private final int MAX_LIFECOUNT = 2;
    private int lifetimeCounter;
    private int collectorType;
    private String collectorID = null;
    private int intervalSec;
    private String facilityID;
    private ScopeTree scopeTree;
    private CollectorItemInfo[] items;
    private String label;
    private long scheduledStartTime;
    private long scheduledStopTime;
    private long startTime;
    private long stopTime;
    private String scopePath;
    private int periodMin;
    private int presavePeriod;
    protected EntityContext entityCtx;

    public CollectorPK ejbCreate(RecordCollectorData data, List<CollectorItemInfo> itemList) throws CreateException {
        m_log.debug((Object)("ejbCreate() start : " + data.getCollectorID()));
        this.items = itemList.toArray(new CollectorItemInfo[itemList.size()]);
        this.setCollectorID(data.getCollectorID());
        this.setCollectorType(data.getCollectorType());
        this.setFacilityID(data.getFacilityID());
        this.setIntervalSec(data.getIntervalSec());
        this.setLabel(data.getLabel());
        this.setPeriodMin(data.getPeriodMin());
        this.setScopePath(data.getScopePath());
        this.setPresavePeriod(data.getPresavePeriod());
        m_log.debug((Object)("ejbCreate() e : " + data.getCollectorID()));
        return new CollectorPK(data.getCollectorID());
    }

    public void ejbPostCreate(RecordCollectorData data, List<CollectorItemInfo> itemList) throws CreateException {
        m_log.debug((Object)("ejbPostCreate()  Collector Type : " + this.collectorType));
        try {
            Repository repository = new Repository();
            FacilityTreeItem facilityTree = repository.getFacilityTree(this.facilityID);
            List<CollectorDeviceInfoData> allDeviceList = repository.getDeviceList(this.facilityID);
            this.scopeTree = new ScopeTree(facilityTree, allDeviceList, null, this.intervalSec);
            this.setScopePath(repository.getFacilityPath(this.facilityID));
            if (this.collectorType == 2) {
                new FacilityTreeDB().insertFacilityTree(this.collectorID, facilityTree);
                for (CollectorDeviceInfoData deviceData : allDeviceList) {
                    CollectorDeviceInfoUtil.getLocalHome().create(this.collectorID, deviceData.getFacilityId(), deviceData.getDeviceName(), deviceData.getIndex(), deviceData.getDeviceId(), deviceData.getDeviceType());
                }
            }
            CollectorItemDAO cidao = new CollectorItemDAO();
            for (int i = 0; i < this.items.length; ++i) {
                this.items[i].setCollectorId(this.collectorID);
                cidao.insertCollectorItem(this.items[i]);
            }
            CollectorStatusUtil.getLocalHome().create(new CollectorStatusPK(this.collectorID));
        }
        catch (NamingException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
            throw new EJBException((Exception)e);
        }
    }

    public void setCollectorItems(String collectoId) {
        CollectorItemDAO cidao = new CollectorItemDAO();
        List<CollectorItemInfo> list = cidao.selectCollectorItemByCollectorID(collectoId);
        this.items = list.toArray(new CollectorItemInfo[list.size()]);
    }

    public CollectorPK ejbFindByPrimaryKey(CollectorPK pk) throws FinderException {
        return pk;
    }

    public Collection ejbFindByCollectorType(int type) throws FinderException {
        m_log.debug((Object)("ejbFindByStatus() : Type = " + type));
        return null;
    }

    public Collection ejbFindByPresave() throws FinderException {
        m_log.debug((Object)"ejbFindByPresave() : ");
        return null;
    }

    public Collection ejbFindByCollectorTypeAndFacilityId(int type, String facilityId) throws FinderException {
        m_log.debug((Object)("ejbFindByCollectorTypeAndFacilityId() : Type = " + type + ", FacilityID = " + facilityId));
        return null;
    }

    public Collection ejbFindAll() throws FinderException {
        m_log.debug((Object)"ejbFindAll() : ");
        return null;
    }

    public void ejbActivate() throws EJBException, RemoteException {
    }

    public void ejbLoad() throws EJBException, RemoteException {
        m_log.debug((Object)("ejbLoad() start : " + this.collectorID));
        m_log.debug((Object)("ejbLoad() end   : " + this.collectorID));
    }

    public void ejbPassivate() throws EJBException, RemoteException {
    }

    public void ejbRemove() throws RemoveException, EJBException, RemoteException {
        m_log.debug((Object)("ejbRemove() start : " + this.collectorID));
        this.deleteJob();
        try {
            CollectorStatusUtil.getLocalHome().remove(new CollectorStatusPK(this.collectorID));
            CollectorItemDAO cidao = new CollectorItemDAO();
            cidao.deleteCollectorItemByCollectorID(this.collectorID);
            for (CollectorDeviceInfoLocal data : CollectorDeviceInfoUtil.getLocalHome().findByCollectorId(this.collectorID)) {
                data.remove();
            }
            for (CollectorScopeRelationLocal data : CollectorScopeRelationUtil.getLocalHome().findByCollectorId(this.collectorID)) {
                data.remove();
            }
            for (CollectorScopeSnapLocal data : CollectorScopeSnapUtil.getLocalHome().findByCollectorId(this.collectorID)) {
                data.remove();
            }
            CalculatedDataDAO calDao = new CalculatedDataDAO();
            calDao.delete(this.collectorID);
        }
        catch (NamingException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
            throw new EJBException((Exception)((Object)e));
        }
        m_log.debug((Object)("ejbRemove() end   : " + this.collectorID));
    }

    public void ejbStore() throws EJBException, RemoteException {
    }

    public void setEntityContext(EntityContext ctx) throws EJBException, RemoteException {
        this.entityCtx = ctx;
    }

    public void unsetEntityContext() throws EJBException, RemoteException {
    }

    public RecordCollectorData getRecordColletorData() {
        m_log.debug((Object)"getRecordColletorData() strat : ");
        RecordCollectorData data = new RecordCollectorData();
        data.setCollectorID(this.getCollectorID());
        data.setCollectorType(this.getCollectorType());
        data.setFacilityID(this.getFacilityID());
        data.setIntervalSec(this.getIntervalSec());
        data.setCount(this.getCount());
        data.setLabel(this.getLabel());
        data.setStatus(this.getStatus());
        data.setPeriodMin(this.getPeriodMin());
        data.setScopePath(this.getScopePath());
        data.setStartDate(this.getStartDate());
        data.setStopDate(this.getStopDate());
        data.setFacilityTree(this.getFacilityTree());
        data.setRealCollectPeriod(this.getRealCollectPeriod());
        data.setEndStatus(this.getEndStatus());
        data.setPresavePeriod(this.getPresavePeriod());
        data.setLastCollectDate(this.getLastCollectDate());
        m_log.debug((Object)"getRecordColletorData() end   : ");
        return data;
    }

    public void startCollect() throws NamingException {
        m_log.debug((Object)("startCollect() start : " + this.collectorID + " " + this.collectorType));
        this.setCollectorType(this.collectorType);
        this.startPoller();
        this.stopTime = this.periodMin == -1 ? Long.MAX_VALUE : System.currentTimeMillis() + (long)(this.periodMin * 60) * 1000L;
        this.setStartDate(new Date(System.currentTimeMillis()));
        this.scheduleJob();
        try {
            this.scopeTree.fetchMibValue(this.collectorID, this.facilityID);
        }
        catch (NotInitializedException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        m_log.debug((Object)("startCollect() end   : " + this.collectorID + " " + this.collectorType));
    }

    public boolean restartCollect() throws NamingException {
        m_log.debug((Object)("restartCollect() start : " + this.collectorID + " " + this.collectorType + " to " + this.stopTime));
        boolean isRunning = false;
        if (this.getStatus() == 100) {
            isRunning = true;
        }
        boolean isRestart = false;
        this.startPoller();
        try {
            this.scopeTree.fetchMibValue(this.collectorID, this.facilityID);
        }
        catch (NotInitializedException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.scheduleJob();
        isRestart = true;
        if (this.collectorType == 2) {
            String[] messages = new String[]{"CollectorID : " + this.collectorID};
            this.outputLog(EventCode.WarningRestart, messages);
        } else if (this.collectorType == 3) {
            // empty if block
        }
        if (!isRunning) {
            this.setErrorStatus(1);
        }
        m_log.debug((Object)("restartCollect() end   : " + this.collectorID + " " + this.collectorType + " to " + this.stopTime));
        return isRestart;
    }

    public void startPoller() throws NamingException {
        if (this.scopeTree == null || this.facilityID == null) {
            return;
        }
        try {
            InitialContext ctx = new InitialContext();
            SharedTable sst = (SharedTable)ctx.lookup(SHARED_TABLE_JNDI_NAME);
            String[] nodeIDList = this.scopeTree.getNodeIDList(this.facilityID);
            for (int i = 0; i < nodeIDList.length; ++i) {
                Object obj;
                SnmpPollerManager manager;
                SnmpPoller poller;
                TreeSet<String> oids = new TreeSet<String>();
                for (int j = 0; j < this.items.length; ++j) {
                    String platformId = Repository.getPlatformId(nodeIDList[i]);
                    Collection beans = CollectorSnmpMstUtil.getLocalHome().findByPlatformIdAndItemCode(platformId, this.items[j].getItemCode());
                    Iterator itr = beans.iterator();
                    while (itr.hasNext()) {
                        oids.add(((CollectorSnmpMstLocal)itr.next()).getPollingOid());
                    }
                }
                if (!sst.containsTable("PRF", nodeIDList[i], 2)) {
                    sst.createDataTable("PRF", nodeIDList[i], 2);
                }
                if ((poller = (manager = (SnmpPollerManager)PortableRemoteObject.narrow((Object)(obj = ctx.lookup(POLLER_MANAGER_JNDI_NAME)), SnmpPollerManager.class)).getPoller("PRF", nodeIDList[i])) == null) {
                    poller = manager.createPoller("PRF", nodeIDList[i], false, "PRF", nodeIDList[i]);
                }
                poller.startPolling(this.collectorID, this.intervalSec, new ArrayList(oids));
            }
        }
        catch (NotInitializedException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (DataTableNotFoundException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (CollectorAlreadyExistException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (FacilityNotFoundException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (FinderException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public CollectedDataInfo getValue(String facilityId, CollectorItemInfo cii) {
        this.resetLifetimeCounter();
        CollectedDataInfo data = this.scopeTree.getValue(facilityId, cii);
        if (this.collectorType == 1 && Double.isNaN(data.getValue())) {
            data = this.scopeTree.getTempValue(facilityId, cii);
        }
        return data;
    }

    public CollectedDataInfo[] getValueAll(String facilityId) {
        CollectedDataInfo[] dataList = new CollectedDataInfo[this.items.length];
        for (int i = 0; i < this.items.length; ++i) {
            dataList[i] = this.getValue(facilityId, this.items[i]);
        }
        return dataList;
    }

    public List<CollectedDataInfo> getSubScopeValues(String facilityId, CollectorItemInfo cii) {
        ArrayList<CollectedDataInfo> ret = new ArrayList<CollectedDataInfo>();
        String[] subScopeFids = this.scopeTree.getSubScopeIDList(facilityId);
        for (int i = 0; i < subScopeFids.length; ++i) {
            ret.add(this.getValue(subScopeFids[i], cii));
        }
        return ret;
    }

    public void stopCollect() {
        m_log.debug((Object)("stopCollect() start : " + this.collectorID));
        this.deleteJob();
        try {
            InitialContext ctx = new InitialContext();
            SharedTable sst = (SharedTable)ctx.lookup(SHARED_TABLE_JNDI_NAME);
            String[] nodeIDList = this.scopeTree.getNodeIDList(this.facilityID);
            m_log.debug((Object)("stopCollect() stop polling : " + nodeIDList));
            for (int i = 0; i < nodeIDList.length; ++i) {
                Object obj = ctx.lookup(POLLER_MANAGER_JNDI_NAME);
                SnmpPollerManager manager = (SnmpPollerManager)PortableRemoteObject.narrow((Object)obj, SnmpPollerManager.class);
                SnmpPoller poller = manager.getPoller("PRF", nodeIDList[i]);
                if (poller != null) {
                    poller.stopPolling(this.collectorID);
                }
                if (sst.containsTable("PRF", nodeIDList[i], 2)) continue;
                sst.unregisterCollector("PRF", nodeIDList[i], this.collectorID);
            }
        }
        catch (NamingException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (DataTableNotFoundException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.setStopDate(new Date(System.currentTimeMillis()));
        m_log.debug((Object)("stopCollect() end   : " + this.collectorID));
    }

    private void scheduleJob() throws NamingException {
        m_log.debug((Object)("scheduleJob()  Group : PERF_COLLECT : " + this.collectorID + " : " + this.intervalSec));
        JobDetail job = new JobDetail(this.collectorID, "PERF_COLLECT", CollectJob.class);
        job.setDurability(true);
        job.getJobDataMap().put((Object)"pk", (Object)new CollectorPK(this.collectorID));
        job.getJobDataMap().put("type", this.collectorType);
        CronTrigger cronTrigger = new CronTrigger(this.collectorID, "PERF_COLLECT");
        cronTrigger.setMisfireInstruction(2);
        try {
            String cronString = PollingInterval.parseCronExpression((int)this.intervalSec);
            cronString = "10 */10 * * * ? *";
            if (this.intervalSec < 60) {
                int delayTimeUnder1min = QuartzConstant.getDelayTimeUnder1min();
                cronString = delayTimeUnder1min + "/" + this.intervalSec + " * * * * ? *";
            } else {
                int delayTimeOver1min = QuartzConstant.getDelayTimeOver1min();
                if (60 <= this.intervalSec && this.intervalSec < 3600) {
                    cronString = delayTimeOver1min + " */" + this.intervalSec / 60 + " * * * ? *";
                } else if (3600 <= this.intervalSec) {
                    cronString = delayTimeOver1min + " 0 */" + this.intervalSec / 3600 + " * * ? *";
                }
                this.startTime += (long)(this.intervalSec * 1000);
                if (this.startTime / 1000L % (long)this.intervalSec <= (long)delayTimeOver1min) {
                    this.startTime += (long)(delayTimeOver1min * 1000);
                }
            }
            cronTrigger.setCronExpression(cronString);
            cronTrigger.setStartTime(new Date(this.startTime));
            cronTrigger.setEndTime(new Date(this.stopTime));
        }
        catch (ParseException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        InitialContext iniCtx = JNDIConnectionManager.getInitialContext();
        Scheduler scheduler = (Scheduler)iniCtx.lookup(QuartzConstant.getQuartzName());
        try {
            scheduler.deleteJob(this.collectorID, "PERF_COLLECT");
            scheduler.scheduleJob(job, (Trigger)cronTrigger);
        }
        catch (SchedulerException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void pauseJob() {
        m_log.debug((Object)("pauseJob() start : " + this.collectorID));
        try {
            InitialContext iniCtx = JNDIConnectionManager.getInitialContext();
            Scheduler scheduler = (Scheduler)iniCtx.lookup(QuartzConstant.getQuartzName());
            scheduler.pauseJob(this.collectorID, "PERF_COLLECT");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (SchedulerException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        m_log.debug((Object)("pauseJob() end   : " + this.collectorID));
    }

    private void resumeJob() {
        m_log.debug((Object)("pauseJob() start : " + this.collectorID));
        try {
            InitialContext iniCtx = JNDIConnectionManager.getInitialContext();
            Scheduler scheduler = (Scheduler)iniCtx.lookup(QuartzConstant.getQuartzName());
            scheduler.resumeJob(this.collectorID, "PERF_COLLECT");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (SchedulerException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        m_log.debug((Object)("pauseJob() end   : " + this.collectorID));
    }

    private void deleteJob() {
        m_log.debug((Object)("deleteJob() start : " + this.collectorID));
        try {
            InitialContext iniCtx = JNDIConnectionManager.getInitialContext();
            Scheduler scheduler = (Scheduler)iniCtx.lookup(QuartzConstant.getQuartzName());
            scheduler.deleteJob(this.collectorID, "PERF_COLLECT");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (SchedulerException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        m_log.debug((Object)("deleteJob() end   : " + this.collectorID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchMibValue() {
        m_log.debug((Object)("fetchMibValue() start : " + this.collectorID + "  " + this.collectorType));
        try {
            try {
                if (this.scopeTree == null) {
                    m_log.debug((Object)("lost facility tree info. " + this.collectorID));
                } else {
                    try {
                        this.scopeTree.fetchMibValue(this.collectorID, this.facilityID);
                    }
                    catch (NotInitializedException e) {
                        m_log.warn((Object)("restart poller : " + this.collectorID), (Throwable)e);
                        this.startPoller();
                        Object var3_3 = null;
                        ++this.lifetimeCounter;
                        return;
                    }
                }
                this.setLastCollectDate(new Date(System.currentTimeMillis()));
                this.setCollectCount(this.getCount() + 1L);
            }
            catch (Exception e) {
                m_log.error((Object)"error in fetchMibValue()", (Throwable)e);
                this.setErrorStatus(2);
                Object var3_5 = null;
                ++this.lifetimeCounter;
            }
            Object var3_4 = null;
            ++this.lifetimeCounter;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            ++this.lifetimeCounter;
            throw throwable;
        }
        m_log.debug((Object)("fetchMibValue() end   : " + this.collectorID + "  " + this.collectorType));
    }

    public void storeCalcValue() {
        block7: {
            m_log.debug((Object)("storeCalcValue() start : " + this.collectorID + "  " + this.collectorType));
            try {
                if (this.scopeTree == null || this.items == null) {
                    m_log.debug((Object)"\u60c5\u5831\u3092\u5931\u3063\u3066\u3044\u307e\u3059");
                    break block7;
                }
                try {
                    long collectTime = this.scopeTree.fetchMibValue(this.collectorID, this.facilityID);
                    Date collectDate = new Date(collectTime);
                    String[] fids = this.scopeTree.getAllFacilityIdList();
                    for (int i = 0; i < this.items.length; ++i) {
                        for (int j = 0; j < fids.length; ++j) {
                            CollectedDataInfo data = this.getValue(fids[j], this.items[i]);
                            data.setDate(collectDate);
                            CalculatedDataDAO dao = new CalculatedDataDAO();
                            dao.insert(this.collectorID, data);
                        }
                    }
                    this.setLastCollectDate(new Date(this.scopeTree.getLastCollectTime()));
                    this.setCollectCount(this.getCount() + 1L);
                }
                catch (NotInitializedException e) {
                    m_log.warn((Object)("restart poller : " + this.collectorID), (Throwable)e);
                    this.startPoller();
                    return;
                }
            }
            catch (Exception e) {
                m_log.error((Object)"error in storeCalcValue()", (Throwable)e);
                this.setErrorStatus(2);
            }
        }
        m_log.debug((Object)("storeCalcValue() end   : " + this.collectorID + "  " + this.collectorType));
    }

    public void monitorCalcValue() {
        m_log.debug((Object)("monitorCalcValue() start : " + this.collectorID + "  " + this.collectorType));
        if (this.scopeTree == null || this.items == null) {
            m_log.debug((Object)"\u60c5\u5831\u3092\u5931\u3063\u3066\u3044\u307e\u3059");
            return;
        }
        try {
            try {
                this.scopeTree.fetchMibValue(this.collectorID, this.facilityID);
            }
            catch (NotInitializedException e) {
                m_log.warn((Object)("restart poller : " + this.collectorID), (Throwable)e);
                this.startPoller();
            }
            Collection mPerfInfos = MonitorPerfInfoUtil.getLocalHome().findAll();
            for (MonitorPerfInfoLocal monInfoLocal : mPerfInfos) {
                if (!monInfoLocal.getCollectorId().equals(this.collectorID)) continue;
                String monitorTypeId = monInfoLocal.getMonitorTypeId();
                String monitorId = monInfoLocal.getMonitorId();
                String itemCode = monInfoLocal.getItemCode();
                String deviceName = monInfoLocal.getDeviceName();
                CollectorItemInfo cii = null;
                for (int i = 0; i < this.items.length; ++i) {
                    if (!itemCode.equals(this.items[i].getItemCode()) || !deviceName.equals(this.items[i].getDeviceName())) continue;
                    cii = this.items[i];
                }
                if (cii == null) {
                    m_log.error((Object)("Not match CollectorItem. (code:" + itemCode + ", device name:" + deviceName + ")"));
                    return;
                }
                CollectedDataInfo data = this.getValue(this.facilityID, cii);
                RunMonitorPerformance2 runMonitor = new RunMonitorPerformance2();
                runMonitor.run(monitorTypeId, monitorId, data);
                Repository rep = new Repository();
                if (rep.isNode(this.facilityID)) continue;
                String[] nodeFids = this.scopeTree.getNodeIDList(this.facilityID);
                for (int j = 0; j < nodeFids.length; ++j) {
                    data = this.getValue(nodeFids[j], cii);
                    runMonitor = new RunMonitorPerformance2();
                    runMonitor.run(monitorTypeId, monitorId, data);
                }
            }
            this.setLastCollectDate(new Date(this.scopeTree.getLastCollectTime()));
            this.setCollectCount(this.getCount() + 1L);
        }
        catch (Exception e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        m_log.debug((Object)("monitorCalcValue() end   : " + this.collectorID + "  " + this.collectorType));
    }

    private void resetLifetimeCounter() {
        this.lifetimeCounter = 0;
    }

    public String getCollectorID() {
        return this.collectorID;
    }

    public void setCollectorID(String collectorID) {
        this.collectorID = collectorID;
    }

    public int getCollectorType() {
        return this.collectorType;
    }

    public void setCollectorType(int collectorType) {
        this.collectorType = collectorType;
    }

    public String getFacilityID() {
        return this.facilityID;
    }

    public void setFacilityID(String facilityID) {
        m_log.debug((Object)("setFacilityID() start : " + this.collectorID));
        this.facilityID = facilityID;
        m_log.debug((Object)("setFacilityID() end   : " + this.collectorID));
    }

    public void updateScopeTree() {
        m_log.debug((Object)("updateScopeTree() start : " + this.collectorID));
        FacilityTreeItem facilityTree = this.getFacilityTree();
        ArrayList<CollectorDeviceInfoData> allDeviceList = new ArrayList();
        HashMap<String, String> platformMap = null;
        if (this.collectorType == 1 || this.collectorType == 3) {
            allDeviceList = new Repository().getDeviceList(this.facilityID);
            platformMap = null;
        } else if (this.collectorID != null && this.collectorType == 2) {
            try {
                Collection beans = CollectorDeviceInfoUtil.getLocalHome().findByCollectorId(this.collectorID);
                for (CollectorDeviceInfoLocal bean : beans) {
                    allDeviceList.add(new CollectorDeviceInfoData(bean.getCollectorId(), bean.getFacilityId(), bean.getDeviceName(), bean.getIndex(), bean.getDeviceId(), bean.getDeviceType()));
                }
                platformMap = new HashMap<String, String>();
                Collection col = CollectorScopeSnapUtil.getLocalHome().findByCollectorId(this.collectorID);
                for (CollectorScopeSnapLocal bean : col) {
                    if (!bean.getFacilityType().equals("node")) continue;
                    platformMap.put(bean.getFacilityId(), bean.getPlatformId());
                }
            }
            catch (FinderException e) {
                m_log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (NamingException e) {
                m_log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (facilityTree != null && allDeviceList != null) {
            this.scopeTree = new ScopeTree(facilityTree, allDeviceList, platformMap, this.intervalSec);
        }
        m_log.debug((Object)("updateScopeTree() end   : " + this.collectorID));
    }

    public FacilityTreeItem getFacilityTree() {
        m_log.debug((Object)("getFacilityTree() collector type : " + this.collectorType));
        if (this.facilityID != null && (this.collectorType == 1 || this.collectorType == 3)) {
            return new Repository().getFacilityTree(this.facilityID);
        }
        if (this.collectorID != null && this.collectorType == 2) {
            return new FacilityTreeDB().getFacilityTree(this.collectorID);
        }
        return null;
    }

    public int getIntervalSec() {
        return this.intervalSec;
    }

    public void setIntervalSec(int intervalSec) {
        this.intervalSec = intervalSec;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int getPeriodMin() {
        return this.periodMin;
    }

    public void setPeriodMin(int periodMin) {
        this.periodMin = periodMin;
    }

    public long getCount() {
        return this.getCollectorStatus().getCount();
    }

    public Date getLastCollectDate() {
        return this.getCollectorStatus().getLastCollectDate();
    }

    public void setCollectCount(long count) {
        this.getCollectorStatus().setCount(count);
    }

    public void setErrorStatus(int status) {
        this.getCollectorStatus().setErrorStatus(status);
        int endStatus = this.getCollectorStatus().getEndStatus();
        if (endStatus == 0 && (status == 1 || status == 2)) {
            this.getCollectorStatus().setEndStatus(status);
        }
        if (endStatus == 1 && status == 2) {
            this.getCollectorStatus().setEndStatus(status);
        }
        if (endStatus != 2 && status == 2) {
            this.getCollectorStatus().setEndStatus(status);
        }
    }

    public String getScopePath() {
        return this.scopePath;
    }

    public void setScopePath(String scopePath) {
        this.scopePath = scopePath;
    }

    public Date getStartDate() {
        if (this.startTime != 0L) {
            return new Date(this.startTime);
        }
        return null;
    }

    public void setStartDate(Date startDate) {
        this.startTime = startDate != null ? startDate.getTime() : 0L;
    }

    public int getStatus() {
        try {
            JobDetail job;
            InitialContext iniCtx = JNDIConnectionManager.getInitialContext();
            Scheduler scheduler = (Scheduler)iniCtx.lookup(QuartzConstant.getQuartzName());
            try {
                job = scheduler.getJobDetail(this.collectorID, "PERF_COLLECT");
            }
            catch (SchedulerException e) {
                m_log.error((Object)e.getMessage(), (Throwable)e);
                return 400;
            }
            Trigger trigger = null;
            try {
                trigger = scheduler.getTrigger(this.collectorID, "PERF_COLLECT");
            }
            catch (SchedulerException e) {
                m_log.error((Object)e.getMessage(), (Throwable)e);
                return 400;
            }
            if (trigger == null) {
                if (this.getStartDate() == null) {
                    return 0;
                }
                return 300;
            }
            if (job.isDurable()) {
                return 100;
            }
            return 200;
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
    }

    public Date getStopDate() {
        if (this.stopTime == 0L || this.stopTime == Long.MAX_VALUE) {
            return null;
        }
        return new Date(this.stopTime);
    }

    public void setStopDate(Date stopDate) {
        this.stopTime = stopDate != null ? stopDate.getTime() : Long.MAX_VALUE;
    }

    public long getRealCollectPeriod() {
        Date lastCollect = this.getCollectorStatus().getLastCollectDate();
        if (lastCollect == null) {
            return 0L;
        }
        return lastCollect.getTime() - this.startTime;
    }

    private CollectorStatusLocal getCollectorStatus() {
        try {
            return CollectorStatusUtil.getLocalHome().findByPrimaryKey(new CollectorStatusPK(this.collectorID));
        }
        catch (FinderException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NamingException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public int getEndStatus() {
        return this.getCollectorStatus().getEndStatus();
    }

    public void setLastCollectDate(Date date) {
        this.getCollectorStatus().setLastCollectDate(date);
    }

    public boolean checkLifetime() {
        return 2 >= this.lifetimeCounter;
    }

    private void outputLog(String index, String[] messages) {
        AplLogger apllog = new AplLogger("PERF", "perf");
        apllog.put("SYS", index, (Object[])messages);
    }

    public boolean isMonitorFlag() {
        return false;
    }

    public int getPresavePeriod() {
        return this.presavePeriod;
    }

    public void setPresavePeriod(int presavePeriod) {
        this.presavePeriod = presavePeriod;
    }

    public void managePresave(Date startDate) {
        CalculatedDataDAO dao = new CalculatedDataDAO();
        dao.deleteOverPresave(this.collectorID, startDate);
        int count = dao.recountFromDB(this.collectorID);
        if (count > -1) {
            this.setCollectCount(count);
        }
    }
}

