/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.sharedtable;

import com.clustercontrol.poller.NotInitializedException;
import com.clustercontrol.sharedtable.DataTable;
import com.clustercontrol.sharedtable.DataTableCollection;
import com.clustercontrol.sharedtable.DataTableHolder;
import com.clustercontrol.sharedtable.DataTableNotFoundException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedTable {
    private static Log m_log = LogFactory.getLog(SharedTable.class);
    private Object lock = new Object();
    private static SharedTable m_instance = null;
    private long m_keepAlive = 60000L;
    private ConcurrentHashMap<TableInfo, DataTableCollection> m_tableMap = new ConcurrentHashMap();

    private SharedTable() {
    }

    public static synchronized SharedTable getInstance() {
        if (m_instance == null) {
            m_instance = new SharedTable();
        }
        return m_instance;
    }

    public void setKeepAlive(long keepAlive) {
        this.m_keepAlive = keepAlive;
    }

    public long getKeepAlive() {
        return this.m_keepAlive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDataTable(String tableGroup, String tableName, int pageSize) {
        Object object = this.lock;
        synchronized (object) {
            m_log.debug((Object)("creat table : " + tableName + "(" + tableGroup + ")"));
            if (pageSize < 1) {
                throw new IllegalArgumentException();
            }
            TableInfo info = new TableInfo(tableGroup, tableName);
            DataTableCollection dtc = this.m_tableMap.get(info);
            if (dtc != null && dtc.getPageSize() == pageSize) {
                return;
            }
            dtc = new DataTableCollection(pageSize, this.m_keepAlive);
            this.m_tableMap.put(info, dtc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataTable(String tableGroup, String tableName) {
        Object object = this.lock;
        synchronized (object) {
            m_log.debug((Object)("remove table : " + tableName + "(" + tableGroup + ")"));
            TableInfo info = new TableInfo(tableGroup, tableName);
            this.m_tableMap.remove(info);
        }
    }

    public void registerCollector(String tableGroup, String tableName, String collectorName, int interval) throws DataTableNotFoundException {
        TableInfo info = new TableInfo(tableGroup, tableName);
        DataTableCollection dtc = this.m_tableMap.get(info);
        if (dtc == null) {
            throw new DataTableNotFoundException(tableGroup, tableName);
        }
        dtc.creatDataTableHolder(collectorName, interval);
    }

    public void unregisterCollector(String tableGroup, String tableName, String collectorName) throws DataTableNotFoundException {
        TableInfo info = new TableInfo(tableGroup, tableName);
        DataTableCollection dtc = this.m_tableMap.get(info);
        if (dtc == null) {
            throw new DataTableNotFoundException(tableGroup, tableName);
        }
        dtc.removeCollectorName(collectorName);
    }

    public void insertDataTable(String tableGroup, String tableName, int interval, DataTable table, String checkKey) throws DataTableNotFoundException {
        TableInfo info = new TableInfo(tableGroup, tableName);
        DataTableCollection dtc = this.m_tableMap.get(info);
        if (dtc == null) {
            throw new DataTableNotFoundException(tableGroup, tableName);
        }
        try {
            dtc.insertDataTable(interval, table, checkKey);
        }
        catch (NotInitializedException e) {
            throw new DataTableNotFoundException(tableGroup, tableName);
        }
    }

    public boolean containsDataTable(String tableGroup, String tableName) {
        TableInfo info = new TableInfo(tableGroup, tableName);
        return this.m_tableMap.containsKey(info);
    }

    public boolean containsTable(String tableGroup, String tableName, int pageSize) {
        TableInfo info = new TableInfo(tableGroup, tableName);
        DataTableCollection dtc = this.m_tableMap.get(info);
        if (dtc == null) {
            return false;
        }
        return dtc.getPageSize() == pageSize;
    }

    public boolean containsCollectorName(String tableGroup, String tableName, String collectorName) throws DataTableNotFoundException {
        TableInfo info = new TableInfo(tableGroup, tableName);
        DataTableCollection dtc = this.m_tableMap.get(info);
        if (dtc == null) {
            throw new DataTableNotFoundException(tableGroup, tableName);
        }
        return dtc.containsCollectorName(collectorName);
    }

    public Set<Integer> getIntervals(String tableGroup, String tableName) throws DataTableNotFoundException {
        TableInfo info = new TableInfo(tableGroup, tableName);
        DataTableCollection dtc = this.m_tableMap.get(info);
        if (dtc == null) {
            throw new DataTableNotFoundException(tableGroup, tableName);
        }
        return dtc.getIntervals();
    }

    public Set<String> getCollectorNames(String tableGroup, String tableName) throws DataTableNotFoundException {
        TableInfo info = new TableInfo(tableGroup, tableName);
        DataTableCollection dtc = this.m_tableMap.get(info);
        if (dtc == null) {
            throw new DataTableNotFoundException(tableGroup, tableName);
        }
        return dtc.getCollectorNames();
    }

    public DataTable getDataTable(String tableGroup, String tableName, String collectorName, int pageIndex) throws DataTableNotFoundException, NotInitializedException {
        TableInfo info = new TableInfo(tableGroup, tableName);
        DataTableCollection dtc = this.m_tableMap.get(info);
        if (dtc == null) {
            throw new DataTableNotFoundException(tableGroup, tableName);
        }
        DataTableHolder tableHolder = dtc.getDataTableHolder(collectorName);
        if (tableHolder == null) {
            throw new NotInitializedException(collectorName + " is not registered in " + tableName + "(" + tableGroup + ")");
        }
        return tableHolder.get(pageIndex);
    }

    public List<DataTable> getLastDataTables(String tableGroup, String tableName, String collectorName, int pageSize) throws DataTableNotFoundException, NotInitializedException {
        TableInfo info = new TableInfo(tableGroup, tableName);
        DataTableCollection dtc = this.m_tableMap.get(info);
        if (dtc == null) {
            throw new DataTableNotFoundException(tableGroup, tableName);
        }
        DataTableHolder tableHolder = dtc.getDataTableHolder(collectorName);
        if (tableHolder == null) {
            throw new NotInitializedException(collectorName + " is not registered in " + tableName + "(" + tableGroup + ")");
        }
        return tableHolder.getLast(pageSize);
    }

    public void checkUnnecessaryTable() {
        long now = System.currentTimeMillis();
        Iterator<DataTableCollection> itr = this.m_tableMap.values().iterator();
        while (itr.hasNext()) {
            itr.next().checkAlive(now);
        }
    }

    public String getTableListDebugInfo() {
        TableInfo info;
        DataTableCollection col;
        String debugStr = "";
        Iterator itr = this.m_tableMap.keySet().iterator();
        while (itr.hasNext() && (col = this.m_tableMap.get(info = (TableInfo)itr.next())) != null) {
            Set<String> collectorNames = col.getCollectorNames();
            String txt = info.getTableGroup() + ", " + info.getTableName() + ", " + col.getPageSize();
            txt = txt + "\t(";
            TreeSet<Integer> intervals = new TreeSet<Integer>(col.getIntervals());
            Iterator<Integer> itrInter = intervals.iterator();
            while (itrInter.hasNext()) {
                int interval = itrInter.next();
                txt = txt + interval;
                if (!itrInter.hasNext()) continue;
                txt = txt + ", ";
            }
            txt = txt + ")\n";
            String collectorNameList = "";
            for (String collectorName : collectorNames) {
                collectorNameList = collectorNameList + "\t" + collectorName + "\t" + col.getInterval(collectorName) + "\t" + new Date(col.getLastReference(collectorName)) + "\n";
                String holderInfoTxt = "";
                DataTableHolder holder = col.getDataTableHolder(collectorName);
                if (holder != null) {
                    for (int i = 0; i < holder.getPageSize(); ++i) {
                        DataTable table = holder.get(i);
                        if (table == null) continue;
                        long lastModify = table.getLastModify();
                        holderInfoTxt = holderInfoTxt + "\t\t" + "page:" + i + "\t" + new Date(lastModify) + "\n";
                    }
                }
                collectorNameList = collectorNameList + holderInfoTxt;
            }
            txt = txt + collectorNameList + "\n";
            debugStr = debugStr + txt;
        }
        return debugStr;
    }

    private class TableInfo {
        private String m_tableGroup;
        private String m_tableName;

        public TableInfo(String tableGroup, String tableName) {
            this.m_tableGroup = tableGroup;
            this.m_tableName = tableName;
        }

        public String getTableGroup() {
            return this.m_tableGroup;
        }

        public String getTableName() {
            return this.m_tableName;
        }

        public boolean equals(Object other) {
            if (other instanceof TableInfo) {
                TableInfo info = (TableInfo)other;
                if (this.m_tableGroup == null && this.m_tableName == null) {
                    if (info.m_tableGroup == null && info.m_tableName == null) {
                        return true;
                    }
                } else if (this.m_tableGroup == null && this.m_tableName != null) {
                    if (info.m_tableGroup == null && this.m_tableName.equals(info.m_tableName)) {
                        return true;
                    }
                } else if (this.m_tableGroup != null && this.m_tableName == null) {
                    if (this.m_tableGroup.equals(info.m_tableGroup) && info.m_tableName == null) {
                        return true;
                    }
                } else if (this.m_tableGroup.equals(info.m_tableGroup)) {
                    return this.m_tableName.equals(info.m_tableName);
                }
                return false;
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.m_tableGroup != null ? this.m_tableGroup.hashCode() : 0);
            result = 37 * result + (this.m_tableName != null ? this.m_tableName.hashCode() : 0);
            return result;
        }
    }
}

