/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.commons.quartz;

import com.clustercontrol.commons.quartz.CustomQuartzServiceMBean;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.system.ServiceMBeanSupport;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;

public class CustomQuartzService
extends ServiceMBeanSupport
implements CustomQuartzServiceMBean {
    private String jndiName = "CustomQuartz";
    private StdSchedulerFactory schedulerFactory;
    private Properties properties = new Properties();

    public void setJndiName(String jndiName) throws Exception {
        this.log.info((Object)("STATE : " + this.getState()));
        String oldName = this.jndiName;
        this.jndiName = jndiName;
        if (super.getState() == 3) {
            try {
                this.unbind(oldName);
            }
            catch (NamingException e) {
                NamingException ne = new NamingException("Failed to unbind");
                ne.setRootCause(e);
                this.log.error((Object)ne.getMessage(), (Throwable)ne);
                throw ne;
            }
            try {
                this.rebind();
            }
            catch (NamingException e) {
                NamingException ne = new NamingException("Failed to rebind");
                ne.setRootCause(e);
                this.log.error((Object)ne);
                this.log.error((Object)ne.getMessage(), (Throwable)ne);
                throw ne;
            }
        }
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public String getName() {
        return "CustomQuartzService(" + this.jndiName + ")";
    }

    public void setProperties(String pro) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pro.getBytes());
        try {
            this.properties.load(inputStream);
        }
        catch (IOException e) {
            IOException ioe = new IOException("Failed to set properties.");
            this.log.error((Object)ioe.getMessage(), (Throwable)ioe);
        }
    }

    public String getProperties() {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.properties.store(outputStream, "");
            return new String(outputStream.toByteArray());
        }
        catch (IOException ioe) {
            return "";
        }
    }

    public String getSchedulerStatus() {
        try {
            Scheduler scheduler = this.schedulerFactory.getScheduler();
            if (scheduler.isPaused()) {
                return "Paused";
            }
            if (scheduler.isShutdown()) {
                return "Shutdown";
            }
            return "Started";
        }
        catch (SchedulerException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            return "Unknown";
        }
    }

    public void createService() throws Exception {
        this.log.info((Object)("Create CustomQuartzService(" + this.jndiName + ")..."));
        try {
            this.schedulerFactory = new StdSchedulerFactory();
            this.schedulerFactory.initialize(this.properties);
        }
        catch (SchedulerException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        this.log.info((Object)("CustomQuartzService(" + this.jndiName + ") created."));
    }

    public void startService() throws Exception {
        this.log.info((Object)("Start CustomQuartzService(" + this.jndiName + ")..."));
        try {
            this.rebind();
            String mode = System.getProperty("hinemos.manager.mode");
            if (mode == null || !"maintenance".equals(mode)) {
                this.startScheduler();
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        this.log.info((Object)("CustomQuartzService(" + this.jndiName + ") started."));
    }

    public void startScheduler() throws Exception {
        this.log.info((Object)("Start QuartzScheduler(" + this.jndiName + ")..."));
        try {
            Scheduler scheduler = this.schedulerFactory.getScheduler();
            scheduler.start();
        }
        catch (SchedulerException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        this.log.info((Object)("QuartzScheduler(" + this.jndiName + ") started."));
    }

    public void pauseScheduler() throws Exception {
        this.log.info((Object)("Pause QuartzScheduler(" + this.jndiName + ")..."));
        try {
            Scheduler scheduler = this.schedulerFactory.getScheduler();
            scheduler.pause();
        }
        catch (SchedulerException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        this.log.info((Object)("QuartzScheduler(" + this.jndiName + ") paused."));
    }

    public void stopService() throws Exception {
        this.log.info((Object)("Stop CustomQuartzService(" + this.jndiName + ")..."));
        try {
            Scheduler scheduler = this.schedulerFactory.getScheduler();
            scheduler.shutdown();
            this.unbind(this.jndiName);
        }
        catch (SchedulerException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (NamingException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        this.log.info((Object)("CustomQuartzService(" + this.jndiName + ") stopped."));
    }

    public void destroyService() throws Exception {
        this.log.info((Object)("Destroy CustomQuartzService(" + this.jndiName + ")..."));
        this.schedulerFactory = null;
        this.log.info((Object)("CustomQuartzService(" + this.jndiName + ") destroyed."));
    }

    private static Context createContext(Context rootCtx, Name name) throws NamingException {
        Context subctx = rootCtx;
        for (int n = 0; n < name.size(); ++n) {
            String atom = name.get(n);
            try {
                Object obj = subctx.lookup(atom);
                subctx = (Context)obj;
                continue;
            }
            catch (NamingException e) {
                subctx = subctx.createSubcontext(atom);
            }
        }
        return subctx;
    }

    private void rebind() throws Exception {
        Name fullName;
        InitialContext rootCtx = new InitialContext();
        Name parentName = fullName = rootCtx.getNameParser("").parse(this.jndiName);
        parentName = fullName.size() > 1 ? fullName.getPrefix(fullName.size() - 1) : new CompositeName();
        Context parentCtx = CustomQuartzService.createContext(rootCtx, parentName);
        Name atomName = fullName.getSuffix(fullName.size() - 1);
        String atomStirng = atomName.get(0);
        NonSerializableFactory.rebind((Context)parentCtx, (String)atomStirng, (Object)this.schedulerFactory.getScheduler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbind(String jndiName) throws NamingException {
        InitialContext rootCtx = null;
        try {
            rootCtx = new InitialContext();
            Name fullName = rootCtx.getNameParser("").parse(jndiName);
            Name atomName = fullName.getSuffix(fullName.size() - 1);
            String atom = atomName.get(0);
            rootCtx.unbind(jndiName);
            NonSerializableFactory.unbind((String)atom);
        }
        finally {
            if (rootCtx != null) {
                rootCtx.close();
            }
        }
    }
}

