/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.factory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.commons.util.SendQueue;
import com.clustercontrol.notify.bean.NotifyInfoContext;
import com.clustercontrol.notify.ejb.entity.NotifyEventInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyInfoUtil;
import com.clustercontrol.notify.ejb.entity.NotifyJobInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyLogEscalateInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyMailInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyStatusInfoLocal;
import com.clustercontrol.notify.factory.DeleteNotifyInhibition;
import com.clustercontrol.notify.factory.DeleteNotifyRelation;
import com.clustercontrol.util.apllog.AplLogger;
import java.io.Serializable;
import java.util.Collection;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeleteNotify {
    protected static Log m_log = LogFactory.getLog(DeleteNotify.class);

    public boolean delete(String notifyId) throws FinderException, RemoveException, NamingException, JMSException {
        AccessLock.lock((String)"NOTIFY");
        NotifyInfoLocal notify = null;
        SendQueue queue = null;
        try {
            notify = NotifyInfoUtil.getLocalHome().findByPrimaryKey(notifyId);
            this.deleteDetails(notify);
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{notifyId};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("delete():" + e.getMessage()));
            throw e;
        }
        catch (RemoveException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{notifyId};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("delete():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{notifyId};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("delete():" + e.getMessage()));
            throw e;
        }
        try {
            this.deleteRelation(notifyId);
            this.deleteInhibition(notifyId);
            notify.remove();
            NotifyInfoContext context = new NotifyInfoContext(2, notifyId, null);
            queue = new SendQueue("queue/clustercontrolNotifyControl");
            queue.put((Serializable)context);
            queue.terminate();
        }
        catch (RemoveException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{notifyId};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("getNotify():" + e.getMessage()));
            throw e;
        }
        catch (JMSException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{notifyId};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("add():" + e.getMessage()));
            throw e;
        }
        finally {
            if (queue != null) {
                queue.terminate();
            }
        }
        return true;
    }

    public boolean deleteDetails(NotifyInfoLocal notify) throws RemoveException {
        Integer notifyType = notify.getNotifyType();
        if (notifyType == 0) {
            Collection ct = notify.getNotifyStatusInfo();
            return this.deleteStatus(ct);
        }
        if (notifyType == 1) {
            Collection ct = notify.getNotifyEventInfo();
            return this.deleteEvents(ct);
        }
        if (notifyType == 2) {
            Collection ct = notify.getNotifyMailInfo();
            return this.deleteMails(ct);
        }
        if (notifyType == 3) {
            Collection ct = notify.getNotifyJobInfo();
            return this.deleteJobs(ct);
        }
        if (notifyType == 4) {
            Collection ct = notify.getNotifyLogEscalateInfo();
            return this.deleteLogEscalate(ct);
        }
        return false;
    }

    public boolean deleteStatus(Collection ct) throws RemoveException {
        if (ct != null && ct.size() > 0) {
            Object[] eventArray = ct.toArray();
            for (int j = 0; j < eventArray.length; ++j) {
                NotifyStatusInfoLocal event = (NotifyStatusInfoLocal)eventArray[j];
                if (event == null) continue;
                event.remove();
            }
        }
        return true;
    }

    public boolean deleteEvents(Collection ct) throws RemoveException {
        if (ct != null && ct.size() > 0) {
            Object[] eventArray = ct.toArray();
            for (int j = 0; j < eventArray.length; ++j) {
                NotifyEventInfoLocal event = (NotifyEventInfoLocal)eventArray[j];
                if (event == null) continue;
                event.remove();
            }
        }
        return true;
    }

    public boolean deleteMails(Collection ct) throws RemoveException {
        if (ct != null && ct.size() > 0) {
            Object[] eventArray = ct.toArray();
            for (int j = 0; j < eventArray.length; ++j) {
                NotifyMailInfoLocal event = (NotifyMailInfoLocal)eventArray[j];
                if (event == null) continue;
                event.remove();
            }
        }
        return true;
    }

    public boolean deleteJobs(Collection ct) throws RemoveException {
        if (ct != null && ct.size() > 0) {
            Object[] eventArray = ct.toArray();
            for (int j = 0; j < eventArray.length; ++j) {
                NotifyJobInfoLocal event = (NotifyJobInfoLocal)eventArray[j];
                if (event == null) continue;
                event.remove();
            }
        }
        return true;
    }

    public boolean deleteLogEscalate(Collection ct) throws RemoveException {
        if (ct != null && ct.size() > 0) {
            Object[] eventArray = ct.toArray();
            for (int j = 0; j < eventArray.length; ++j) {
                NotifyLogEscalateInfoLocal event = (NotifyLogEscalateInfoLocal)eventArray[j];
                if (event == null) continue;
                event.remove();
            }
        }
        return true;
    }

    public boolean deleteRelation(String notifyId) {
        DeleteNotifyRelation deleteRelation = new DeleteNotifyRelation();
        deleteRelation.deleteBaseOnNotifyId(notifyId);
        return true;
    }

    public boolean deleteInhibition(String notifyId) {
        DeleteNotifyInhibition deleteInhibition = new DeleteNotifyInhibition();
        deleteInhibition.deleteBaseOnNotifyId(notifyId);
        return true;
    }
}

