/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.ejb.session;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.notify.bean.NotifyRelationInfo;
import com.clustercontrol.notify.ejb.entity.NotifyActionInhibitionInfoData;
import com.clustercontrol.notify.ejb.entity.NotifyInfoLocal;
import com.clustercontrol.notify.factory.AddNotify;
import com.clustercontrol.notify.factory.AddNotifyInhibition;
import com.clustercontrol.notify.factory.AddNotifyRelation;
import com.clustercontrol.notify.factory.DeleteNotify;
import com.clustercontrol.notify.factory.DeleteNotifyInhibition;
import com.clustercontrol.notify.factory.DeleteNotifyRelation;
import com.clustercontrol.notify.factory.ModifyNotify;
import com.clustercontrol.notify.factory.ModifyNotifyInhibition;
import com.clustercontrol.notify.factory.ModifyNotifyRelation;
import com.clustercontrol.notify.factory.SelectNotify;
import com.clustercontrol.notify.factory.SelectNotifyRelation;
import com.clustercontrol.util.Messages;
import java.rmi.RemoteException;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.jms.JMSException;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NotifyControllerBean
implements SessionBean {
    private SessionContext m_context;

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.m_context = ctx;
    }

    public boolean addNotify(NotifyInfo info) throws CreateException, NamingException, JMSException {
        Principal pri = this.m_context.getCallerPrincipal();
        AddNotify notify = new AddNotify();
        return notify.add(info, pri.getName());
    }

    public boolean modifyNotify(NotifyInfo info) throws CreateException, FinderException, RemoveException, NamingException, JMSException {
        Principal pri = this.m_context.getCallerPrincipal();
        ModifyNotify notify = new ModifyNotify();
        return notify.modify(info, pri.getName());
    }

    public boolean deleteNotify(String notifyId) throws FinderException, RemoveException, NamingException, JMSException {
        DeleteNotify notify = new DeleteNotify();
        return notify.delete(notifyId);
    }

    public NotifyInfo getNotify(String notifyId) throws FinderException, NamingException {
        SelectNotify notify = new SelectNotify();
        NotifyInfo info = notify.getNotify(notifyId);
        return info;
    }

    public ArrayList getNotifyIdList() throws CreateException, FinderException, NamingException {
        SelectNotify notify = new SelectNotify();
        ArrayList list = notify.getNotifyIdList();
        return list;
    }

    public ArrayList getNotifyList() throws CreateException, FinderException, NamingException {
        SelectNotify notify = new SelectNotify();
        ArrayList<NotifyInfoLocal> list = notify.getNotifyList();
        return list;
    }

    public HashMap<String, NotifyInfo> getNotifyMap() throws FinderException, NamingException {
        SelectNotify notify = new SelectNotify();
        HashMap<String, NotifyInfo> map = notify.getNotifyMap();
        return map;
    }

    public ArrayList getTroubleDetectionNotifyList() throws CreateException, FinderException, NamingException {
        SelectNotify notify = new SelectNotify();
        ArrayList<NotifyInfoLocal> list = notify.getTroubleDetectionNotifyList();
        return list;
    }

    public HashMap<String, NotifyInfo> getTroubleDetectionNotifyMap() throws FinderException, NamingException {
        SelectNotify notify = new SelectNotify();
        HashMap<String, NotifyInfo> map = notify.getTroubleDetectionNotifyMap();
        return map;
    }

    public ArrayList getNotifyListTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo("", 15, 60, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"valid", (Locale)locale) + "/" + Messages.getString((String)"invalid", (Locale)locale), 4, 80, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"notify.id", (Locale)locale), -1, 80, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"description", (Locale)locale), -1, 300, 16384));
        tableDefine.add(4, new TableColumnInfo(Messages.getString((String)"notify.type.list", (Locale)locale), -1, 100, 16384));
        tableDefine.add(5, new TableColumnInfo(Messages.getString((String)"update.time", (Locale)locale), -1, 150, 16384));
        return tableDefine;
    }

    public Collection getNotifyRelation(String notifyGroupId) throws FinderException, NamingException {
        SelectNotifyRelation notify = new SelectNotifyRelation();
        Collection<NotifyRelationInfo> info = notify.getNotifyRelation(notifyGroupId);
        return info;
    }

    public boolean modifyNotifyRelation(Collection info, String notifyGroupId) throws CreateException, FinderException, RemoveException, NamingException {
        ModifyNotifyRelation notify = new ModifyNotifyRelation();
        return notify.modify(info, notifyGroupId);
    }

    public boolean deleteNotifyRelation(String notifyGroupId) throws FinderException, RemoveException, NamingException {
        DeleteNotifyRelation notify = new DeleteNotifyRelation();
        return notify.delete(notifyGroupId);
    }

    public boolean addNotifyRelation(Collection info) throws CreateException, NamingException {
        if (info != null) {
            AddNotifyRelation notify = new AddNotifyRelation();
            return notify.add(info);
        }
        return true;
    }

    public boolean deleteNotifyInhibition(String notifyGroupId) throws FinderException, RemoveException, NamingException {
        DeleteNotifyInhibition notify = new DeleteNotifyInhibition();
        return notify.deleteBaseOnNotifyGroupId(notifyGroupId);
    }

    public boolean deleteNotifyInhibitionEvent(String notifyGroupId, String facilityId, Timestamp generateDate, int priority) throws RemoveException, NamingException {
        DeleteNotifyInhibition notify = new DeleteNotifyInhibition();
        return notify.deleteEvent(notifyGroupId, facilityId, generateDate, priority);
    }

    public boolean modifyNotifyInhibition(String notifyGroupId) throws CreateException, FinderException, RemoveException, NamingException {
        ModifyNotifyInhibition notify = new ModifyNotifyInhibition();
        return notify.modify(notifyGroupId);
    }

    public boolean addNotifyInhibition(NotifyActionInhibitionInfoData data) throws CreateException, NamingException {
        if (data != null) {
            AddNotifyInhibition notify = new AddNotifyInhibition();
            return notify.add(data);
        }
        return true;
    }

    public ArrayList<String> checkNotifyId(String notifyId) throws FinderException, NamingException {
        ArrayList<String> ret = null;
        SelectNotifyRelation notify = new SelectNotifyRelation();
        ret = notify.getNotifyGroupIdBaseOnNotifyId(notifyId);
        return ret;
    }
}

