/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.factory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.commons.util.SendQueue;
import com.clustercontrol.notify.bean.NotifyEventInfo;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.notify.bean.NotifyInfoContext;
import com.clustercontrol.notify.bean.NotifyJobInfo;
import com.clustercontrol.notify.bean.NotifyLogEscalateInfo;
import com.clustercontrol.notify.bean.NotifyMailInfo;
import com.clustercontrol.notify.bean.NotifyStatusInfo;
import com.clustercontrol.notify.ejb.entity.NotifyEventInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyEventInfoUtil;
import com.clustercontrol.notify.ejb.entity.NotifyInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyInfoUtil;
import com.clustercontrol.notify.ejb.entity.NotifyJobInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyJobInfoUtil;
import com.clustercontrol.notify.ejb.entity.NotifyLogEscalateInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyLogEscalateInfoUtil;
import com.clustercontrol.notify.ejb.entity.NotifyMailInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyMailInfoUtil;
import com.clustercontrol.notify.ejb.entity.NotifyStatusInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyStatusInfoUtil;
import com.clustercontrol.util.apllog.AplLogger;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.ejb.CreateException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddNotify {
    protected static Log m_log = LogFactory.getLog(AddNotify.class);

    public boolean add(NotifyInfo info, String user) throws CreateException, NamingException, JMSException {
        AccessLock.lock((String)"NOTIFY");
        SendQueue queue = null;
        try {
            Timestamp now = new Timestamp(new Date().getTime());
            NotifyInfoLocal notify = NotifyInfoUtil.getLocalHome().create(info.getNotifyId(), info.getDescription(), info.getNotifyType(), info.getInhibitionFlg(), info.getInhibitionFrequency(), info.getInhibitionPeriod(), now, now, user, user, info.getValidFlg());
            this.addDetails(info, notify);
            NotifyInfoContext context = new NotifyInfoContext(0, info.getNotifyId(), info);
            queue = new SendQueue("queue/clustercontrolNotifyControl");
            queue.put((Serializable)context);
            queue.terminate();
        }
        catch (CreateException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{info.getNotifyId()};
            apllog.put("SYS", "001", args);
            m_log.debug((Object)("add():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{info.getNotifyId()};
            apllog.put("SYS", "001", args);
            m_log.debug((Object)("add():" + e.getMessage()));
            throw e;
        }
        catch (JMSException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{info.getNotifyId()};
            apllog.put("SYS", "001", args);
            m_log.debug((Object)("add():" + e.getMessage()));
            throw e;
        }
        finally {
            if (queue != null) {
                queue.terminate();
            }
        }
        return true;
    }

    public boolean addDetails(NotifyInfo info, NotifyInfoLocal notify) throws CreateException, NamingException {
        Collection ct = null;
        ArrayList<Object> localList = null;
        ArrayList eventList = info.getNotifyInfoDetail();
        if (info.getNotifyType() == 0) {
            ct = notify.getNotifyStatusInfo();
            localList = new ArrayList<Object>();
            NotifyStatusInfo status = null;
            for (int index = 0; index < eventList.size(); ++index) {
                status = (NotifyStatusInfo)eventList.get(index);
                if (status == null) continue;
                NotifyStatusInfoLocal local = NotifyStatusInfoUtil.getLocalHome().create(info.getNotifyId(), status.getPriority(), status.getValidFlg(), status.getInhibitionFlg(), status.getStatusValidPeriod(), status.getStatusInvalidFlg(), status.getStatusUpdatePriority());
                localList.add(local);
            }
            if (localList != null && ct != null) {
                ct.addAll(localList);
                notify.setNotifyStatusInfo(ct);
            }
        } else if (info.getNotifyType() == 1) {
            ct = notify.getNotifyEventInfo();
            localList = new ArrayList();
            NotifyEventInfo event = null;
            for (int index = 0; index < eventList.size(); ++index) {
                event = (NotifyEventInfo)eventList.get(index);
                if (event == null) continue;
                NotifyEventInfoLocal local = NotifyEventInfoUtil.getLocalHome().create(info.getNotifyId(), event.getPriority(), event.getValidFlg(), event.getEventNormalState(), event.getInhibitionFlg(), event.getEventInhibitionState());
                localList.add(local);
            }
            if (localList != null && ct != null) {
                ct.addAll(localList);
                notify.setNotifyEventInfo(ct);
            }
        } else if (info.getNotifyType() == 2) {
            ct = notify.getNotifyMailInfo();
            localList = new ArrayList();
            NotifyMailInfo mail = null;
            for (int index = 0; index < eventList.size(); ++index) {
                mail = (NotifyMailInfo)eventList.get(index);
                if (mail == null) continue;
                NotifyMailInfoLocal local = NotifyMailInfoUtil.getLocalHome().create(info.getNotifyId(), mail.getPriority(), mail.getMailTemplateId(), mail.getValidFlg(), mail.getInhibitionFlg(), mail.getMailAddress());
                localList.add(local);
            }
            if (localList != null && ct != null) {
                ct.addAll(localList);
                notify.setNotifyMailInfo(ct);
            }
        } else if (info.getNotifyType() == 3) {
            ct = notify.getNotifyJobInfo();
            localList = new ArrayList();
            NotifyJobInfo job = null;
            for (int index = 0; index < eventList.size(); ++index) {
                job = (NotifyJobInfo)eventList.get(index);
                if (job == null) continue;
                NotifyJobInfoLocal local = NotifyJobInfoUtil.getLocalHome().create(info.getNotifyId(), job.getPriority(), job.getValidFlg(), job.getJobId(), job.getInhibitionFlg(), job.getJobFailurePriority(), job.getJobExecFacilityFlg(), job.getJobExecFacility());
                localList.add(local);
            }
            if (localList != null && ct != null) {
                ct.addAll(localList);
                notify.setNotifyJobInfo(ct);
            }
        } else if (info.getNotifyType() == 4) {
            ct = notify.getNotifyLogEscalateInfo();
            localList = new ArrayList();
            NotifyLogEscalateInfo log = null;
            for (int index = 0; index < eventList.size(); ++index) {
                log = (NotifyLogEscalateInfo)eventList.get(index);
                if (log == null) continue;
                NotifyLogEscalateInfoLocal local = NotifyLogEscalateInfoUtil.getLocalHome().create(info.getNotifyId(), log.getPriority(), log.getValidFlg(), log.getInhibitionFlg(), log.getEscalateMessage(), log.getSyslogPriority(), log.getSyslogFacility(), log.getEscalateFacilityFlg(), log.getEscalateFacility(), log.getEscalatePort());
                localList.add(local);
            }
            if (localList != null && ct != null) {
                ct.addAll(localList);
                notify.setNotifyLogEscalateInfo(ct);
            }
        }
        return true;
    }
}

