/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.util;

import com.clustercontrol.bean.OutputNotifyGroupInfo;
import com.clustercontrol.notify.ejb.entity.NotifyActionInhibitionInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyActionInhibitionInfoPK;
import com.clustercontrol.notify.ejb.entity.NotifyActionInhibitionInfoUtil;
import com.clustercontrol.notify.ejb.entity.NotifyInfoLocal;
import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InhibitAction {
    protected static Log m_log = LogFactory.getLog(InhibitAction.class);
    protected NotifyInfoLocal m_notifyInfo = null;
    protected NotifyActionInhibitionInfoLocal m_inhibitInfo = null;

    protected boolean isInhibit(OutputNotifyGroupInfo outputInfo, NotifyInfoLocal notifyInfo) throws RemoteException, NamingException, NumberFormatException, CreateException {
        boolean isInhibit = false;
        this.m_notifyInfo = notifyInfo;
        String notifyGroupId = outputInfo.getNotifyGroupId();
        String notifyId = notifyInfo.getNotifyId();
        String facilityId = outputInfo.getFacilityId();
        int priority = outputInfo.getPriority();
        Date generationDate = outputInfo.getGenerationDate();
        NotifyActionInhibitionInfoPK inhibitionPk = new NotifyActionInhibitionInfoPK(notifyGroupId, notifyId, facilityId);
        try {
            this.m_inhibitInfo = NotifyActionInhibitionInfoUtil.getLocalHome().findByPrimaryKey(inhibitionPk);
        }
        catch (FinderException e) {
            NotifyActionInhibitionInfoUtil.getLocalHome().create(notifyGroupId, notifyId, facilityId, priority, new Timestamp(generationDate.getTime()), new Timestamp(generationDate.getTime()), new Long(0L), new Long(1L));
            return false;
        }
        if (notifyInfo.getInhibitionFlg() == 2) {
            isInhibit = this.isInhibitPeriod(generationDate);
        } else if (notifyInfo.getInhibitionFlg() == 1) {
            isInhibit = this.isInhibitFrequency();
        } else if (notifyInfo.getInhibitionFlg() == 3) {
            isInhibit = this.isInhibitPriority(priority);
        } else {
            m_log.debug((Object)"inhibit() : \u3069\u306e\u6291\u5236\u30bf\u30a4\u30d7\u306b\u3082\u5f53\u3066\u306f\u307e\u308a\u307e\u305b\u3093\u3002");
            return false;
        }
        this.inhibitUpdate(isInhibit, priority, generationDate);
        return isInhibit;
    }

    protected boolean isInhibitPeriod(Date generationDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.m_inhibitInfo.getLastNotifyDate());
        cal.add(12, this.m_notifyInfo.getInhibitionPeriod());
        return cal.getTime().after(generationDate);
    }

    protected boolean isInhibitFrequency() {
        return this.m_inhibitInfo.getDupuricationCount().intValue() < this.m_notifyInfo.getInhibitionFrequency();
    }

    protected boolean isInhibitPriority(int priority) {
        return this.m_inhibitInfo.getPriority() == priority;
    }

    protected void inhibitUpdate(boolean isInhibit, int priority, Date generationDate) {
        this.m_inhibitInfo.setPriority(priority);
        this.m_inhibitInfo.setTotalCount(this.m_inhibitInfo.getTotalCount() + 1L);
        this.m_inhibitInfo.setLastUpdateDate(new Timestamp(generationDate.getTime()));
        if (isInhibit) {
            this.m_inhibitInfo.setDupuricationCount(this.m_inhibitInfo.getDupuricationCount() + 1L);
        } else {
            this.m_inhibitInfo.setLastNotifyDate(new Timestamp(generationDate.getTime()));
            this.m_inhibitInfo.setDupuricationCount(new Long(0L));
        }
    }
}

