/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.util;

import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityPath;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorDeviceInfoData;
import com.clustercontrol.repository.ejb.entity.DeviceInfoData;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Repository {
    private static Log m_log = LogFactory.getLog(Repository.class);

    public static String getPlatformId(String facilityId) {
        try {
            RepositoryControllerLocal bean = RepositoryControllerUtil.getLocalHome().create();
            String key = "ccPlatform";
            ArrayList<String> attributeList = new ArrayList<String>();
            attributeList.add(key);
            HashMap facilityAttrMap = bean.getNodeDetail(facilityId, attributeList);
            String platformId = (String)facilityAttrMap.get(key);
            return platformId;
        }
        catch (CreateException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
            throw new EJBException((Exception)((Object)e));
        }
    }

    public FacilityTreeItem getFacilityTree(String facilityID) {
        try {
            RepositoryControllerLocal bean = RepositoryControllerUtil.getLocalHome().create();
            FacilityTreeItem facilityTree = bean.getFacilityTree(Locale.getDefault());
            bean.remove();
            FacilityTreeItem subFacilityTree = this.selectFacilityTreeItem(facilityTree, facilityID);
            if (subFacilityTree == null) {
                String message = "Facility not found : " + facilityID;
                return null;
            }
            FacilityInfo info = new FacilityInfo();
            info.setFacilityName("");
            info.setType(2);
            FacilityTreeItem top = new FacilityTreeItem(null, info);
            subFacilityTree.setParent(top);
            top.addChildren(subFacilityTree);
            return top;
        }
        catch (CreateException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (RemoveException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
            throw new EJBException((Exception)((Object)e));
        }
        return null;
    }

    public String getFacilityPath(String facilityID) {
        try {
            RepositoryControllerLocal bean = RepositoryControllerUtil.getLocalHome().create();
            FacilityTreeItem facilityTree = bean.getFacilityTree(Locale.getDefault());
            bean.remove();
            FacilityTreeItem treeItem = this.selectFacilityTreeItem(facilityTree, facilityID);
            if (treeItem == null) {
                String message = "Facility not found : " + facilityID;
                throw new EJBException(message);
            }
            FacilityPath fpath = new FacilityPath(">");
            return fpath.getPath(treeItem);
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (RemoveException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public List<CollectorDeviceInfoData> getDeviceList(String facilityID) {
        try {
            RepositoryControllerLocal bean = RepositoryControllerUtil.getLocalHome().create();
            ArrayList<CollectorDeviceInfoData> deviceList = new ArrayList<CollectorDeviceInfoData>();
            ArrayList nodeList = null;
            nodeList = facilityID == null ? bean.getNodeFacilityIdList() : bean.getExecTargetFacilityIdList(facilityID);
            for (String nodeID : nodeList) {
                ArrayList dl = bean.getDeviceList(nodeID);
                for (DeviceInfoData did : dl) {
                    CollectorDeviceInfoData device = new CollectorDeviceInfoData(null, did.getFacilityId(), did.getDeviceName(), did.getDeviceIndex().longValue(), did.getSnmpOID(), did.getDeviceType());
                    deviceList.add(device);
                }
            }
            bean.remove();
            return deviceList;
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (RemoveException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    private FacilityTreeItem selectFacilityTreeItem(FacilityTreeItem facilityTree, String facilityID) {
        if (facilityTree.getData().getFacilityId().equals(facilityID)) {
            return facilityTree;
        }
        for (int i = 0; i < facilityTree.getChildren().length; ++i) {
            FacilityTreeItem target = facilityTree.getChildren()[i];
            FacilityTreeItem temp = this.selectFacilityTreeItem(target, facilityID);
            if (temp == null) continue;
            return temp;
        }
        return null;
    }

    public String getIPAddress(String facilityID) {
        HashMap nodeInfo = new HashMap();
        try {
            RepositoryControllerLocal bean = RepositoryControllerUtil.getLocalHome().create();
            ArrayList<String> attributes = new ArrayList<String>();
            attributes.add("ipNetworkNumber");
            nodeInfo = bean.getNodeDetail(facilityID, attributes);
            bean.remove();
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (RemoveException e) {
            throw new EJBException((Exception)((Object)e));
        }
        if (nodeInfo != null) {
            return (String)nodeInfo.get("ipNetworkNumber");
        }
        String message = "Couldn't get an IP Address : " + facilityID;
        throw new EJBException(message);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public boolean isNode(String facilityID) {
        RepositoryControllerLocal bean = null;
        bean = RepositoryControllerUtil.getLocalHome().create();
        boolean bl = bean.isNode(facilityID);
        Object var5_7 = null;
        try {
            bean.remove();
        }
        catch (EJBException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (RemoveException e) {
            throw new EJBException((Exception)((Object)e));
        }
        {
            return bl;
            catch (CreateException e) {
                throw new EJBException((Exception)((Object)e));
            }
            catch (NamingException e) {
                throw new EJBException((Exception)e);
            }
            catch (FinderException e) {
                throw new EJBException((Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            try {
                bean.remove();
            }
            catch (EJBException e) {
                throw new EJBException((Exception)((Object)e));
            }
            catch (RemoveException e) {
                throw new EJBException((Exception)((Object)e));
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    public ArrayList<ArrayList<String>> getNodeList(String facilityID) {
        RepositoryControllerLocal bean = null;
        ArrayList nodeList = null;
        bean = RepositoryControllerUtil.getLocalHome().create();
        nodeList = bean.getNodeList(facilityID, 0);
        Object var6_4 = null;
        try {
            bean.remove();
        }
        catch (EJBException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (RemoveException e) {
            throw new EJBException((Exception)((Object)e));
        }
        {
            catch (CreateException e) {
                throw new EJBException((Exception)((Object)e));
            }
            catch (NamingException e) {
                throw new EJBException((Exception)e);
            }
            catch (FinderException e) {
                throw new EJBException((Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            try {
                bean.remove();
            }
            catch (EJBException e) {
                throw new EJBException((Exception)((Object)e));
            }
            catch (RemoveException e) {
                throw new EJBException((Exception)((Object)e));
            }
            throw throwable;
        }
        return nodeList;
    }
}

