/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmptrap.ejb.mdb;

import com.clustercontrol.bean.OutputNotifyGroupInfo;
import com.clustercontrol.commons.util.SendQueue;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapInfo;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapOidInfo;
import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterPK;
import com.clustercontrol.snmptrap.factory.SelectMonitorInfo;
import com.clustercontrol.snmptrap.factory.TrapSnmp;
import com.clustercontrol.snmptrap.message.SnmpTrapMessageInfo;
import com.clustercontrol.util.Messages;
import java.io.Serializable;
import java.util.ArrayList;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NotifySnmpTrapBean
implements MessageDrivenBean,
MessageListener {
    protected static Log m_log = LogFactory.getLog(NotifySnmpTrapBean.class);
    private MessageDrivenContext messageContext = null;

    public void setMessageDrivenContext(MessageDrivenContext messageContext) throws EJBException {
        this.messageContext = messageContext;
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
        this.messageContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void onMessage(Message message) {
        block19: {
            Serializable obj;
            block22: {
                RepositoryControllerLocal repository;
                block18: {
                    block25: {
                        SnmpTrapMasterInfo master;
                        SnmpTrapMasterPK pk;
                        String msgOrg;
                        String msg;
                        int priority;
                        String mib;
                        MonitorSnmpTrapOidInfo oidInfo;
                        int i;
                        MonitorSnmpTrapInfo snmpTrapInfo;
                        SelectMonitorInfo select;
                        int specificId;
                        int genericId;
                        String trapOid;
                        String facilityPath;
                        SnmpTrapMessageInfo info;
                        block26: {
                            SnmpTrapMasterInfo master2;
                            block23: {
                                SnmpTrapMasterInfo master3;
                                block24: {
                                    m_log.debug((Object)"onMessage() : start");
                                    if (!(message instanceof ObjectMessage)) break block19;
                                    ObjectMessage objectMessage = (ObjectMessage)message;
                                    obj = null;
                                    try {
                                        obj = objectMessage.getObject();
                                    }
                                    catch (JMSException e) {
                                        return;
                                    }
                                    if (!(obj instanceof SnmpTrapMessageInfo)) break block22;
                                    repository = null;
                                    repository = RepositoryControllerUtil.getLocalHome().create();
                                    info = (SnmpTrapMessageInfo)obj;
                                    String monitorId = info.getMonitorId();
                                    String facilityId = info.getFacilityId();
                                    facilityPath = info.getFacilityId().equals("UNREGISTERED") ? info.getAgentAdder() : repository.getFacilityPath(facilityId, null);
                                    trapOid = info.getTrapOid();
                                    genericId = info.getGenericId();
                                    specificId = info.getSpecificId();
                                    m_log.debug((Object)("onMessage() : received trap :" + trapOid + ":" + genericId + ":" + specificId));
                                    select = new SelectMonitorInfo();
                                    snmpTrapInfo = select.getMonitorInfo(monitorId);
                                    if (snmpTrapInfo.getCheckMode() != 1) break block23;
                                    m_log.debug((Object)"onMessage() : checkmode ALL_OID : search from masterdb. ");
                                    master3 = select.findMasterInfo(trapOid, genericId, specificId);
                                    if (master3 == null || master3.getMib() == null) break block24;
                                    String msg2 = master3.getLogmsg();
                                    String msgOrg2 = master3.getDescr();
                                    int priority2 = master3.getPriority();
                                    this.sendMassage(msg2, msgOrg2, info, master3, priority2, snmpTrapInfo, facilityPath);
                                    m_log.debug((Object)"onMessage() : sendmessage ");
                                    break block25;
                                }
                                master3 = select.findMasterInfo(TrapSnmp.GENERIC_TRAPS.get(genericId).toString(), genericId, specificId);
                                if (master3 == null || master3.getMib() == null) break block25;
                                String msg3 = master3.getLogmsg();
                                String msgOrg3 = master3.getDescr();
                                int priority3 = master3.getPriority();
                                this.sendMassage(msg3, msgOrg3, info, master3, priority3, snmpTrapInfo, facilityPath);
                                m_log.debug((Object)"onMessage() : sendmessage( change to generic trap ) ");
                                break block25;
                            }
                            if (snmpTrapInfo.getCheckMode() != 2) break block26;
                            m_log.debug((Object)"onMessage() : unregisterd trap  ");
                            if (genericId != 6 || (master2 = select.findMasterInfo(trapOid, genericId, specificId)) == null || master2.getMib() != null) break block25;
                            String msg4 = "oid  : " + trapOid + " specificId : " + specificId + " generic_id : " + genericId;
                            String msgOrg4 = "";
                            int priority4 = 1;
                            this.sendMassage(msg4, msgOrg4, info, master2, priority4, snmpTrapInfo, facilityPath);
                            m_log.debug((Object)"onMessage() : sendmessage ");
                            break block25;
                        }
                        m_log.debug((Object)"onMessage() : search from monitors. ");
                        ArrayList<MonitorSnmpTrapOidInfo> oidList = snmpTrapInfo.getOidInfos();
                        int matched = 0;
                        for (i = 0; i < oidList.size(); ++i) {
                            oidInfo = oidList.get(i);
                            if (!trapOid.equals(oidInfo.getTrapOid()) || genericId != oidInfo.getGenericId() || specificId != oidInfo.getSpecificId()) continue;
                            mib = oidInfo.getMib();
                            priority = oidInfo.getPriority();
                            msg = oidInfo.getLogmsg();
                            msgOrg = oidInfo.getDescr();
                            pk = new SnmpTrapMasterPK(mib, trapOid, genericId, specificId);
                            master = select.getMasterInfo(pk);
                            this.sendMassage(msg, msgOrg, info, master, priority, snmpTrapInfo, facilityPath);
                            ++matched;
                            m_log.debug((Object)"onMessage() : sendmessage ");
                            break;
                        }
                        if (matched == 0 && genericId != 6) {
                            m_log.debug((Object)"onMessage() : re-search generic trap");
                            for (i = 0; i < oidList.size(); ++i) {
                                oidInfo = oidList.get(i);
                                if (!oidInfo.getTrapOid().equals(TrapSnmp.GENERIC_TRAPS.get(genericId).toString())) continue;
                                mib = oidInfo.getMib();
                                priority = oidInfo.getPriority();
                                msg = oidInfo.getLogmsg();
                                msgOrg = oidInfo.getDescr();
                                pk = new SnmpTrapMasterPK(mib, TrapSnmp.GENERIC_TRAPS.get(genericId).toString(), genericId, specificId);
                                master = select.getMasterInfo(pk);
                                this.sendMassage(msg, msgOrg, info, master, priority, snmpTrapInfo, facilityPath);
                                m_log.debug((Object)"onMessage() : sendmessage ");
                                break;
                            }
                        }
                    }
                    Object var25_38 = null;
                    if (repository == null) break block18;
                    try {
                        repository.remove();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                repository = null;
                {
                    break block19;
                    catch (EJBException e) {
                        Object var25_39 = null;
                        if (repository != null) {
                            try {
                                repository.remove();
                            }
                            catch (Exception e2) {
                                // empty catch block
                            }
                        }
                        repository = null;
                        break block19;
                    }
                    catch (Exception e) {
                        Object var25_40 = null;
                        if (repository != null) {
                            try {
                                repository.remove();
                            }
                            catch (Exception e2) {
                                // empty catch block
                            }
                        }
                        repository = null;
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    Object var25_41 = null;
                    if (repository != null) {
                        try {
                            repository.remove();
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                    }
                    repository = null;
                    throw throwable;
                }
            }
            m_log.debug((Object)("onMessage(): ObjectMessage is not an expected instance. " + obj.toString()));
        }
        m_log.debug((Object)"onMessage() : end ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendMassage(String msg, String msgOrg, SnmpTrapMessageInfo info, SnmpTrapMasterInfo master, int priority, MonitorSnmpTrapInfo snmpTrapInfo, String facilityPath) {
        String regex;
        int j;
        String[] values;
        m_log.debug((Object)("sendMassage() start:" + info.getMonitorId() + " " + info.getFacilityId() + " " + info.getTrapOid()));
        SendQueue sendQueue = null;
        try {
            sendQueue = new SendQueue("queue/clustercontrolNotifyControl");
        }
        catch (NamingException e1) {
            m_log.error((Object)("sendMassage()" + e1.getMessage()));
        }
        catch (JMSException e1) {
            m_log.error((Object)("sendMassage()" + e1.getMessage()));
        }
        if (msg != null && !"".equals(msg)) {
            values = info.getVarBindValue();
            for (j = 0; j < values.length; ++j) {
                regex = "%parm\\[#" + Integer.toString(j + 1) + "\\]%";
                msg = msg.replaceAll(regex, values[j]);
            }
        } else {
            msg = "";
        }
        if (msgOrg == null || "".equals(msgOrg)) {
            msgOrg = master.getDescr();
        }
        if (msgOrg != null && !"".equals(msgOrg)) {
            values = info.getVarBindValue();
            for (j = 0; j < values.length; ++j) {
                regex = "%parm\\[#" + Integer.toString(j + 1) + "\\]%";
                msgOrg = msgOrg.replaceAll(regex, values[j]);
            }
        } else {
            msgOrg = "";
        }
        OutputNotifyGroupInfo notifyInfo = new OutputNotifyGroupInfo();
        notifyInfo.setMonitorId(info.getMonitorId());
        notifyInfo.setPluginId("MON_SNMP_TRP");
        notifyInfo.setPriority(priority);
        notifyInfo.setNotifyGroupId(snmpTrapInfo.getNotifyGroupId());
        notifyInfo.setApplication(snmpTrapInfo.getApplication());
        notifyInfo.setFacilityId(info.getFacilityId());
        notifyInfo.setScopeText(facilityPath);
        notifyInfo.setGenerationDate(info.getTrapDate());
        String messageId = null;
        messageId = priority == 3 ? "001" : (priority == 2 ? "002" : (priority == 0 ? "003" : "004"));
        notifyInfo.setMessageId(messageId);
        m_log.debug((Object)("sendMassage() : message length " + Integer.toString(msg.length())));
        if (msg.length() > 255) {
            notifyInfo.setMessage(msg.substring(0, 255));
        } else {
            notifyInfo.setMessage(msg);
        }
        Object[] args = new String[]{info.getTrapOid(), master.getUei()};
        notifyInfo.setMessageOrg(Messages.getString((String)"message.snmptrap.3", (Object[])args) + "\n" + msgOrg);
        sendQueue.put((Serializable)notifyInfo);
        Object var14_15 = null;
        if (sendQueue == null) return;
        try {
            sendQueue.terminate();
            return;
        }
        catch (JMSException e2) {
            m_log.error((Object)("Terminate SendQueue Failed : " + e2.getMessage()));
        }
        return;
        {
            catch (Exception e) {
                m_log.error((Object)("onMessage() : \u76e3\u8996\u7ba1\u7406\u30e1\u30c3\u30bb\u30fc\u30b8\u9001\u4fe1\u30a8\u30e9\u30fc : " + e.getMessage()));
                Object var14_16 = null;
                if (sendQueue == null) return;
                try {
                    sendQueue.terminate();
                    return;
                }
                catch (JMSException e2) {
                    m_log.error((Object)("Terminate SendQueue Failed : " + e2.getMessage()));
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            if (sendQueue == null) throw throwable;
            try {
                sendQueue.terminate();
                throw throwable;
            }
            catch (JMSException e2) {
                m_log.error((Object)("Terminate SendQueue Failed : " + e2.getMessage()));
            }
            throw throwable;
        }
    }
}

