/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.run.factory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoLocal;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoUtil;
import com.clustercontrol.monitor.run.factory.ModifySchedule;
import com.clustercontrol.notify.ejb.session.NotifyControllerLocal;
import com.clustercontrol.notify.ejb.session.NotifyControllerUtil;
import com.clustercontrol.util.apllog.AplLogger;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerException;

public abstract class AddMonitor {
    protected static Log m_log = LogFactory.getLog(AddMonitor.class);
    protected MonitorInfoLocal m_monitor;
    protected MonitorInfo m_monitorInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean add(MonitorInfo info, String user) throws CreateException, FinderException, SchedulerException, ParseException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException {
        AccessLock.lock((String)"MONITOR");
        this.m_monitorInfo = info;
        TransactionManager tm = null;
        Transaction oldTx = null;
        boolean result = false;
        try {
            InitialContext context = new InitialContext();
            tm = (TransactionManager)context.lookup("java:/TransactionManager");
            if (tm.getTransaction() != null) {
                oldTx = tm.suspend();
            }
            try {
                if (tm.getTransaction() == null) {
                    tm.begin();
                }
                if (result = this.addMonitorInfo(user)) {
                    tm.commit();
                }
            }
            catch (NotSupportedException e) {
                this.outputLog((Exception)((Object)e), "add()");
                throw e;
            }
            catch (RollbackException e) {
                this.outputLog((Exception)((Object)e), "add()");
                throw e;
            }
            catch (HeuristicMixedException e) {
                this.outputLog((Exception)((Object)e), "add()");
                throw e;
            }
            catch (HeuristicRollbackException e) {
                this.outputLog((Exception)((Object)e), "add()");
                throw e;
            }
            catch (SystemException e) {
                this.outputLog((Exception)((Object)e), "add()");
                throw e;
            }
            finally {
                if (tm.getTransaction() != null && !result) {
                    tm.rollback();
                }
            }
            if (oldTx == null) return result;
        }
        catch (Throwable throwable) {
            if (oldTx == null) throw throwable;
            try {
                tm.resume(oldTx);
                throw throwable;
            }
            catch (InvalidTransactionException e) {
                this.outputLog((Exception)((Object)e), "add()");
                throw e;
            }
            catch (IllegalStateException e) {
                this.outputLog(e, "add()");
                throw e;
            }
            catch (SystemException e) {
                this.outputLog((Exception)((Object)e), "add()");
                throw e;
            }
        }
        try {
            tm.resume(oldTx);
            return result;
        }
        catch (InvalidTransactionException e) {
            this.outputLog((Exception)((Object)e), "add()");
            throw e;
        }
        catch (IllegalStateException e) {
            this.outputLog(e, "add()");
            throw e;
        }
        catch (SystemException e) {
            this.outputLog((Exception)((Object)e), "add()");
            throw e;
        }
    }

    public abstract boolean addJudgementInfo() throws CreateException, NamingException;

    public abstract boolean addCheckInfo() throws CreateException, NamingException;

    public abstract String getJndiName();

    public boolean addMonitorInfo(String user) throws CreateException, FinderException, SchedulerException, ParseException, NamingException {
        try {
            Timestamp now = new Timestamp(new Date().getTime());
            this.m_monitor = MonitorInfoUtil.getLocalHome().create(this.m_monitorInfo.getMonitorTypeId(), this.m_monitorInfo.getMonitorId(), this.m_monitorInfo.getMonitorType(), this.m_monitorInfo.getDescription(), this.m_monitorInfo.getFacilityId(), this.m_monitorInfo.getRunInterval(), this.m_monitorInfo.getTimeout(), this.m_monitorInfo.getCalendarId(), this.m_monitorInfo.getMonitorBlock(), this.m_monitorInfo.getDeterminationId(), this.m_monitorInfo.getFailurePriority(), this.m_monitorInfo.getApplication(), this.m_monitorInfo.getFailureMessageId(), this.m_monitorInfo.getFailureMessage(), this.m_monitorInfo.getNotifyGroupId(), now, now, user, user);
            if (this.m_monitorInfo.getNotifyGroupId() != null) {
                NotifyControllerLocal nc = NotifyControllerUtil.getLocalHome().create();
                nc.addNotifyRelation(this.m_monitorInfo.getNotifyId());
            }
            if (this.addJudgementInfo() && this.addCheckInfo()) {
                ModifySchedule quartz = new ModifySchedule();
                quartz.addSchedule(this.m_monitorInfo, this.getJndiName(), this.getCalendar(this.m_monitorInfo.getRunInterval()));
                return true;
            }
            return false;
        }
        catch (CreateException e) {
            this.outputLog((Exception)((Object)e), "addMonitorInfo()");
            throw e;
        }
        catch (SchedulerException e) {
            this.outputLog((Exception)((Object)e), "addMonitorInfo()");
            throw e;
        }
        catch (ParseException e) {
            this.outputLog(e, "addMonitorInfo()");
            throw e;
        }
        catch (NamingException e) {
            this.outputLog(e, "addMonitorInfo()");
            throw e;
        }
    }

    public Calendar getCalendar(int interval) {
        return null;
    }

    private void outputLog(Exception e, String method) {
        AplLogger apllog = new AplLogger("MON", "mon");
        Object[] args = new String[]{this.m_monitorInfo.getMonitorTypeId(), this.m_monitorInfo.getMonitorId()};
        apllog.put("SYS", "007", args);
        m_log.debug((Object)(method + ":" + e.getMessage()));
    }
}

