/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.process.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProcessProperties {
    protected static Log m_log = LogFactory.getLog(ProcessProperties.class);
    private static final String START_SECOND = "10";
    private static final String VALID_SECOND = "15";
    private static final String START_SECOND_KEY = "monitor.process.start.second";
    private static final String VALID_SECOND_KEY = "monitor.process.valid.second";
    private static ProcessProperties m_instance = null;
    private int m_startSecond;
    private int m_validSecond;

    public static ProcessProperties getProperties() {
        if (m_instance == null) {
            m_instance = new ProcessProperties();
        }
        return m_instance;
    }

    private ProcessProperties() {
        this.setValue();
    }

    private void setValue() {
        Properties properties = new Properties();
        try {
            String etcdir = System.getProperty("hinemos.manager.etc.dir");
            String propertyFile = etcdir + File.separator + "hinemos.properties";
            properties.load(new FileInputStream(propertyFile));
            String startSecond = properties.getProperty(START_SECOND_KEY, START_SECOND);
            String validSecond = properties.getProperty(VALID_SECOND_KEY, VALID_SECOND);
            this.m_startSecond = new Integer(startSecond);
            this.m_validSecond = new Integer(validSecond);
        }
        catch (Exception e) {
            m_log.error((Object)("setValue(): " + e.getMessage()));
        }
    }

    public int getStartSecond() {
        return this.m_startSecond;
    }

    public int getValidSecond() {
        return this.m_validSecond;
    }
}

