/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.naming;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;
import org.jboss.ejb3.InitialContextFactory;
import org.jboss.ejb3.naming.MultiplexerContext;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMultiplexer
implements ObjectFactory {
    private static final Logger log = Logger.getLogger(SimpleMultiplexer.class);

    private Context createMultiplexer(Context ctx) throws NamingException {
        Context ctxTwo = (Context)ctx.lookup("comp.ejb3");
        Context ctxOne = (Context)ctx.lookup("comp.original");
        if (log.isTraceEnabled()) {
            log.trace((Object)("contextClassLoader = " + SimpleMultiplexer.getContextClassLoader() + " ctxOne = " + ctxOne));
        }
        if (ctxTwo == null) {
            return ctxOne;
        }
        return new MultiplexerContext(ctxOne, ctxTwo);
    }

    private static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        PrivilegedAction<ClassLoader> action = new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        };
        return AccessController.doPrivileged(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (nameCtx == null) {
            nameCtx = (Context)InitialContextFactory.getInitialContext().lookup("java:");
            try {
                Context context = this.createMultiplexer(nameCtx);
                return context;
            }
            finally {
                nameCtx.close();
            }
        }
        return this.createMultiplexer(nameCtx);
    }
}

