/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.Message;
import org.jboss.messaging.core.contract.MessageReference;
import org.jboss.messaging.core.impl.message.SimpleMessageReference;
import org.jboss.messaging.util.StreamUtils;

public abstract class MessageSupport
implements Message,
Serializable {
    private static final Logger log = Logger.getLogger(MessageSupport.class);
    private boolean trace = log.isTraceEnabled();
    protected long messageID;
    protected boolean reliable;
    protected long expiration;
    protected long timestamp;
    protected Map headers;
    protected byte priority;
    protected transient Object payload;
    protected byte[] payloadAsByteArray;
    private volatile transient boolean persisted;

    public MessageSupport() {
    }

    public MessageSupport(long messageID) {
        this(messageID, false, 0L, System.currentTimeMillis(), 4, null, null);
    }

    public MessageSupport(long messageID, boolean reliable, long expiration, long timestamp, byte priority, Map headers, byte[] payloadAsByteArray) {
        this.messageID = messageID;
        this.reliable = reliable;
        this.expiration = expiration;
        this.timestamp = timestamp;
        this.priority = priority;
        this.headers = headers == null ? new HashMap() : new HashMap(headers);
        this.payloadAsByteArray = payloadAsByteArray;
    }

    protected MessageSupport(MessageSupport that) {
        this.messageID = that.messageID;
        this.reliable = that.reliable;
        this.expiration = that.expiration;
        this.timestamp = that.timestamp;
        this.headers = new HashMap(that.headers);
        this.priority = that.priority;
        this.payload = that.payload;
        this.payloadAsByteArray = that.payloadAsByteArray;
    }

    public long getMessageID() {
        return this.messageID;
    }

    public boolean isReliable() {
        return this.reliable;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Object putHeader(String name, Object value) {
        return this.headers.put(name, value);
    }

    public Object getHeader(String name) {
        return this.headers.get(name);
    }

    public Object removeHeader(String name) {
        return this.headers.remove(name);
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    public Map getHeaders() {
        return this.headers;
    }

    public byte getPriority() {
        return this.priority;
    }

    public void setPriority(byte priority) {
        this.priority = priority;
    }

    public boolean isReference() {
        return false;
    }

    public synchronized byte[] getPayloadAsByteArray() {
        if (this.payloadAsByteArray == null && this.payload != null) {
            int BUFFER_SIZE = 2048;
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(2048);
                DataOutputStream daos = new DataOutputStream(bos);
                this.doWriteObject(daos, this.payload);
                daos.close();
                this.payloadAsByteArray = bos.toByteArray();
                this.payload = null;
            }
            catch (Exception e) {
                RuntimeException e2 = new RuntimeException(e.getMessage());
                e2.setStackTrace(e.getStackTrace());
                throw e2;
            }
        }
        return this.payloadAsByteArray;
    }

    public synchronized Object getPayload() {
        if (this.payload != null) {
            return this.payload;
        }
        if (this.payloadAsByteArray != null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.payloadAsByteArray);
            DataInputStream dis = new DataInputStream(bis);
            try {
                this.payload = StreamUtils.readObject(dis, true);
            }
            catch (Exception e) {
                RuntimeException e2 = new RuntimeException(e.getMessage());
                e2.setStackTrace(e.getStackTrace());
                throw e2;
            }
            this.payloadAsByteArray = null;
            return this.payload;
        }
        return null;
    }

    public void setPayload(Object payload) {
        this.payload = payload;
    }

    public boolean isExpired() {
        if (this.expiration == 0L) {
            return false;
        }
        long overtime = System.currentTimeMillis() - this.expiration;
        if (overtime >= 0L) {
            if (this.trace) {
                log.trace((Object)(this + " expired by " + overtime + " ms"));
            }
            return true;
        }
        return false;
    }

    public MessageReference createReference() {
        return new SimpleMessageReference(this);
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MessageSupport)) {
            return false;
        }
        MessageSupport that = (MessageSupport)o;
        return that.messageID == this.messageID;
    }

    public int hashCode() {
        return (int)(this.messageID >>> 32 ^ this.messageID);
    }

    public String toString() {
        return "M[" + this.messageID + "]";
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeLong(this.messageID);
        out.writeBoolean(this.reliable);
        out.writeLong(this.expiration);
        out.writeLong(this.timestamp);
        StreamUtils.writeMap(out, this.headers, true);
        out.writeByte(this.priority);
        byte[] bytes = this.getPayloadAsByteArray();
        if (bytes != null) {
            out.writeInt(bytes.length);
            out.write(bytes);
        } else {
            out.writeInt(0);
        }
    }

    public void read(DataInputStream in) throws Exception {
        this.messageID = in.readLong();
        this.reliable = in.readBoolean();
        this.expiration = in.readLong();
        this.timestamp = in.readLong();
        this.headers = StreamUtils.readMap(in, true);
        this.priority = in.readByte();
        int length = in.readInt();
        if (length == 0) {
            this.payloadAsByteArray = null;
        } else {
            this.payloadAsByteArray = new byte[length];
            in.readFully(this.payloadAsByteArray);
        }
    }

    protected void doWriteObject(DataOutputStream out, Object payload) throws IOException {
        StreamUtils.writeObject(out, payload, true, true);
    }
}

