/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl.postoffice;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.messaging.core.impl.postoffice.AckAllReplicatedDeliveriesMessage;
import org.jboss.messaging.core.impl.postoffice.AddAllReplicatedDeliveriesMessage;
import org.jboss.messaging.core.impl.postoffice.BindRequest;
import org.jboss.messaging.core.impl.postoffice.GetReplicatedDeliveriesRequest;
import org.jboss.messaging.core.impl.postoffice.JoinClusterRequest;
import org.jboss.messaging.core.impl.postoffice.LeaveClusterRequest;
import org.jboss.messaging.core.impl.postoffice.MessageRequest;
import org.jboss.messaging.core.impl.postoffice.PutReplicantRequest;
import org.jboss.messaging.core.impl.postoffice.RemoveReplicantRequest;
import org.jboss.messaging.core.impl.postoffice.ReplicateAckMessage;
import org.jboss.messaging.core.impl.postoffice.ReplicateDeliveryAckMessage;
import org.jboss.messaging.core.impl.postoffice.ReplicateDeliveryMessage;
import org.jboss.messaging.core.impl.postoffice.RequestTarget;
import org.jboss.messaging.core.impl.postoffice.UnbindRequest;
import org.jboss.messaging.util.Streamable;

abstract class ClusterRequest
implements Streamable {
    public static final int JOIN_CLUSTER_REQUEST = 1;
    public static final int LEAVE_CLUSTER_REQUEST = 2;
    public static final int BIND_REQUEST = 3;
    public static final int UNBIND_REQUEST = 4;
    public static final int MESSAGE_REQUEST = 5;
    public static final int PUT_REPLICANT_REQUEST = 6;
    public static final int REMOVE_REPLICANT_REQUEST = 7;
    public static final int REPLICATE_DELIVERY_REQUEST = 8;
    public static final int REPLICATE_DELIVERY_ACK_REQUEST = 9;
    public static final int REPLICATE_ACK_REQUEST = 10;
    public static final int ACK_ALL_REPLICATED_DELIVERIES_REQUEST = 11;
    public static final int ADD_ALL_REPLICATED_DELIVERIES_REQUEST = 12;
    public static final int GET_REPLICATED_DELIVERIES_REQUEST = 13;
    protected static final int NULL = 0;
    protected static final int NOT_NULL = 1;

    ClusterRequest() {
    }

    static ClusterRequest createFromStream(DataInputStream dais) throws Exception {
        byte type = dais.readByte();
        ClusterRequest request = null;
        switch (type) {
            case 5: {
                request = new MessageRequest();
                break;
            }
            case 3: {
                request = new BindRequest();
                break;
            }
            case 4: {
                request = new UnbindRequest();
                break;
            }
            case 1: {
                request = new JoinClusterRequest();
                break;
            }
            case 2: {
                request = new LeaveClusterRequest();
                break;
            }
            case 6: {
                request = new PutReplicantRequest();
                break;
            }
            case 7: {
                request = new RemoveReplicantRequest();
                break;
            }
            case 8: {
                request = new ReplicateDeliveryMessage();
                break;
            }
            case 9: {
                request = new ReplicateDeliveryAckMessage();
                break;
            }
            case 10: {
                request = new ReplicateAckMessage();
                break;
            }
            case 11: {
                request = new AckAllReplicatedDeliveriesMessage();
                break;
            }
            case 12: {
                request = new AddAllReplicatedDeliveriesMessage();
                break;
            }
            case 13: {
                request = new GetReplicatedDeliveriesRequest();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type: " + type);
            }
        }
        request.read(dais);
        return request;
    }

    public static void writeToStream(DataOutputStream daos, ClusterRequest request) throws Exception {
        daos.writeByte(request.getType());
        request.write(daos);
    }

    abstract Object execute(RequestTarget var1) throws Throwable;

    abstract byte getType();
}

