/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.chat.utility;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.ServletConfig;

public class Parameters {
    static Hashtable parameterValues = new Hashtable();
    static Hashtable primaryParameterValues = new Hashtable();
    static Hashtable defaultParameterValues = new Hashtable();

    public static void initParameters(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            int mark = args[i].indexOf(61);
            if (mark < 0) continue;
            primaryParameterValues.put(args[i].substring(0, mark), args[i].substring(mark + 1));
        }
        Parameters.getSecondaryParameterSources();
    }

    public static void initParameters(ServletConfig servletConfig) {
        Enumeration e = servletConfig.getInitParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            primaryParameterValues.put(key, servletConfig.getInitParameter(key));
        }
        Parameters.getSecondaryParameterSources();
    }

    private static void getSecondaryParameterSources() {
        File configurationFile;
        String configurationFilePath = "chat.conf";
        if (primaryParameterValues.containsKey("chat.conf")) {
            configurationFilePath = (String)primaryParameterValues.get("chat.conf");
        }
        if ((configurationFile = new File(configurationFilePath)).exists()) {
            try {
                FileInputStream fis = new FileInputStream(configurationFile);
                Properties properties = new Properties();
                properties.load(fis);
                Enumeration<?> e = properties.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    parameterValues.put(key, properties.getProperty(key));
                    System.out.println(key + ":" + properties.getProperty(key));
                }
            }
            catch (FileNotFoundException fnfe) {
                System.err.println("configuration file not found: " + configurationFilePath);
                System.err.println("using default properties");
            }
            catch (IOException ioe) {
                System.err.println("error reading configuration file: " + configurationFilePath);
                System.err.println("using default properties");
                System.out.println(ioe.getMessage());
            }
            String debug = Parameters.getParameter("debug");
            if (debug.charAt(0) == 'y') {
                System.out.println("properties:");
                for (String key : parameterValues.keySet()) {
                    System.out.println("  " + key + ": " + parameterValues.get(key));
                }
            }
        }
        for (Object key : primaryParameterValues.keySet()) {
            parameterValues.put(key, primaryParameterValues.get(key));
        }
    }

    public static String getParameter(String name) {
        return Parameters.getParameter(name, null);
    }

    public static String getParameter(String name, String defaultValue) {
        String value = null;
        value = (String)parameterValues.get(name);
        if (value == null) {
            value = System.getProperty(name);
        }
        if (value == null) {
            value = (String)defaultParameterValues.get(name);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static void main(String[] args) {
        Parameters.initParameters(args);
        System.out.println("clientUri: " + Parameters.getParameter("clientUri"));
        System.out.println("serverUri: " + Parameters.getParameter("serverUri"));
    }

    static {
        defaultParameterValues.put("serverUri", "http://localhost:8000");
        defaultParameterValues.put("clientUri", "http://localhost:8002");
    }
}

