/*
 
 Copyright (C) 2008 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.notify.bean;

import com.clustercontrol.bean.EventConfirmConstant;

/**
 * 通知ジョブ情報を保持するクラスです。
 * 
 * @author yosuke
 * @version 3.0.0
 * @since 3.0.0
 */
public class NotifyJobInfo  extends NotifyInfoDetail
{
	private static final long serialVersionUID = -5089086735470199399L;
	

	/** ジョブID*/
	private String jobId;
	
	/** ジョブ実行失敗時重要度*/
	private Integer jobFailurePriority;
	
	/** ジョブ実行ファシリティフラグ*/
	private Integer jobExecFacilityFlg;
	
	/**ジョブ実行ファシリティID*/
	private String  jobExecFacility;
	
	/**ジョブ実行スコープ*/
	private String	jobExecScope;
	
	/**
	 * コンストラクタ。
	 */
	public NotifyJobInfo() {
	}
	
	/**
	 * コンストラクタ。
	 * 
	 * @param notifyId 通知ID
	 * @param priority 重要度
	 * @param validFlg 通知フラグ
	 * @param inhibitionFlg 抑制フラグ
	 * @param jobId ジョブID
	 * @param jobFailurePriority ジョブ実行失敗時重要度
	 * @param jobExecFacilityFlg ジョブ実行ファシリティフラグ
	 * @param jobExecFacility    ジョブ実行ファシリティ
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.ValidConstant
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */
	public NotifyJobInfo(
			String notifyId,
			Integer priority,
			Integer validFlg,
			String jobId,
			Integer inhibitionFlg,
			Integer jobFailurePriority,
			Integer jobExecFacilityFlg,
			String jobExecFacility,
			String jobExecScope) {
		
		setNotifyId(notifyId);
		setPriority(priority);
		setValidFlg(validFlg);
		setInhibitionFlg(inhibitionFlg);
		setJobId(jobId);
		setJobFailurePriority(jobFailurePriority);
		setJobExecFacilityFlg(jobExecFacilityFlg);
		setJobExecFacility(jobExecFacility);
		setJobExecScope(jobExecScope);
	}
	
	/**
	 * コンストラクタ。
	 * 
	 * @param otherData コピー元の通知情報
	 */
	public NotifyJobInfo( NotifyJobInfo otherData ) {
		setNotifyId(otherData.getNotifyId());
		setPriority(otherData.getPriority());
		setValidFlg(otherData.getValidFlg());
		setInhibitionFlg(otherData.getInhibitionFlg());
		setJobId(otherData.getJobId());
		setJobFailurePriority(otherData.getJobFailurePriority());
		setJobExecFacilityFlg(otherData.getJobExecFacilityFlg());
		setJobExecFacility(otherData.getJobExecFacility());
		setJobExecScope(otherData.getJobExecScope());
	}

	/**
	 * ジョブIDを返します。
	 * 
	 * @return　ジョブID
	 */
	public String getJobId() {
		return jobId;
	}

	/**
	 * ジョブIDを設定します。
	 * 
	 * @param job_id
	 */
	public void setJobId(String jobId) {
		this.jobId = jobId;
	}

	/**
	 * ジョブ実行失敗時重要度を返します。
	 * 
	 * @return　ジョブ実行失敗時重要度
	 */
	public Integer getJobFailurePriority() {
		return jobFailurePriority;
	}

	/**
	 * ジョブ実行失敗時重要度を設定します。
	 * 
	 * @param jobFailurePriority
	 */
	public void setJobFailurePriority(Integer jobFailurePriority) {
		this.jobFailurePriority = jobFailurePriority;
	}

	/**
	 * ジョブ実行ファシリティフラグを返します。
	 * @return
	 */
	public Integer getJobExecFacilityFlg() {
		return jobExecFacilityFlg;
	}

	/**
	 * ジョブ実行ファシリティフラグを設定します。
	 * 
	 * @param jobExecFacilityFlg
	 */
	public void setJobExecFacilityFlg(Integer jobExecFacilityFlg) {
		this.jobExecFacilityFlg = jobExecFacilityFlg;
	}

	/**
	 * ジョブ実行ファシリティを返します。
	 * 
	 * @return
	 */
	public String getJobExecFacility() {
		return jobExecFacility;
	}

	/**
	 * ジョブ実行ファシリティを設定します。
	 * 
	 * @param jobExecFacility
	 */
	public void setJobExecFacility(String jobExecFacility) {
		this.jobExecFacility = jobExecFacility;
	}
	
	/**
	 * ジョブ実行スコープを返します。
	 * 
	 * @return
	 */
	public String getJobExecScope() {
		return jobExecScope;
	}

	/**
	 * ジョブ実行スコープを設定します。
	 * 
	 * @param jobExecScope
	 */
	public void setJobExecScope(String jobExecScope) {
		this.jobExecScope = jobExecScope;
	}
	

}
