/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.priority.composite;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import com.clustercontrol.bean.PriorityColorConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.util.Messages;

/**
 * パターンコンポジットクラス<BR>
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class PatternComposite extends Composite {
    protected Combo comboPriority = null;
    
    protected boolean info = false;

    protected boolean warning = false;

    protected boolean critical = false;

    protected boolean unknown = false;
    
    protected int priority = PriorityConstant.TYPE_INFO;

    /**
     * インスタンスを返します。
     * 
     * @param parent 親のコンポジット
     * @param style スタイル
     */
    public PatternComposite(
    		Composite parent, 
    		int style, 
    		boolean info, 
    		boolean warning, 
    		boolean critical, 
    		boolean unknown, 
    		int priority) {
        super(parent, style);
        
		this.info = info;
		this.warning = warning;
		this.critical = critical;
		this.unknown = unknown;
		this.priority = priority;
        
        this.initialize();
    }
    
    /**
     * コンポジットを生成・構築します。
     */
    private void initialize() {
    	
    	// 変数として利用されるラベル
        Label label = null;
        // 変数として利用されるグリッドデータ
        GridData gridData = null;
        
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 2;
        layout.marginWidth = 5;
    	layout.numColumns = 11;
        this.setLayout(layout);
        
        /*
         * 通知
         */
        label = new Label(this, SWT.CENTER);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        if( this.info ){
            label.setText(Messages.getString("info"));
            label.setBackground(PriorityColorConstant.COLOR_INFO);
        }
        else{
            label.setText(" - ");
        }
        
        /*
         * 警告
         */
        label = new Label(this, SWT.CENTER);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        if( this.warning ){
            label.setText(Messages.getString("warning"));
            label.setBackground(PriorityColorConstant.COLOR_WARNING);
        }
        else{
            label.setText(" - ");
        }
        
        /*
         * 危険
         */
        label = new Label(this, SWT.CENTER);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        if( this.critical ){
            label.setText(Messages.getString("critical"));
            label.setBackground(PriorityColorConstant.COLOR_CRITICAL);
        }
        else{
            label.setText(" - ");
        }
        
        /*
         * 不明
         */
        label = new Label(this, SWT.CENTER);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        if( this.unknown ){
            label.setText(Messages.getString("unknown"));
            label.setBackground(PriorityColorConstant.COLOR_UNKNOWN);
        }
        else{
            label.setText(" - ");
        }
        
        // 空白
        label = new Label(this, SWT.CENTER);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(" : ");
        
        /*
         * 結果
         */
        this.comboPriority = new Combo(this, SWT.CENTER | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.comboPriority.setLayoutData(gridData);
        
        if( this.critical )
        	this.comboPriority.add(PriorityConstant.STRING_CRITICAL);
        if( this.warning )
        	this.comboPriority.add(PriorityConstant.STRING_WARNING);
        if( this.info )
        	this.comboPriority.add(PriorityConstant.STRING_INFO);
        if( this.unknown )
        	this.comboPriority.add(PriorityConstant.STRING_UNKNOWN);
        
        this.comboPriority.setText(PriorityConstant.typeToString(priority));
    }

	/**
     * 重要度を取得
     * 
	 * @return
	 */
	public int getPriority() {
		return PriorityConstant.stringToType(this.comboPriority.getText());
	}
}