/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.logtransfer.ejb.entity;

import java.sql.Timestamp;
import java.util.Collection;

import javax.ejb.EntityBean;

/**
 * ログ転送設定を管理するEntity Bean<BR>
 * 
 * @ejb.bean name="LogTransferInfo"
 *     jndi-name="LogTransferInfo"
 *     type="CMP"
 *     schema="LogTransferInfo"
 *     cmp-version="2.x"
 *     data-source="java:/HinemosDS"
 *     primkey-field="transferId"
 *         
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.permission
 *     unchecked="true"
 *           
 * @ejb.persistence 
 *     table-name="cc_log_transfer_info"
 *     
 * @ejb.finder 
 *     query="SELECT OBJECT(a) FROM LogTransferInfo as a"  
 *     signature="java.util.Collection findAll()"
 *     
 * @ejb.finder
 *    query=""
 *    signature="java.util.Collection findAllOrderByTransferId()"
 * @jboss.query
 *    query="SELECT OBJECT(a) FROM LogTransferInfo as a ORDER BY a.transferId"
 *    signature="java.util.Collection findAllOrderByTransferId()"
 *     
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM LogTransferInfo as a WHERE a.facilityId = ?1"  
 *    signature="java.util.Collection findByFacilityId(java.lang.String facilityId)"  
 *
 * @ejb.pk class="java.lang.String"
 *           
 */
public abstract class LogTransferInfoBean implements EntityBean {
	
  /**
   *
   * <!-- begin-user-doc -->
   * The  ejbCreate method.
   * <!-- end-user-doc -->
   *
   * <!-- begin-xdoclet-definition --> 
   * @ejb.create-method 
   * <!-- end-xdoclet-definition --> 
   * @generated
   */
  public java.lang.String ejbCreate(
			String transferId,
			String description,
			String facilityId,
			Integer validFlg,
			Timestamp regDate,  
			Timestamp updateDate, 
			String regUser, 
			String updateUser) throws javax.ejb.CreateException {

  	
		this.setTransferId(transferId);
		this.setDescription(description);
		this.setFacilityId(facilityId);
		this.setValidFlg(validFlg);
		this.setRegDate(regDate);
		this.setUpdateDate(updateDate);
		this.setRegUser(regUser);
		this.setUpdateUser(updateUser);
	    return null;
	}
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="transfer_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the transferId.
	 */
	public abstract String getTransferId();
	
	/**
	 * @ejb.interface-method
	 * 
	 * @param transferId The transferId to set.
	 */
	public abstract void setTransferId(String transferId);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="description"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the description.
	 */
	public abstract String getDescription();

	/**
	 * @ejb.interface-method
	 * 
	 * @param description The description to set.
	 */
	public abstract void setDescription(String description);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="facility_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the facilityId.
	 */
	public abstract String getFacilityId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param facilityId The facilityId to set.
	 */
	public abstract void setFacilityId(String facilityId);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="reg_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @param regDate The regDate to set.
	 */
	public abstract Timestamp getRegDate();

	/**
	 * @ejb.interface-method
	 * 
	 * @param regDate The regDate to set.
	 */
	public abstract void setRegDate(Timestamp regDate);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="reg_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return the regUser
	 */
	public abstract java.lang.String getRegUser();
	   
	/**
	 * @ejb.interface-method
	 * 
	 * @param java.lang.String the new regUser value
	 */
	public abstract void setRegUser(java.lang.String regUser);	

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="update_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @param updateDate The updateDate to set.
	 */
	public abstract Timestamp getUpdateDate();

	/**
	 * @ejb.interface-method
	 * 
	 * @param updateDate The updateDate to set.
	 */
	public abstract void setUpdateDate(Timestamp updateDate);
	
	/**
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="update_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return the updateUser
	 */
	public abstract java.lang.String getUpdateUser();
	   
	/**
	 * @ejb.interface-method
	 * 
	 * @param java.lang.String the new update_user value
	 */
	public abstract void setUpdateUser(java.lang.String updateUser);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="valid_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return Returns the validFlg.
	 */
	public abstract Integer getValidFlg();

	/**
	 * @ejb.interface-method
	 * 
	 * @param validFlg The validFlg to set.
	 */
	public abstract void setValidFlg(Integer validFlg);
	
	//	==========================================
	//	 CMR fields
	//	==========================================
	
	/**
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation 
	 * name="LogTransferInfo-LogTransferFileInfo"
	 * role-name="LogTransferInfo-LogTransferFileInfo(single)"
	 * 
	 * @return Returns the collection.
	 * 
	 */
	public abstract Collection getLogTransferFileInfo();
	
	/**
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param collection The collection to set.
	 */
	public abstract void setLogTransferFileInfo(Collection collection);
}
