/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.util;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.ExclusionConstant;
import com.clustercontrol.bean.ExecFacilityConstant;
import com.clustercontrol.bean.OutputNotifyGroupInfo;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.notify.ejb.entity.NotifyInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyInfoUtil;
import com.clustercontrol.notify.ejb.entity.NotifyLogEscalateInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyLogEscalateInfoPK;
import com.clustercontrol.notify.ejb.entity.NotifyLogEscalateInfoUtil;
import com.clustercontrol.repository.ejb.entity.FacilityLocal;
import com.clustercontrol.repository.ejb.entity.FacilityUtil;
import com.clustercontrol.repository.ejb.session.RepositoryControllerBean;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;

/**
 * syslogに転送するクラス<BR>
 *
 * @version 3.0.0
 * @since 3.0.0
 */
public class SendSyslog extends InhibitAction{
	/** ログ出力のインスタンス。 */
	protected static Log m_log = LogFactory.getLog( SendSyslog.class );

	private static int LIMIT_SIZE = 1024;
	
	private OutputNotifyGroupInfo m_outputInfo;
	

    public synchronized void sendSyslog(OutputNotifyGroupInfo outputInfo) throws FinderException, NamingException{
    	
    	m_outputInfo = outputInfo;
    	
		NotifyInfoLocal notifyInfo = NotifyInfoUtil.getLocalHome().findByPrimaryKey(m_outputInfo.getNotifyId());
		
		// 該当する重要度の通知情報を取得する
    	NotifyLogEscalateInfoLocal logEscalateInfo = NotifyLogEscalateInfoUtil.getLocalHome().findByPrimaryKey(
    			new NotifyLogEscalateInfoPK(m_outputInfo.getNotifyId(), m_outputInfo.getPriority()));
    	
    	if(logEscalateInfo == null){
			m_log.debug("onMessage() : 出力する重要度が存在しません。");
			return;
    	}
    	
		try {
	    		
    		// 対象の重要度に通知フラグがたっていた場合
    		if(logEscalateInfo.getEscalateFlg() == ValidConstant.TYPE_VALID){
    			
    			/**
    			 * 実行するかどうかの判定
    			 */
    			boolean isRun = false;
    			
		    	// 抑制する場合（該当の重要度に抑制フラグがあり、抑制方法が「なし」以外の場合）
		    	if (logEscalateInfo.getEscalateInhibitionFlg().intValue() == ValidConstant.TYPE_VALID &&
		    			notifyInfo.getInhibitionFlg().intValue() != ExclusionConstant.TYPE_NO) {
					try {
						boolean isInhibit = super.isInhibit(m_outputInfo, notifyInfo);
						
						// 抑制しない場合
						if(!isInhibit){
							isRun = true;
						}
						
					} catch (NumberFormatException e) {
						m_log.error("sendSyslog() : " + e.getMessage(),e);
					} catch (RemoteException e) {
						m_log.error("sendSyslog() : " + e.getMessage(),e);
					} catch (CreateException e) {
						m_log.error("sendSyslog() : " + e.getMessage(),e);
					}
		    	}
		    	// 抑制しない場合（上記以外）
		    	else {
		    		isRun = true;
		    	}
		    	
		    	
				/**
				 * 実行
				 */
		    	if(isRun) {
		    		
	    			String facilityId = null;
	    			InetAddress ipAddress = null;
	    			FacilityLocal facility = null;
	    			//リポジトリ(RepositoryControllerLocal)を取得
	    			RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
	    			
	    			// 固定スコープ
	    			if(logEscalateInfo.getEscalateFacilityFlg() == ExecFacilityConstant.TYPE_FIX) {
	    				// 以下の実装は、入力されているファシリティIDがノードのモノである場合
	    				
	    				facilityId = logEscalateInfo.getEscalateFacility();
	    				
	    				
	    				ArrayList<String> facilityIdList = repository.getExecTargetFacilityIdList(facilityId);
    					Iterator<String> itr = facilityIdList.iterator();
    					
    					// 取得した全てのノードのsyslogに通知する
    					while(itr.hasNext()){
    						facility = FacilityUtil.getLocalHome().findByFacilityId(itr.next());
    						ipAddress = this.getInetAdress(facility);
    						this.send(logEscalateInfo, ipAddress);
    					}
	    				// 通知対象がノードであった場合
//	    				if(repository.isNode(facilityId)){
//		    				facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId);
//		    				ipAddress = this.getInetAdress(facility);
//		    				this.send(logEscalateInfo, ipAddress);
//	    				}
//	    				// 通知対象がスコープであった場合
//	    				else {
//	    					// スコープ配下の全てのノードを取得する
//	    					ArrayList<String> facilityIdList = repository.getNodeFacilityIdList(facilityId, RepositoryControllerBean.ALL);
//	    					Iterator<String> itr = facilityIdList.iterator();
//	    					
//	    					// 取得した全てのノードのsyslogに通知する
//	    					while(itr.hasNext()){
//	    						facility = FacilityUtil.getLocalHome().findByFacilityId(itr.next());
//	    						ipAddress = this.getInetAdress(facility);
//	    						this.send(logEscalateInfo, ipAddress);
//	    					}
//	    				}
    					
    				// イベントが発生したノード
	    			} else {
	    				facilityId = m_outputInfo.getFacilityId();
	    				
    					ArrayList<String> facilityIdList = repository.getExecTargetFacilityIdList(facilityId);
    					Iterator<String> itr = facilityIdList.iterator();
    					
    					while(itr.hasNext()){
    						facility = FacilityUtil.getLocalHome().findByFacilityId(itr.next());
							ipAddress = this.getInetAdress(facility);
							this.send(logEscalateInfo, ipAddress);
    					}
    					
	    				// 監視結果の通知単位がノードである場合
//	    				if(repository.isNode(facilityId)){
//		    				facility = FacilityUtil.getLocalHome().findByFacilityId(m_outputInfo.getFacilityId());
//		    				ipAddress = this.getInetAdress(facility);
//		    				this.send(logEscalateInfo, ipAddress);
//	    				}
//	    				// 監視結果の通知単位がスコープである場合
//	    				else {
//	    					// スコープ配下の全てのノードを取得する
//	    					ArrayList<String> facilityIdList = repository.getNodeFacilityIdList(facilityId, RepositoryControllerBean.ALL);
//	    					Iterator<String> itr = facilityIdList.iterator();
//	    					
//	    					// 取得した全てのノードのsyslogに通知する
//	    					while(itr.hasNext()){
//	    						facility = FacilityUtil.getLocalHome().findByFacilityId(itr.next());
//	    						ipAddress = this.getInetAdress(facility);
//	    						this.send(logEscalateInfo, ipAddress);
//	    					}
//	    				}
	    			}
		    	}
    		}
		} 
		catch (CreateException e) {
			m_log.error("sendSyslog() : " + e.getMessage(), e);
		} 
		catch (SocketException e) {
			m_log.error("sendSyslog() : " + e.getMessage(), e);
		} 
		catch (UnknownHostException e) {
			m_log.error("sendSyslog() : " + e.getMessage(), e);
		} 
		catch (IOException e) {
			m_log.error("sendSyslog() : " + e.getMessage(), e);
		}
    	
    }
    
    private InetAddress getInetAdress(FacilityLocal facility) throws UnknownHostException{
    	InetAddress ret = null;
    	
    	// IPアドレスの取得
		int version = 4;
		if(facility.getIpProtocolNumber() != null){
			version = facility.getIpProtocolNumber();
		}else{
			version = 4;
		}
		// 入力されているバージョンを比較し、対応するIPアドレスを取得する
		if(version == 4) {
			ret = InetAddress.getByName(facility.getIpNetworkNumber());
		}
		else {
			ret = InetAddress.getByName(facility.getIpNetworkNumberV6());
		}
		
    	return ret;
    }
    
    
    /**
     * syslogにメッセージを送る
     * 
     * @param logEscalateInfo	通知内容
     * @param ipAddress	IPアドレス
     * @throws FinderException
     * @throws NamingException
     * @throws IOException
     */
    private void send(NotifyLogEscalateInfoLocal logEscalateInfo, InetAddress ipAddress) throws FinderException, NamingException, IOException {

		byte[] buf = new byte[LIMIT_SIZE];		// 送受信バッファ
		int len;	// 送信文字数
		
		int port = logEscalateInfo.getEscalatePort();			// ポート番号
		String message = logEscalateInfo.getEscalateMessage();
		int syslogPriority = logEscalateInfo.getSyslogPriority() + logEscalateInfo.getSyslogFacility();
		
		
		// ソケットを作成してサーバに接続する。
		DatagramSocket soc = new DatagramSocket();  // データグラムソケットを開く
		DatagramPacket sendPacket = null;           // データグラムパケット設定
		
		// 文字列を置換する(SendMailクラスの文字列置換ロジックをそのまま利用する)
//		SendMail send = new SendMail();
		message = SendMail.substitution(message, m_outputInfo);
		
		// 送信メッセージの作成
		String sendMessage = "<"+ syslogPriority +">"+message;
		
		// 1024バイトを超える場合は、1024バイトまでを送信する（文字化けは考慮しない）
		if(sendMessage.getBytes().length > LIMIT_SIZE){
			buf = sendMessage.getBytes();
			sendMessage = new String(buf, 0, LIMIT_SIZE);
		}
		
		buf = sendMessage.getBytes();
		len = buf.length;
		sendPacket = new DatagramPacket(buf, len, ipAddress, port );
		soc.send(sendPacket);
		
		soc.close();
    }
    
}

