package org.postgresforest;

import java.sql.*;
import java.util.*;
import java.util.concurrent.*;

import org.postgresforest.apibase.*;
import org.postgresforest.constant.ErrorStr;
import org.postgresforest.constant.UdbValidity;
import org.postgresforest.exception.ForestResourceDisposedException;
import org.postgresforest.util.*;

// TODO （情報出力）JDBCの内部情報を引き出せるAPIを実装

public final class ForestDatabaseMetaData implements DatabaseMetaData, ForestCloseable, ForestJdbcInfo {
    
    private boolean isClosed = false;
    private final List<DatabaseMetaData> dbmds;
    private final EntrypointCommonResource epCommonResource;
    private ForestResultSet resultSet;
    private void setForestResultSet(ForestResultSet newResultSet) {
        if (resultSet != null) {
            try { resultSet.close(); } catch (SQLException e) { }
        }
        resultSet = newResultSet;
    }
    
    public ForestDatabaseMetaData(final EntrypointCommonResource epCommonResource, final List<DatabaseMetaData> dbmds) {
        this.epCommonResource = epCommonResource;
        this.dbmds = dbmds;
    }
    
    public boolean allProceduresAreCallable() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.AllProceduresAreCallable(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.AllProceduresAreCallable(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean allTablesAreSelectable() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.AllTablesAreSelectable(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.AllTablesAreSelectable(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.DataDefinitionCausesTransactionCommit(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.DataDefinitionCausesTransactionCommit(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.DataDefinitionIgnoredInTransactions(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.DataDefinitionIgnoredInTransactions(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean deletesAreDetected(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.DoesMaxRowSizeIncludeBlobs(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.DoesMaxRowSizeIncludeBlobs(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public ResultSet getAttributes(String arg0, String arg1, String arg2, String arg3)
    throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public ResultSet getBestRowIdentifier(String arg0, String arg1,
            String arg2, int arg3, boolean arg4) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<ResultSet> task0 = new DatabaseMetaDataTask.GetBestRowIdentifier(dbmds.get(0), arg0, arg1, arg2, arg3, arg4);
        final Callable<ResultSet> task1 = new DatabaseMetaDataTask.GetBestRowIdentifier(dbmds.get(1), arg0, arg1, arg2, arg3, arg4);
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public String getCatalogSeparator() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public String getCatalogTerm() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<String> task0 = new DatabaseMetaDataTask.GetCatalogTerm(dbmds.get(0));
        final Callable<String> task1 = new DatabaseMetaDataTask.GetCatalogTerm(dbmds.get(1));
        final List<String> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1);
    }
    
    public ResultSet getCatalogs() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<ResultSet> task0 = new DatabaseMetaDataTask.GetCatalogs(dbmds.get(0));
        final Callable<ResultSet> task1 = new DatabaseMetaDataTask.GetCatalogs(dbmds.get(1));
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public ResultSet getColumnPrivileges(String arg0, String arg1, String arg2, String arg3)
    throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<ResultSet> task0 = new DatabaseMetaDataTask.GetColumnPrivileges(dbmds.get(0), arg0, arg1, arg2, arg3);
        final Callable<ResultSet> task1 = new DatabaseMetaDataTask.GetColumnPrivileges(dbmds.get(1), arg0, arg1, arg2, arg3);
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public ResultSet getColumns(String arg0, String arg1, String arg2, String arg3)
    throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<ResultSet> task0 = new DatabaseMetaDataTask.GetColumns(dbmds.get(0), arg0, arg1, arg2, arg3);
        final Callable<ResultSet> task1 = new DatabaseMetaDataTask.GetColumns(dbmds.get(1), arg0, arg1, arg2, arg3);
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public Connection getConnection() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public ResultSet getCrossReference(String arg0, String arg1, String arg2,
            String arg3, String arg4, String arg5) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<ResultSet> task0 = new DatabaseMetaDataTask.GetCrossReference(dbmds.get(0), arg0, arg1, arg2, arg3, arg4, arg5);
        final Callable<ResultSet> task1 = new DatabaseMetaDataTask.GetCrossReference(dbmds.get(1), arg0, arg1, arg2, arg3, arg4, arg5);
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public int getDatabaseMajorVersion() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public int getDatabaseMinorVersion() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public String getDatabaseProductName() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<String> task0 = new DatabaseMetaDataTask.GetDatabaseProductName(dbmds.get(0));
        final Callable<String> task1 = new DatabaseMetaDataTask.GetDatabaseProductName(dbmds.get(1));
        final List<String> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1);
    }
    
    public String getDatabaseProductVersion() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<String> task0 = new DatabaseMetaDataTask.GetDatabaseProductVersion(dbmds.get(0));
        final Callable<String> task1 = new DatabaseMetaDataTask.GetDatabaseProductVersion(dbmds.get(1));
        final List<String> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1);
    }
    
    public int getDefaultTransactionIsolation() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Integer> task0 = new DatabaseMetaDataTask.GetDefaultTransactionIsolation(dbmds.get(0));
        final Callable<Integer> task1 = new DatabaseMetaDataTask.GetDefaultTransactionIsolation(dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getDriverMajorVersion() {
        return 0;
    }
    
    public int getDriverMinorVersion() {
        return 0;
    }
    
    public String getDriverName() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<String> task0 = new DatabaseMetaDataTask.GetDriverName(dbmds.get(0));
        final Callable<String> task1 = new DatabaseMetaDataTask.GetDriverName(dbmds.get(1));
        final List<String> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1);
    }
    
    public String getDriverVersion() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<String> task0 = new DatabaseMetaDataTask.GetDriverVersion(dbmds.get(0));
        final Callable<String> task1 = new DatabaseMetaDataTask.GetDriverVersion(dbmds.get(1));
        final List<String> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1);
    }
    
    public ResultSet getExportedKeys(String arg0, String arg1, String arg2)
            throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<ResultSet> task0 = new DatabaseMetaDataTask.GetExportedKeys(dbmds.get(0), arg0, arg1, arg2);
        final Callable<ResultSet> task1 = new DatabaseMetaDataTask.GetExportedKeys(dbmds.get(1), arg0, arg1, arg2);
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public String getExtraNameCharacters() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<String> task0 = new DatabaseMetaDataTask.GetExtraNameCharacters(dbmds.get(0));
        final Callable<String> task1 = new DatabaseMetaDataTask.GetExtraNameCharacters(dbmds.get(1));
        final List<String> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1);
    }
    
    public String getIdentifierQuoteString() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<String> task0 = new DatabaseMetaDataTask.GetIdentifierQuoteString(dbmds.get(0));
        final Callable<String> task1 = new DatabaseMetaDataTask.GetIdentifierQuoteString(dbmds.get(1));
        final List<String> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1);
    }
    
    public ResultSet getImportedKeys(String arg0, String arg1, String arg2)
            throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<ResultSet> task0 = new DatabaseMetaDataTask.GetImportedKeys(dbmds.get(0), arg0, arg1, arg2);
        final Callable<ResultSet> task1 = new DatabaseMetaDataTask.GetImportedKeys(dbmds.get(1), arg0, arg1, arg2);
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public ResultSet getIndexInfo(String arg0, String arg1, String arg2,
            boolean arg3, boolean arg4) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<ResultSet> task0 = new DatabaseMetaDataTask.GetIndexInfo(dbmds.get(0), arg0, arg1, arg2, arg3, arg4);
        final Callable<ResultSet> task1 = new DatabaseMetaDataTask.GetIndexInfo(dbmds.get(1), arg0, arg1, arg2, arg3, arg4);
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public int getJDBCMajorVersion() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public int getJDBCMinorVersion() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public int getMaxBinaryLiteralLength() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Integer> task0 = new DatabaseMetaDataTask.GetMaxBinaryLiteralLength(dbmds.get(0));
        final Callable<Integer> task1 = new DatabaseMetaDataTask.GetMaxBinaryLiteralLength(dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxCatalogNameLength() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Integer> task0 = new DatabaseMetaDataTask.GetMaxCatalogNameLength(dbmds.get(0));
        final Callable<Integer> task1 = new DatabaseMetaDataTask.GetMaxCatalogNameLength(dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxCharLiteralLength() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Integer> task0 = new DatabaseMetaDataTask.GetMaxCharLiteralLength(dbmds.get(0));
        final Callable<Integer> task1 = new DatabaseMetaDataTask.GetMaxCharLiteralLength(dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxColumnNameLength() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Integer> task0 = new DatabaseMetaDataTask.GetMaxColumnNameLength(dbmds.get(0));
        final Callable<Integer> task1 = new DatabaseMetaDataTask.GetMaxColumnNameLength(dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxColumnsInGroupBy() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Integer> task0 = new DatabaseMetaDataTask.GetMaxColumnsInGroupBy(dbmds.get(0));
        final Callable<Integer> task1 = new DatabaseMetaDataTask.GetMaxColumnsInGroupBy(dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxColumnsInIndex() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Integer> task0 = new DatabaseMetaDataTask.GetMaxColumnsInIndex(dbmds.get(0));
        final Callable<Integer> task1 = new DatabaseMetaDataTask.GetMaxColumnsInIndex(dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxColumnsInOrderBy() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Integer> task0 = new DatabaseMetaDataTask.GetMaxColumnsInOrderBy(dbmds.get(0));
        final Callable<Integer> task1 = new DatabaseMetaDataTask.GetMaxColumnsInOrderBy(dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxColumnsInSelect() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Integer> task0 = new DatabaseMetaDataTask.GetMaxColumnsInSelect(dbmds.get(0));
        final Callable<Integer> task1 = new DatabaseMetaDataTask.GetMaxColumnsInSelect(dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxColumnsInTable() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Integer> task0 = new DatabaseMetaDataTask.GetMaxColumnsInTable(dbmds.get(0));
        final Callable<Integer> task1 = new DatabaseMetaDataTask.GetMaxColumnsInTable(dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxConnections() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Integer> task0 = new DatabaseMetaDataTask.GetMaxConnections(dbmds.get(0));
        final Callable<Integer> task1 = new DatabaseMetaDataTask.GetMaxConnections(dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxCursorNameLength() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Integer> task0 = new DatabaseMetaDataTask.GetMaxCursorNameLength(dbmds.get(0));
        final Callable<Integer> task1 = new DatabaseMetaDataTask.GetMaxCursorNameLength(dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxIndexLength() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Integer> task0 = new DatabaseMetaDataTask.GetMaxIndexLength(dbmds.get(0));
        final Callable<Integer> task1 = new DatabaseMetaDataTask.GetMaxIndexLength(dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxProcedureNameLength() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Integer> task0 = new DatabaseMetaDataTask.GetMaxProcedureNameLength(dbmds.get(0));
        final Callable<Integer> task1 = new DatabaseMetaDataTask.GetMaxProcedureNameLength(dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxRowSize() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Integer> task0 = new DatabaseMetaDataTask.GetMaxRowSize(dbmds.get(0));
        final Callable<Integer> task1 = new DatabaseMetaDataTask.GetMaxRowSize(dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxSchemaNameLength() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Integer> task0 = new DatabaseMetaDataTask.GetMaxSchemaNameLength(dbmds.get(0));
        final Callable<Integer> task1 = new DatabaseMetaDataTask.GetMaxSchemaNameLength(dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxStatementLength() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Integer> task0 = new DatabaseMetaDataTask.GetMaxStatementLength(dbmds.get(0));
        final Callable<Integer> task1 = new DatabaseMetaDataTask.GetMaxStatementLength(dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxStatements() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Integer> task0 = new DatabaseMetaDataTask.GetMaxStatements(dbmds.get(0));
        final Callable<Integer> task1 = new DatabaseMetaDataTask.GetMaxStatements(dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxTableNameLength() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Integer> task0 = new DatabaseMetaDataTask.GetMaxTableNameLength(dbmds.get(0));
        final Callable<Integer> task1 = new DatabaseMetaDataTask.GetMaxTableNameLength(dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxTablesInSelect() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Integer> task0 = new DatabaseMetaDataTask.GetMaxTablesInSelect(dbmds.get(0));
        final Callable<Integer> task1 = new DatabaseMetaDataTask.GetMaxTablesInSelect(dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public int getMaxUserNameLength() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Integer> task0 = new DatabaseMetaDataTask.GetMaxUserNameLength(dbmds.get(0));
        final Callable<Integer> task1 = new DatabaseMetaDataTask.GetMaxUserNameLength(dbmds.get(1));
        final List<Integer> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).intValue();
    }
    
    public String getNumericFunctions() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<String> task0 = new DatabaseMetaDataTask.GetNumericFunctions(dbmds.get(0));
        final Callable<String> task1 = new DatabaseMetaDataTask.GetNumericFunctions(dbmds.get(1));
        final List<String> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1);
    }
    
    public ResultSet getPrimaryKeys(String arg0, String arg1, String arg2)
            throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<ResultSet> task0 = new DatabaseMetaDataTask.GetPrimaryKeys(dbmds.get(0), arg0, arg1, arg2);
        final Callable<ResultSet> task1 = new DatabaseMetaDataTask.GetPrimaryKeys(dbmds.get(1), arg0, arg1, arg2);
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public ResultSet getProcedureColumns(String arg0, String arg1, String arg2,
            String arg3) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<ResultSet> task0 = new DatabaseMetaDataTask.GetProcedureColumns(dbmds.get(0), arg0, arg1, arg2, arg3);
        final Callable<ResultSet> task1 = new DatabaseMetaDataTask.GetProcedureColumns(dbmds.get(1), arg0, arg1, arg2, arg3);
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public String getProcedureTerm() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<String> task0 = new DatabaseMetaDataTask.GetProcedureTerm(dbmds.get(0));
        final Callable<String> task1 = new DatabaseMetaDataTask.GetProcedureTerm(dbmds.get(1));
        final List<String> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1);
    }
    
    public ResultSet getProcedures(String arg0, String arg1, String arg2)
            throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<ResultSet> task0 = new DatabaseMetaDataTask.GetProcedures(dbmds.get(0), arg0, arg1, arg2);
        final Callable<ResultSet> task1 = new DatabaseMetaDataTask.GetProcedures(dbmds.get(1), arg0, arg1, arg2);
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public int getResultSetHoldability() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public String getSQLKeywords() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<String> task0 = new DatabaseMetaDataTask.GetSQLKeywords(dbmds.get(0));
        final Callable<String> task1 = new DatabaseMetaDataTask.GetSQLKeywords(dbmds.get(1));
        final List<String> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1);
    }
    
    public int getSQLStateType() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public String getSchemaTerm() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<String> task0 = new DatabaseMetaDataTask.GetSchemaTerm(dbmds.get(0));
        final Callable<String> task1 = new DatabaseMetaDataTask.GetSchemaTerm(dbmds.get(1));
        final List<String> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1);
    }
    
    public ResultSet getSchemas() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<ResultSet> task0 = new DatabaseMetaDataTask.GetSchemas(dbmds.get(0));
        final Callable<ResultSet> task1 = new DatabaseMetaDataTask.GetSchemas(dbmds.get(1));
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public String getSearchStringEscape() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<String> task0 = new DatabaseMetaDataTask.GetSearchStringEscape(dbmds.get(0));
        final Callable<String> task1 = new DatabaseMetaDataTask.GetSearchStringEscape(dbmds.get(1));
        final List<String> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1);
    }
    
    public String getStringFunctions() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<String> task0 = new DatabaseMetaDataTask.GetStringFunctions(dbmds.get(0));
        final Callable<String> task1 = new DatabaseMetaDataTask.GetStringFunctions(dbmds.get(1));
        final List<String> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1);
    }
    
    public ResultSet getSuperTables(String arg0, String arg1, String arg2)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public ResultSet getSuperTypes(String arg0, String arg1, String arg2)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public String getSystemFunctions() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<String> task0 = new DatabaseMetaDataTask.GetSystemFunctions(dbmds.get(0));
        final Callable<String> task1 = new DatabaseMetaDataTask.GetSystemFunctions(dbmds.get(1));
        final List<String> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1);
    }
    
    public ResultSet getTablePrivileges(String arg0, String arg1, String arg2)
            throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<ResultSet> task0 = new DatabaseMetaDataTask.GetTablePrivileges(dbmds.get(0), arg0, arg1, arg2);
        final Callable<ResultSet> task1 = new DatabaseMetaDataTask.GetTablePrivileges(dbmds.get(1), arg0, arg1, arg2);
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public ResultSet getTableTypes() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<ResultSet> task0 = new DatabaseMetaDataTask.GetTableTypes(dbmds.get(0));
        final Callable<ResultSet> task1 = new DatabaseMetaDataTask.GetTableTypes(dbmds.get(1));
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public ResultSet getTables(String arg0, String arg1, String arg2,
            String[] arg3) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<ResultSet> task0 = new DatabaseMetaDataTask.GetTables(dbmds.get(0), arg0, arg1, arg2, arg3);
        final Callable<ResultSet> task1 = new DatabaseMetaDataTask.GetTables(dbmds.get(1), arg0, arg1, arg2, arg3);
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public String getTimeDateFunctions() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<String> task0 = new DatabaseMetaDataTask.GetTimeDateFunctions(dbmds.get(0));
        final Callable<String> task1 = new DatabaseMetaDataTask.GetTimeDateFunctions(dbmds.get(1));
        final List<String> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1);
    }
    
    public ResultSet getTypeInfo() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<ResultSet> task0 = new DatabaseMetaDataTask.GetTypeInfo(dbmds.get(0));
        final Callable<ResultSet> task1 = new DatabaseMetaDataTask.GetTypeInfo(dbmds.get(1));
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public ResultSet getUDTs(String arg0, String arg1, String arg2, int[] arg3)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public String getURL() throws SQLException {
        return null;
    }
    
    public String getUserName() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<String> task0 = new DatabaseMetaDataTask.GetUserName(dbmds.get(0));
        final Callable<String> task1 = new DatabaseMetaDataTask.GetUserName(dbmds.get(1));
        final List<String> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1);
    }
    
    public ResultSet getVersionColumns(String arg0, String arg1, String arg2)
            throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<ResultSet> task0 = new DatabaseMetaDataTask.GetVersionColumns(dbmds.get(0), arg0, arg1, arg2);
        final Callable<ResultSet> task1 = new DatabaseMetaDataTask.GetVersionColumns(dbmds.get(1), arg0, arg1, arg2);
        final List<ResultSet> results = epCommonResource.executeAnyApi(task0, task1);
        final ForestResultSet newResultSet = new ForestResultSet(epCommonResource, results, (results.get(0) != null) ? 0 : 1);
        setForestResultSet(newResultSet);
        return newResultSet;
    }
    
    public boolean insertsAreDetected(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean isCatalogAtStart() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.IsCatalogAtStart(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.IsCatalogAtStart(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean isReadOnly() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.IsReadOnly(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.IsReadOnly(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean locatorsUpdateCopy() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean nullPlusNonNullIsNull() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.NullPlusNonNullIsNull(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.NullPlusNonNullIsNull(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean nullsAreSortedAtEnd() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.NullsAreSortedAtEnd(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.NullsAreSortedAtEnd(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean nullsAreSortedAtStart() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.NullsAreSortedAtStart(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.NullsAreSortedAtStart(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean nullsAreSortedHigh() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.NullsAreSortedHigh(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.NullsAreSortedHigh(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean nullsAreSortedLow() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.NullsAreSortedLow(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.NullsAreSortedLow(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean othersDeletesAreVisible(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean othersInsertsAreVisible(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean othersUpdatesAreVisible(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean ownDeletesAreVisible(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean ownInsertsAreVisible(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean ownUpdatesAreVisible(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.StoresLowerCaseIdentifiers(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.StoresLowerCaseIdentifiers(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.StoresLowerCaseQuotedIdentifiers(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.StoresLowerCaseQuotedIdentifiers(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.StoresMixedCaseIdentifiers(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.StoresMixedCaseIdentifiers(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.StoresMixedCaseQuotedIdentifiers(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.StoresMixedCaseQuotedIdentifiers(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.StoresUpperCaseIdentifiers(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.StoresUpperCaseIdentifiers(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.StoresUpperCaseQuotedIdentifiers(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.StoresUpperCaseQuotedIdentifiers(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsANSI92EntryLevelSQL(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsANSI92EntryLevelSQL(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsANSI92FullSQL() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsANSI92FullSQL(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsANSI92FullSQL(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsANSI92IntermediateSQL(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsANSI92IntermediateSQL(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsAlterTableWithAddColumn(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsAlterTableWithAddColumn(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsAlterTableWithDropColumn(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsAlterTableWithDropColumn(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsBatchUpdates() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsCatalogsInDataManipulation(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsCatalogsInDataManipulation(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsCatalogsInIndexDefinitions(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsCatalogsInIndexDefinitions(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsCatalogsInPrivilegeDefinitions(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsCatalogsInPrivilegeDefinitions(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsCatalogsInProcedureCalls(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsCatalogsInProcedureCalls(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsCatalogsInTableDefinitions(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsCatalogsInTableDefinitions(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsColumnAliasing() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsColumnAliasing(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsColumnAliasing(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsConvert() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsConvert(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsConvert(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsConvert(int arg0, int arg1) throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsConvert_IntInt(dbmds.get(0), arg0, arg1);
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsConvert_IntInt(dbmds.get(1), arg0, arg1);
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsCoreSQLGrammar() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsCoreSQLGrammar(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsCoreSQLGrammar(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsCorrelatedSubqueries(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsCorrelatedSubqueries(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsDataDefinitionAndDataManipulationTransactions()
            throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsDataDefinitionAndDataManipulationTransactions(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsDataDefinitionAndDataManipulationTransactions(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsDataManipulationTransactionsOnly()
            throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsDataManipulationTransactionsOnly(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsDataManipulationTransactionsOnly(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsDifferentTableCorrelationNames(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsDifferentTableCorrelationNames(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsExpressionsInOrderBy(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsExpressionsInOrderBy(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsExtendedSQLGrammar(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsExtendedSQLGrammar(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsFullOuterJoins() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsFullOuterJoins(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsFullOuterJoins(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsGetGeneratedKeys() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean supportsGroupBy() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsGroupBy(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsGroupBy(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsGroupByBeyondSelect(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsGroupByBeyondSelect(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsGroupByUnrelated() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsGroupByUnrelated(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsGroupByUnrelated(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsIntegrityEnhancementFacility(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsIntegrityEnhancementFacility(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsLikeEscapeClause() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsLikeEscapeClause(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsLikeEscapeClause(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsLimitedOuterJoins() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsLimitedOuterJoins(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsLimitedOuterJoins(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsMinimumSQLGrammar(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsMinimumSQLGrammar(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsMixedCaseIdentifiers(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsMixedCaseIdentifiers(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsMixedCaseQuotedIdentifiers(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsMixedCaseQuotedIdentifiers(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsMultipleOpenResults() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean supportsMultipleResultSets() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsMultipleResultSets(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsMultipleResultSets(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsMultipleTransactions() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsMultipleTransactions(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsMultipleTransactions(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsNamedParameters() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean supportsNonNullableColumns() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsNonNullableColumns(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsNonNullableColumns(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsOpenCursorsAcrossCommit(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsOpenCursorsAcrossCommit(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsOpenCursorsAcrossRollback(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsOpenCursorsAcrossRollback(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsOpenStatementsAcrossCommit(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsOpenStatementsAcrossCommit(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsOpenStatementsAcrossRollback(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsOpenStatementsAcrossRollback(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsOrderByUnrelated() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsOrderByUnrelated(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsOrderByUnrelated(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsOuterJoins() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsOuterJoins(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsOuterJoins(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsPositionedDelete() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsPositionedDelete(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsPositionedDelete(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsPositionedUpdate() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsPositionedUpdate(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsPositionedUpdate(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsResultSetConcurrency(int arg0, int arg1)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean supportsResultSetHoldability(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean supportsResultSetType(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean supportsSavepoints() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsSchemasInDataManipulation(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsSchemasInDataManipulation(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsSchemasInIndexDefinitions(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsSchemasInIndexDefinitions(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsSchemasInPrivilegeDefinitions(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsSchemasInPrivilegeDefinitions(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsSchemasInProcedureCalls(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsSchemasInProcedureCalls(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsSchemasInTableDefinitions(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsSchemasInTableDefinitions(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsSelectForUpdate() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsSelectForUpdate(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsSelectForUpdate(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsStatementPooling() throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean supportsStoredProcedures() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsStoredProcedures(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsStoredProcedures(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsSubqueriesInComparisons(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsSubqueriesInComparisons(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsSubqueriesInExists() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsSubqueriesInExists(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsSubqueriesInExists(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsSubqueriesInIns() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsSubqueriesInIns(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsSubqueriesInIns(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsSubqueriesInQuantifieds(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsSubqueriesInQuantifieds(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsTableCorrelationNames() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsTableCorrelationNames(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsTableCorrelationNames(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsTransactionIsolationLevel(int arg0)
            throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsTransactionIsolationLevel(dbmds.get(0), arg0);
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsTransactionIsolationLevel(dbmds.get(1), arg0);
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsTransactions() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsTransactions(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsTransactions(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsUnion() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsUnion(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsUnion(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean supportsUnionAll() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.SupportsUnionAll(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.SupportsUnionAll(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean updatesAreDetected(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean usesLocalFilePerTable() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.UsesLocalFilePerTable(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.UsesLocalFilePerTable(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public boolean usesLocalFiles() throws SQLException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        final Callable<Boolean> task0 = new DatabaseMetaDataTask.UsesLocalFiles(dbmds.get(0));
        final Callable<Boolean> task1 = new DatabaseMetaDataTask.UsesLocalFiles(dbmds.get(1));
        final List<Boolean> results = epCommonResource.executeAnyApi(task0, task1);
        return results.get((results.get(0) != null) ? 0 : 1).booleanValue();
    }
    
    public void close() {
        if (isClosed == false && resultSet != null) {
            try {
                ((ForestCloseable) resultSet).close();
            } catch (SQLException ignore) { 
            }
        }
        this.isClosed = true;
    }
    
    public void closeOneSide(int serverId) {
        if (isClosed == false && resultSet != null) {
            ((ForestCloseable) resultSet).closeOneSide(serverId);
            dbmds.set(serverId, null);
        }
    }
    
    public List<UdbValidity> getValidityList() throws ForestResourceDisposedException {
        if (isClosed) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
        return epCommonResource.getValidityList();
    }
}
