package org.postgresforest.test;
import java.sql.*;

public class ConnectionTest {
    
    /**
     * @param args
     */
    public static void main(String[] args) {
        {
            Connection con = null;
            try {
                Class.forName("org.postgresforest.Driver");
                con = DriverManager.getConnection("jdbc:postgresforest://10.68.154.152:5432,10.68.154.152:5433/udb?opt1=test", "forestdevel", "foresthoge");
                
                con.setAutoCommit(false);
                Statement stmt = con.createStatement();
                System.out.println("update count = " + stmt.executeUpdate("insert into test values (1000)"));
                ResultSet res = stmt.executeQuery("select * from test where i = 1000");
                
                int count = 1;
                while(res.next()) {
                    System.out.println("record " + count++ + " : value = " + res.getInt(1));
                }
                
                con.rollback();
                
                stmt = con.createStatement();
                res = stmt.executeQuery("select * from test where i = 1000");
                count = 1;
                while(res.next()) {
                    System.out.println("record " + count++ + " : value = " + res.getInt(1));
                }
                
            } catch (Exception e) {
                if (e instanceof SQLException) {
                    System.err.println("sqlerror_code : " + ((SQLException) e).getSQLState());
                }
                e.printStackTrace();
            } finally {
                if (con != null) {
                    try { con.close(); } catch (SQLException e) { }
                }
            }
        }
    }
}
