/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.util;

import com.clustercontrol.jobmanagement.message.RunResultInfo;
import java.io.Serializable;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SendQueue {
    protected static Log m_log = LogFactory.getLog(SendQueue.class);
    protected String m_queueName;
    protected QueueConnectionFactory m_connectionFactory;
    protected QueueConnection m_connection;
    protected Queue m_queue;
    protected QueueSession m_session;
    static /* synthetic */ Class class$0;

    public SendQueue(String queueName) throws NamingException, JMSException {
        this.m_queueName = queueName;
    }

    public void put(RunResultInfo info) throws JMSException, NamingException {
        InitialContext context = null;
        String serverName = System.getProperty("jboss.server.name");
        if (serverName.equals("all")) {
            Properties properties = new Properties();
            properties.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
            properties.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
            properties.put("java.naming.provider.url", "jnp://localhost:1100");
            context = new InitialContext(properties);
        } else {
            context = new InitialContext();
        }
        this.m_connectionFactory = (QueueConnectionFactory)context.lookup("ConnectionFactory");
        this.m_connection = this.m_connectionFactory.createQueueConnection();
        this.m_session = this.m_connection.createQueueSession(false, 1);
        this.m_queue = (Queue)context.lookup(this.m_queueName);
        QueueSender sender = this.m_session.createSender(this.m_queue);
        ObjectMessage message = this.m_session.createObjectMessage((Serializable)info);
        sender.send((Message)message);
        m_log.debug((Object)("put() send: SessionId = " + info.getSessionId() + ", JobId = " + info.getJobId() + ", FacilityId = " + info.getFacilityId() + ", status = " + info.getStatus() + ", CommandType = " + info.getCommandType()));
        sender.close();
        this.m_session.close();
        this.m_connection.close();
        context.close();
    }
}

