/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.util;

import com.clustercontrol.jobmanagement.message.RunInstructionInfo;
import java.io.Serializable;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SendTopic {
    protected static Log m_log = LogFactory.getLog(SendTopic.class);
    protected String m_topicName;
    protected TopicConnectionFactory m_connectionFactory;
    protected TopicConnection m_connection;
    protected Topic m_topic;
    protected TopicSession m_session;
    static /* synthetic */ Class class$0;

    public SendTopic(String topicName) throws NamingException, JMSException {
        this.m_topicName = topicName;
        this.connect();
    }

    protected void connect() throws NamingException, JMSException {
        InitialContext context = null;
        String serverName = System.getProperty("jboss.server.name");
        if (serverName.equals("all")) {
            Properties properties = new Properties();
            properties.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
            properties.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
            properties.put("java.naming.provider.url", "jnp://localhost:1100");
            context = new InitialContext(properties);
        } else {
            context = new InitialContext();
        }
        this.m_connectionFactory = (TopicConnectionFactory)context.lookup("ConnectionFactory");
        this.m_connection = this.m_connectionFactory.createTopicConnection();
        this.m_session = this.m_connection.createTopicSession(false, 1);
        this.m_topic = (Topic)context.lookup(this.m_topicName);
        context.close();
    }

    public void put(RunInstructionInfo info) throws JMSException {
        TopicPublisher publisher = this.m_session.createPublisher(this.m_topic);
        ObjectMessage message = this.m_session.createObjectMessage((Serializable)info);
        message.setStringProperty("FacilityId", info.getFacilityId());
        publisher.publish((Message)message);
        m_log.debug((Object)("put() topic: SessionId = " + info.getSessionId() + ", JobId = " + info.getJobId() + ", FacilityId = " + info.getFacilityId() + ", CommandType = " + info.getCommandType()));
        publisher.close();
        this.m_session.close();
        this.m_connection.close();
    }
}

