/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.dao;

import com.clustercontrol.repository.dao.DeviceInfoDAO;
import com.clustercontrol.repository.ejb.entity.DeviceInfoBean;
import com.clustercontrol.repository.ejb.entity.DeviceInfoPK;
import com.clustercontrol.repository.util.LdapConnectionManager;
import com.clustercontrol.util.apllog.AplLogger;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeviceInfoDAOImpl
implements DeviceInfoDAO {
    protected static Log m_log = LogFactory.getLog(DeviceInfoDAOImpl.class);
    protected static final String OBJECTCLASS = "objectClass";
    protected static final String BASE_DN = "ou=facility";
    protected static final String OBJECT_CLASS_DEVICE_INFO = "ccDeviceInfo";
    static /* synthetic */ Class class$0;

    public void init() {
    }

    public void load(DeviceInfoPK pk, DeviceInfoBean ejb) throws EJBException {
        try {
            this.clearBean(ejb);
            DirContext ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            Attributes attrs = ctx.getAttributes(pk.getDn());
            ejb.setDn(pk.getDn());
            ejb.setCn((String)attrs.get("cn").get(0));
            if (attrs.get("ccSnmpOID") != null) {
                ejb.setSnmpOID((String)attrs.get("ccSnmpOID").get(0));
            }
            if (attrs.get("ccDeviceIndex") != null) {
                ejb.setDeviceIndex(new Integer((String)attrs.get("ccDeviceIndex").get(0)));
            }
            if (attrs.get("ccDeviceType") != null) {
                ejb.setDeviceType((String)attrs.get("ccDeviceType").get(0));
            }
            if (attrs.get("description") != null) {
                ejb.setDescription((String)attrs.get("description").get(0));
            }
            String dn = ejb.getDn();
            dn = dn.replaceFirst("[\\s\\w=]*,", "");
            dn = dn.replaceFirst(",[\\s\\w=]*", "");
            dn = dn.replaceFirst("ccFacilityId=", "");
            ejb.setFacilityId(dn);
        }
        catch (NamingException ex) {
            if (ex instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            throw new EJBException((Exception)ex);
        }
    }

    public void store(DeviceInfoBean ejb) throws EJBException {
        try {
            DirContext ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            Attributes attrs = ctx.getAttributes(ejb.getDn());
            BasicAttributes addAttrs = new BasicAttributes();
            BasicAttributes replaceAttrs = new BasicAttributes();
            BasicAttributes removeAttrs = new BasicAttributes();
            if (attrs.get("description") == null && ejb.getDescription() != null) {
                addAttrs.put("description", ejb.getDescription());
            } else if (attrs.get("description") != null && ejb.getDescription() == null) {
                removeAttrs.put("description", null);
            } else if (attrs.get("description") != null && ejb.getDescription() != null) {
                replaceAttrs.put("description", ejb.getDescription());
            }
            if (attrs.get("ccSnmpOID") == null && ejb.getSnmpOID() != null) {
                addAttrs.put("ccSnmpOID", ejb.getSnmpOID());
            } else if (attrs.get("ccSnmpOID") != null && ejb.getSnmpOID() == null) {
                removeAttrs.put("ccSnmpOID", null);
            } else if (attrs.get("ccSnmpOID") != null && ejb.getSnmpOID() != null) {
                replaceAttrs.put("ccSnmpOID", ejb.getSnmpOID());
            }
            if (attrs.get("ccDeviceIndex") == null && ejb.getDeviceIndex() != null) {
                addAttrs.put("ccDeviceIndex", ejb.getDeviceIndex().toString());
            } else if (attrs.get("ccDeviceIndex") != null && ejb.getDeviceIndex() == null) {
                removeAttrs.put("ccDeviceIndex", null);
            } else if (attrs.get("ccDeviceIndex") != null && ejb.getDeviceIndex() != null) {
                replaceAttrs.put("ccDeviceIndex", ejb.getDeviceIndex().toString());
            }
            if (attrs.get("ccDeviceType") == null && ejb.getDeviceType() != null) {
                addAttrs.put("ccDeviceType", ejb.getDeviceType());
            } else if (attrs.get("ccDeviceType") != null && ejb.getDeviceType() == null) {
                removeAttrs.put("ccDeviceType", null);
            } else if (attrs.get("ccDeviceType") != null && ejb.getDeviceType() != null) {
                replaceAttrs.put("ccDeviceType", ejb.getDeviceType());
            }
            ctx.modifyAttributes(ejb.getDn(), 1, (Attributes)addAttrs);
            ctx.modifyAttributes(ejb.getDn(), 2, (Attributes)replaceAttrs);
            ctx.modifyAttributes(ejb.getDn(), 3, (Attributes)removeAttrs);
        }
        catch (NamingException ex) {
            if (ex instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            throw new EJBException((Exception)ex);
        }
    }

    public void remove(DeviceInfoPK pk) throws RemoveException, EJBException {
        try {
            DirContext ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            ctx.destroySubcontext(pk.getDn());
        }
        catch (NamingException ex) {
            if (ex instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            AplLogger apllog = new AplLogger("REP", "rep");
            Object[] args = new String[]{pk.getDn()};
            apllog.put("SYS", "004", args);
            throw new EJBException((Exception)ex);
        }
    }

    public DeviceInfoPK create(DeviceInfoBean ejb) throws CreateException, EJBException {
        DeviceInfoPK pk = null;
        try {
            DirContext ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            BasicAttributes attrs = new BasicAttributes();
            attrs.put(OBJECTCLASS, OBJECT_CLASS_DEVICE_INFO);
            attrs.put("cn", ejb.getCn());
            StringBuffer dn = new StringBuffer();
            dn.append("cn");
            dn.append("=");
            dn.append(ejb.getCn());
            dn.append(",");
            dn.append("ccFacilityId");
            dn.append("=");
            dn.append(ejb.getFacilityId());
            dn.append(",");
            dn.append(BASE_DN);
            ejb.setDn(dn.toString());
            ctx.createSubcontext(ejb.getDn(), (Attributes)attrs);
            pk = new DeviceInfoPK(ejb.getDn());
        }
        catch (NamingException ex) {
            if (ex instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            AplLogger apllog = new AplLogger("REP", "rep");
            Object[] args = new String[]{ejb.getDn()};
            apllog.put("SYS", "003", args);
            throw new EJBException((Exception)ex);
        }
        return pk;
    }

    /*
     * Unable to fully structure code
     */
    public Collection findAll() throws FinderException {
        ret = new ArrayList<DeviceInfoPK>();
        DeviceInfoDAOImpl.m_log.debug((Object)"findAll()");
        ctx = LdapConnectionManager.getConnectionManager().getDirContext();
        constraints = new SearchControls();
        constraints.setSearchScope(2);
        search = new StringBuffer();
        search.append("(&(");
        search.append("objectClass");
        search.append("=");
        search.append("ccDeviceInfo");
        search.append("))");
        results = null;
        try {
            results = ctx.search("ou=facility", search.toString(), constraints);
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            DeviceInfoDAOImpl.m_log.debug((Object)("findAll() : " + e.getMessage()));
        }
        if (results != null) ** GOTO lbl32
        DeviceInfoDAOImpl.m_log.debug((Object)"findAll() : No Search Result");
        return ret;
lbl-1000:
        // 1 sources

        {
            aResult = (SearchResult)results.nextElement();
            pk = new DeviceInfoPK(String.valueOf(aResult.getName()) + "," + "ou=facility");
            ret.add(pk);
lbl32:
            // 2 sources

            ** while (results.hasMoreElements())
        }
lbl33:
        // 1 sources

        return ret;
    }

    public DeviceInfoPK findByPrimaryKey(DeviceInfoPK pk) throws FinderException {
        try {
            m_log.debug((Object)("findByPrimaryKey() : dn = " + pk.getDn()));
            DirContext ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            Attributes attrs = ctx.getAttributes(pk.getDn());
            return pk;
        }
        catch (NamingException ex) {
            if (ex instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            m_log.debug((Object)("findByPrimaryKey() : " + ex.getMessage()));
            throw new FinderException("dn=" + pk.getDn() + " not found.");
        }
    }

    /*
     * Unable to fully structure code
     */
    public Collection findByFacilityId(String facilityId) throws FinderException {
        ret = new ArrayList<DeviceInfoPK>();
        DeviceInfoDAOImpl.m_log.debug((Object)("findByFacilityId() : FacilityId = " + facilityId));
        ctx = LdapConnectionManager.getConnectionManager().getDirContext();
        constraints = new SearchControls();
        constraints.setSearchScope(2);
        baseDn = new StringBuffer();
        baseDn.append("ccFacilityId");
        baseDn.append("=");
        baseDn.append(facilityId);
        baseDn.append(",");
        baseDn.append("ou=facility");
        search = new StringBuffer();
        search.append("(&(");
        search.append("objectClass");
        search.append("=");
        search.append("ccDeviceInfo");
        search.append("))");
        results = null;
        try {
            results = ctx.search(baseDn.toString(), search.toString(), constraints);
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            DeviceInfoDAOImpl.m_log.debug((Object)("findByFacilityId() : " + e.getMessage()));
        }
        if (results != null) ** GOTO lbl43
        DeviceInfoDAOImpl.m_log.debug((Object)("findByFacilityId() : No Search Result : FacilityId = " + facilityId));
        return ret;
lbl-1000:
        // 1 sources

        {
            aResult = (SearchResult)results.nextElement();
            pk = new DeviceInfoPK(String.valueOf(aResult.getName()) + "," + baseDn.toString());
            ret.add(pk);
lbl43:
            // 2 sources

            ** while (results.hasMoreElements())
        }
lbl44:
        // 1 sources

        return ret;
    }

    public DeviceInfoPK findByFacilityIdAndName(String facilityId, String name) throws FinderException {
        m_log.debug((Object)("findByFacilityIdAndName() : FacilityId = " + facilityId + ", FacilityName = " + name));
        DirContext ctx = LdapConnectionManager.getConnectionManager().getDirContext();
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        StringBuffer baseDn = new StringBuffer();
        baseDn.append("ccFacilityId");
        baseDn.append("=");
        baseDn.append(facilityId);
        baseDn.append(",");
        baseDn.append(BASE_DN);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_DEVICE_INFO);
        search.append(")(");
        search.append("cn");
        search.append("=");
        search.append(name);
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        try {
            results = ctx.search(baseDn.toString(), search.toString(), constraints);
        }
        catch (NamingException ex) {
            if (ex instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            m_log.debug((Object)("findByFacilityIdAndName() : " + ex.getMessage()));
            throw new FinderException("FacilityId = " + facilityId + ", FacilityName = " + name + " not found.");
        }
        DeviceInfoPK pk = null;
        if (!results.hasMoreElements()) {
            throw new FinderException("FacilityId = " + facilityId + ", FacilityName = " + name + " not found.");
        }
        SearchResult aResult = (SearchResult)results.nextElement();
        pk = new DeviceInfoPK(String.valueOf(aResult.getName()) + "," + baseDn.toString());
        return pk;
    }

    protected void clearBean(DeviceInfoBean ejb) {
        ejb.setCn(null);
        ejb.setDescription(null);
        ejb.setDeviceIndex(null);
        ejb.setDeviceType(null);
        ejb.setDn(null);
        ejb.setFacilityId(null);
        ejb.setSnmpOID(null);
    }
}

