/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.dao;

import com.clustercontrol.repository.dao.FacilityDAO;
import com.clustercontrol.repository.ejb.entity.FacilityBean;
import com.clustercontrol.repository.ejb.entity.FacilityPK;
import com.clustercontrol.repository.util.LdapConnectionManager;
import com.clustercontrol.util.apllog.AplLogger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FacilityDAOImpl
implements FacilityDAO {
    protected static Log m_log = LogFactory.getLog(FacilityDAOImpl.class);
    protected static final String OBJECTCLASS = "objectClass";
    protected static final String BASE_DN = "ou=facility";
    protected static final String OBJECT_CLASS_NODE = "ccNode";
    protected static final String OBJECT_CLASS_SCOPE = "ccScope";
    protected static final String OBJECT_CLASS_FACILITY = "ccFacility";
    static /* synthetic */ Class class$0;

    public void init() {
    }

    public void load(FacilityPK pk, FacilityBean ejb) throws EJBException {
        try {
            this.clearBean(ejb);
            DirContext ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            Attributes attrs = ctx.getAttributes(pk.getDn());
            ejb.setDn(pk.getDn());
            ejb.setFacilityId((String)attrs.get("ccFacilityId").get(0));
            ejb.setCn((String)attrs.get("cn").get(0));
            if (attrs.get("description") != null) {
                ejb.setDescription((String)attrs.get("description").get(0));
            }
            NamingEnumeration<?> objectClass = attrs.get(OBJECTCLASS).getAll();
            while (objectClass.hasMoreElements()) {
                String name = (String)objectClass.nextElement();
                if (name.compareTo(OBJECT_CLASS_NODE) == 0) {
                    ejb.setType(1);
                    break;
                }
                if (name.compareTo(OBJECT_CLASS_SCOPE) != 0) continue;
                ejb.setType(0);
                break;
            }
            if (ejb.getType() == 1) {
                if (attrs.get("ccAgentControl") != null) {
                    ejb.setAgentControl(this.stringToBoolean((String)attrs.get("ccAgentControl").get(0)));
                }
                if (attrs.get("ccAgentWatch") != null) {
                    ejb.setAgentWatch(this.stringToBoolean((String)attrs.get("ccAgentWatch").get(0)));
                }
                if (attrs.get("ccAgentWatchStatus") != null) {
                    ejb.setAgentWatchStatus(this.stringToBoolean((String)attrs.get("ccAgentWatchStatus").get(0)));
                }
                if (attrs.get("ccCharSet") != null) {
                    ejb.setCharSet((String)attrs.get("ccCharSet").get(0));
                }
                if (attrs.get("ccCreateTimestamp") != null) {
                    ejb.setCreateTimestamp(this.stringToDate((String)attrs.get("ccCreateTimestamp").get(0)));
                }
                if (attrs.get("ccCreatorsName") != null) {
                    ejb.setCreatorsName((String)attrs.get("ccCreatorsName").get(0));
                }
                if (attrs.get("ccDhcpClient") != null) {
                    ejb.setDhcpClient(this.stringToBoolean((String)attrs.get("ccDhcpClient").get(0)));
                }
                if (attrs.get("host") != null) {
                    NamingEnumeration<?> hosts = attrs.get("host").getAll();
                    ArrayList<String> hostList = new ArrayList<String>();
                    while (hosts.hasMoreElements()) {
                        String host = (String)hosts.nextElement();
                        hostList.add(host);
                    }
                    ejb.setHost(hostList);
                }
                if (attrs.get("ipNetworkNumber") != null) {
                    ejb.setIpNetworkNumber((String)attrs.get("ipNetworkNumber").get(0));
                }
                if (attrs.get("ccIpNetworkNumberV6") != null) {
                    ejb.setIpNetworkNumberV6((String)attrs.get("ccIpNetworkNumberV6").get(0));
                }
                if (attrs.get("ipProtocolNumber") != null) {
                    ejb.setIpProtocolNumber(new Integer((String)attrs.get("ipProtocolNumber").get(0)));
                }
                if (attrs.get("ccIpType") != null) {
                    ejb.setIpType(new Integer((String)attrs.get("ccIpType").get(0)));
                }
                if (attrs.get("ccLogWatch") != null) {
                    ejb.setLogWatch(this.stringToBoolean((String)attrs.get("ccLogWatch").get(0)));
                }
                if (attrs.get("ccMachine") != null) {
                    ejb.setMachine((String)attrs.get("ccMachine").get(0));
                }
                if (attrs.get("ccManagerContact") != null) {
                    ejb.setManagerContact((String)attrs.get("ccManagerContact").get(0));
                }
                if (attrs.get("ccManagerName") != null) {
                    ejb.setManagerName((String)attrs.get("ccManagerName").get(0));
                }
                if (attrs.get("ccModifiersName") != null) {
                    ejb.setModifiersName((String)attrs.get("ccModifiersName").get(0));
                }
                if (attrs.get("ccModifyTimestamp") != null) {
                    ejb.setModifyTimestamp(this.stringToDate((String)attrs.get("ccModifyTimestamp").get(0)));
                }
                if (attrs.get("ccNodeName") != null) {
                    ejb.setNodeName((String)attrs.get("ccNodeName").get(0));
                }
                if (attrs.get("ccOsName") != null) {
                    ejb.setOsName((String)attrs.get("ccOsName").get(0));
                }
                if (attrs.get("ccOsRelease") != null) {
                    ejb.setOsRelease((String)attrs.get("ccOsRelease").get(0));
                }
                if (attrs.get("ccOsVersion") != null) {
                    ejb.setOsVersion((String)attrs.get("ccOsVersion").get(0));
                }
                if (attrs.get("ccPingWatch") != null) {
                    ejb.setPingWatch(this.stringToBoolean((String)attrs.get("ccPingWatch").get(0)));
                }
                if (attrs.get("ccPingWatchStatus") != null) {
                    ejb.setPingWatchStatus(this.stringToBoolean((String)attrs.get("ccPingWatchStatus").get(0)));
                }
                if (attrs.get("ccPlatform") != null) {
                    ejb.setPlatform((String)attrs.get("ccPlatform").get(0));
                }
                if (attrs.get("ccStatusWatch") != null) {
                    ejb.setStatusWatch(this.stringToBoolean((String)attrs.get("ccStatusWatch").get(0)));
                }
            }
        }
        catch (NamingException ex) {
            if (ex instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            throw new EJBException((Exception)ex);
        }
    }

    public void store(FacilityBean ejb) throws EJBException {
        try {
            DirContext ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            Attributes attrs = ctx.getAttributes(ejb.getDn());
            BasicAttributes addAttrs = new BasicAttributes();
            BasicAttributes replaceAttrs = new BasicAttributes();
            BasicAttributes removeAttrs = new BasicAttributes();
            if (ejb.getCn() != null) {
                replaceAttrs.put("cn", ejb.getCn());
            } else if (ejb.getCn() == null) {
                removeAttrs.put("cn", null);
            }
            if (attrs.get("description") == null && ejb.getDescription() != null) {
                addAttrs.put("description", ejb.getDescription());
            } else if (attrs.get("description") != null && ejb.getDescription() == null) {
                removeAttrs.put("description", null);
            } else if (attrs.get("description") != null && ejb.getDescription() != null) {
                replaceAttrs.put("description", ejb.getDescription());
            }
            if (ejb.getType() == 1) {
                if (attrs.get("ccAgentControl") == null && ejb.getAgentControl() != null) {
                    addAttrs.put("ccAgentControl", this.booleanToString(ejb.getAgentControl()));
                } else if (attrs.get("ccAgentControl") != null && ejb.getAgentControl() == null) {
                    removeAttrs.put("ccAgentControl", null);
                } else if (attrs.get("ccAgentControl") != null && ejb.getAgentControl() != null) {
                    replaceAttrs.put("ccAgentControl", this.booleanToString(ejb.getAgentControl()));
                }
                if (attrs.get("ccAgentWatch") == null && ejb.getAgentWatch() != null) {
                    addAttrs.put("ccAgentWatch", this.booleanToString(ejb.getAgentWatch()));
                } else if (attrs.get("ccAgentWatch") != null && ejb.getAgentWatch() == null) {
                    removeAttrs.put("ccAgentWatch", null);
                } else if (attrs.get("ccAgentWatch") != null && ejb.getAgentWatch() != null) {
                    replaceAttrs.put("ccAgentWatch", this.booleanToString(ejb.getAgentWatch()));
                }
                if (attrs.get("ccAgentWatchStatus") == null && ejb.getAgentWatchStatus() != null) {
                    addAttrs.put("ccAgentWatchStatus", this.booleanToString(ejb.getAgentWatchStatus()));
                } else if (attrs.get("ccAgentWatchStatus") != null && ejb.getAgentWatchStatus() == null) {
                    removeAttrs.put("ccAgentWatchStatus", null);
                } else if (attrs.get("ccAgentWatchStatus") != null && ejb.getAgentWatchStatus() != null) {
                    replaceAttrs.put("ccAgentWatchStatus", this.booleanToString(ejb.getAgentWatchStatus()));
                }
                if (attrs.get("ccCharSet") == null && ejb.getCharSet() != null) {
                    addAttrs.put("ccCharSet", ejb.getCharSet());
                } else if (attrs.get("ccCharSet") != null && ejb.getCharSet() == null) {
                    removeAttrs.put("ccCharSet", null);
                } else if (attrs.get("ccCharSet") != null && ejb.getCharSet() != null) {
                    replaceAttrs.put("ccCharSet", ejb.getCharSet());
                }
                if (attrs.get("ccCreateTimestamp") == null && ejb.getCreateTimestamp() != null) {
                    addAttrs.put("ccCreateTimestamp", this.dateToString(ejb.getCreateTimestamp()));
                } else if (attrs.get("ccCreateTimestamp") != null && ejb.getCreateTimestamp() == null) {
                    removeAttrs.put("ccCreateTimestamp", null);
                } else if (attrs.get("ccCreateTimestamp") != null && ejb.getCreateTimestamp() != null) {
                    replaceAttrs.put("ccCreateTimestamp", this.dateToString(ejb.getCreateTimestamp()));
                }
                if (attrs.get("ccCreatorsName") == null && ejb.getCreatorsName() != null) {
                    addAttrs.put("ccCreatorsName", ejb.getCreatorsName());
                } else if (attrs.get("ccCreatorsName") != null && ejb.getCreatorsName() == null) {
                    removeAttrs.put("ccCreatorsName", null);
                } else if (attrs.get("ccCreatorsName") != null && ejb.getCreatorsName() != null) {
                    replaceAttrs.put("ccCreatorsName", ejb.getCreatorsName());
                }
                if (attrs.get("ccDhcpClient") == null && ejb.getDhcpClient() != null) {
                    addAttrs.put("ccDhcpClient", this.booleanToString(ejb.getDhcpClient()));
                } else if (attrs.get("ccDhcpClient") != null && ejb.getDhcpClient() == null) {
                    removeAttrs.put("ccDhcpClient", null);
                } else if (attrs.get("ccDhcpClient") != null && ejb.getDhcpClient() != null) {
                    replaceAttrs.put("ccDhcpClient", this.booleanToString(ejb.getDhcpClient()));
                }
                if (attrs.get("host") == null && ejb.getHost() != null) {
                    BasicAttribute attr = new BasicAttribute("host");
                    ArrayList list = ejb.getHost();
                    int i = 0;
                    while (i < list.size()) {
                        String host = (String)list.get(i);
                        attr.add(i, host);
                        ++i;
                    }
                    addAttrs.put(attr);
                } else if (attrs.get("host") != null && ejb.getHost() == null) {
                    removeAttrs.put("host", null);
                } else if (attrs.get("host") != null && ejb.getHost() != null) {
                    BasicAttribute attr = new BasicAttribute("host");
                    ArrayList list = ejb.getHost();
                    int i = 0;
                    while (i < list.size()) {
                        String host = (String)list.get(i);
                        attr.add(i, host);
                        ++i;
                    }
                    replaceAttrs.put(attr);
                }
                if (attrs.get("ipNetworkNumber") == null && ejb.getIpNetworkNumber() != null) {
                    addAttrs.put("ipNetworkNumber", ejb.getIpNetworkNumber());
                } else if (attrs.get("ipNetworkNumber") != null && ejb.getIpNetworkNumber() == null) {
                    removeAttrs.put("ipNetworkNumber", null);
                } else if (attrs.get("ipNetworkNumber") != null && ejb.getIpNetworkNumber() != null) {
                    replaceAttrs.put("ipNetworkNumber", ejb.getIpNetworkNumber());
                }
                if (attrs.get("ccIpNetworkNumberV6") == null && ejb.getIpNetworkNumberV6() != null) {
                    addAttrs.put("ccIpNetworkNumberV6", ejb.getIpNetworkNumberV6());
                } else if (attrs.get("ccIpNetworkNumberV6") != null && ejb.getIpNetworkNumberV6() == null) {
                    removeAttrs.put("ccIpNetworkNumberV6", null);
                } else if (attrs.get("ccIpNetworkNumberV6") != null && ejb.getIpNetworkNumberV6() != null) {
                    replaceAttrs.put("ccIpNetworkNumberV6", ejb.getIpNetworkNumberV6());
                }
                if (attrs.get("ipProtocolNumber") == null && ejb.getIpProtocolNumber() != null) {
                    addAttrs.put("ipProtocolNumber", ejb.getIpProtocolNumber().toString());
                } else if (attrs.get("ipProtocolNumber") != null && ejb.getIpProtocolNumber() == null) {
                    removeAttrs.put("ipProtocolNumber", null);
                } else if (attrs.get("ipProtocolNumber") != null && ejb.getIpProtocolNumber() != null) {
                    replaceAttrs.put("ipProtocolNumber", ejb.getIpProtocolNumber().toString());
                }
                if (attrs.get("ccIpType") == null && ejb.getIpType() != null) {
                    addAttrs.put("ccIpType", ejb.getIpType().toString());
                } else if (attrs.get("ccIpType") != null && ejb.getIpType() == null) {
                    removeAttrs.put("ccIpType", null);
                } else if (attrs.get("ccIpType") != null && ejb.getIpType() != null) {
                    replaceAttrs.put("ccIpType", ejb.getIpType().toString());
                }
                if (attrs.get("ccLogWatch") == null && ejb.getLogWatch() != null) {
                    addAttrs.put("ccLogWatch", this.booleanToString(ejb.getLogWatch()));
                } else if (attrs.get("ccLogWatch") != null && ejb.getLogWatch() == null) {
                    removeAttrs.put("ccLogWatch", null);
                } else if (attrs.get("ccLogWatch") != null && ejb.getLogWatch() != null) {
                    replaceAttrs.put("ccLogWatch", this.booleanToString(ejb.getLogWatch()));
                }
                if (attrs.get("ccMachine") == null && ejb.getMachine() != null) {
                    addAttrs.put("ccMachine", ejb.getMachine());
                } else if (attrs.get("ccMachine") != null && ejb.getMachine() == null) {
                    removeAttrs.put("ccMachine", null);
                } else if (attrs.get("ccMachine") != null && ejb.getMachine() != null) {
                    replaceAttrs.put("ccMachine", ejb.getMachine());
                }
                if (attrs.get("ccManagerContact") == null && ejb.getManagerContact() != null) {
                    addAttrs.put("ccManagerContact", ejb.getManagerContact());
                } else if (attrs.get("ccManagerContact") != null && ejb.getManagerContact() == null) {
                    removeAttrs.put("ccManagerContact", null);
                } else if (attrs.get("ccManagerContact") != null && ejb.getManagerContact() != null) {
                    replaceAttrs.put("ccManagerContact", ejb.getManagerContact());
                }
                if (attrs.get("ccManagerName") == null && ejb.getManagerName() != null) {
                    addAttrs.put("ccManagerName", ejb.getManagerName());
                } else if (attrs.get("ccManagerName") != null && ejb.getManagerName() == null) {
                    removeAttrs.put("ccManagerName", null);
                } else if (attrs.get("ccManagerName") != null && ejb.getManagerName() != null) {
                    replaceAttrs.put("ccManagerName", ejb.getManagerName());
                }
                if (attrs.get("ccModifiersName") == null && ejb.getModifiersName() != null) {
                    addAttrs.put("ccModifiersName", ejb.getModifiersName());
                } else if (attrs.get("ccModifiersName") != null && ejb.getModifiersName() == null) {
                    removeAttrs.put("ccModifiersName", null);
                } else if (attrs.get("ccModifiersName") != null && ejb.getModifiersName() != null) {
                    replaceAttrs.put("ccModifiersName", ejb.getModifiersName());
                }
                if (attrs.get("ccModifyTimestamp") == null && ejb.getModifyTimestamp() != null) {
                    addAttrs.put("ccModifyTimestamp", this.dateToString(ejb.getModifyTimestamp()));
                } else if (attrs.get("ccModifyTimestamp") != null && ejb.getModifyTimestamp() == null) {
                    removeAttrs.put("ccModifyTimestamp", null);
                } else if (attrs.get("ccModifyTimestamp") != null && ejb.getModifyTimestamp() != null) {
                    replaceAttrs.put("ccModifyTimestamp", this.dateToString(ejb.getModifyTimestamp()));
                }
                if (attrs.get("ccNodeName") == null && ejb.getNodeName() != null) {
                    addAttrs.put("ccNodeName", ejb.getNodeName());
                } else if (attrs.get("ccNodeName") != null && ejb.getNodeName() == null) {
                    removeAttrs.put("ccNodeName", null);
                } else if (attrs.get("ccNodeName") != null && ejb.getNodeName() != null) {
                    replaceAttrs.put("ccNodeName", ejb.getNodeName());
                }
                if (attrs.get("ccOsName") == null && ejb.getOsName() != null) {
                    addAttrs.put("ccOsName", ejb.getOsName());
                } else if (attrs.get("ccOsName") != null && ejb.getOsName() == null) {
                    removeAttrs.put("ccOsName", null);
                } else if (attrs.get("ccOsName") != null && ejb.getOsName() != null) {
                    replaceAttrs.put("ccOsName", ejb.getOsName());
                }
                if (attrs.get("ccOsRelease") == null && ejb.getOsRelease() != null) {
                    addAttrs.put("ccOsRelease", ejb.getOsRelease());
                } else if (attrs.get("ccOsRelease") != null && ejb.getOsRelease() == null) {
                    removeAttrs.put("ccOsRelease", null);
                } else if (attrs.get("ccOsRelease") != null && ejb.getOsRelease() != null) {
                    replaceAttrs.put("ccOsRelease", ejb.getOsRelease());
                }
                if (attrs.get("ccOsVersion") == null && ejb.getOsVersion() != null) {
                    addAttrs.put("ccOsVersion", ejb.getOsVersion());
                } else if (attrs.get("ccOsVersion") != null && ejb.getOsVersion() == null) {
                    removeAttrs.put("ccOsVersion", null);
                } else if (attrs.get("ccOsVersion") != null && ejb.getOsVersion() != null) {
                    replaceAttrs.put("ccOsVersion", ejb.getOsVersion());
                }
                if (attrs.get("ccPingWatch") == null && ejb.getPingWatch() != null) {
                    addAttrs.put("ccPingWatch", this.booleanToString(ejb.getPingWatch()));
                } else if (attrs.get("ccPingWatch") != null && ejb.getPingWatch() == null) {
                    removeAttrs.put("ccPingWatch", null);
                } else if (attrs.get("ccPingWatch") != null && ejb.getPingWatch() != null) {
                    replaceAttrs.put("ccPingWatch", this.booleanToString(ejb.getPingWatch()));
                }
                if (attrs.get("ccPingWatchStatus") == null && ejb.getPingWatchStatus() != null) {
                    addAttrs.put("ccPingWatchStatus", this.booleanToString(ejb.getPingWatchStatus()));
                } else if (attrs.get("ccPingWatchStatus") != null && ejb.getPingWatchStatus() == null) {
                    removeAttrs.put("ccPingWatchStatus", null);
                } else if (attrs.get("ccPingWatchStatus") != null && ejb.getPingWatchStatus() != null) {
                    replaceAttrs.put("ccPingWatchStatus", this.booleanToString(ejb.getPingWatchStatus()));
                }
                if (attrs.get("ccPlatform") == null && ejb.getPlatform() != null) {
                    addAttrs.put("ccPlatform", ejb.getPlatform());
                } else if (attrs.get("ccPlatform") != null && ejb.getPlatform() == null) {
                    removeAttrs.put("ccPlatform", null);
                } else if (attrs.get("ccPlatform") != null && ejb.getPlatform() != null) {
                    replaceAttrs.put("ccPlatform", ejb.getPlatform());
                }
                if (attrs.get("ccStatusWatch") == null && ejb.getStatusWatch() != null) {
                    addAttrs.put("ccStatusWatch", this.booleanToString(ejb.getStatusWatch()));
                } else if (attrs.get("ccStatusWatch") != null && ejb.getStatusWatch() == null) {
                    removeAttrs.put("ccStatusWatch", null);
                } else if (attrs.get("ccStatusWatch") != null && ejb.getStatusWatch() != null) {
                    replaceAttrs.put("ccStatusWatch", this.booleanToString(ejb.getStatusWatch()));
                }
            }
            ctx.modifyAttributes(ejb.getDn(), 1, (Attributes)addAttrs);
            ctx.modifyAttributes(ejb.getDn(), 2, (Attributes)replaceAttrs);
            ctx.modifyAttributes(ejb.getDn(), 3, (Attributes)removeAttrs);
        }
        catch (NamingException ex) {
            if (ex instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            throw new EJBException((Exception)ex);
        }
    }

    public void remove(FacilityPK pk) throws RemoveException, EJBException {
        try {
            DirContext ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            ctx.destroySubcontext(pk.getDn());
        }
        catch (NamingException ex) {
            if (ex instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            AplLogger apllog = new AplLogger("REP", "rep");
            Object[] args = new String[]{pk.getDn()};
            apllog.put("SYS", "006", args);
            throw new EJBException((Exception)ex);
        }
    }

    public FacilityPK create(FacilityBean ejb) throws CreateException, EJBException {
        FacilityPK pk = null;
        try {
            DirContext ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            BasicAttributes attrs = new BasicAttributes();
            BasicAttribute attr = new BasicAttribute(OBJECTCLASS);
            if (ejb.getType() == 1) {
                attr.add(0, OBJECT_CLASS_FACILITY);
                attr.add(1, OBJECT_CLASS_NODE);
            } else {
                attr.add(0, OBJECT_CLASS_FACILITY);
                attr.add(1, OBJECT_CLASS_SCOPE);
            }
            attrs.put(attr);
            attrs.put("ccFacilityId", ejb.getFacilityId());
            attrs.put("cn", ejb.getCn());
            StringBuffer dn = new StringBuffer();
            dn.append("ccFacilityId");
            dn.append("=");
            dn.append(ejb.getFacilityId());
            dn.append(",");
            dn.append(BASE_DN);
            ejb.setDn(dn.toString());
            ctx.createSubcontext(ejb.getDn(), (Attributes)attrs);
            pk = new FacilityPK(ejb.getDn());
        }
        catch (NamingException ex) {
            if (ex instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            AplLogger apllog = new AplLogger("REP", "rep");
            Object[] args = new String[]{ejb.getDn()};
            apllog.put("SYS", "005", args);
            throw new EJBException((Exception)ex);
        }
        return pk;
    }

    /*
     * Unable to fully structure code
     */
    public Collection findAll() throws FinderException {
        ret = new ArrayList<FacilityPK>();
        FacilityDAOImpl.m_log.debug((Object)"findAll()");
        ctx = LdapConnectionManager.getConnectionManager().getDirContext();
        constraints = new SearchControls();
        constraints.setSearchScope(2);
        search = new StringBuffer();
        search.append("(&(");
        search.append("objectClass");
        search.append("=");
        search.append("ccFacility");
        search.append("))");
        results = null;
        try {
            results = ctx.search("ou=facility", search.toString(), constraints);
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            FacilityDAOImpl.m_log.debug((Object)("findAll() : " + e.getMessage()));
        }
        if (results != null) ** GOTO lbl32
        FacilityDAOImpl.m_log.debug((Object)"findAll() : No Search Result");
        return ret;
lbl-1000:
        // 1 sources

        {
            aResult = (SearchResult)results.nextElement();
            pk = new FacilityPK(String.valueOf(aResult.getName()) + "," + "ou=facility");
            ret.add(pk);
lbl32:
            // 2 sources

            ** while (results.hasMoreElements())
        }
lbl33:
        // 1 sources

        return ret;
    }

    /*
     * Unable to fully structure code
     */
    public Collection findAllNode() throws FinderException {
        ret = new ArrayList<FacilityPK>();
        FacilityDAOImpl.m_log.debug((Object)"findAllNode()");
        ctx = LdapConnectionManager.getConnectionManager().getDirContext();
        constraints = new SearchControls();
        constraints.setSearchScope(2);
        search = new StringBuffer();
        search.append("(&(");
        search.append("objectClass");
        search.append("=");
        search.append("ccFacility");
        search.append(")(");
        search.append("objectClass");
        search.append("=");
        search.append("ccNode");
        search.append("))");
        results = null;
        try {
            results = ctx.search("ou=facility", search.toString(), constraints);
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            FacilityDAOImpl.m_log.debug((Object)("findAllNode() : " + e.getMessage()));
        }
        if (results != null) ** GOTO lbl40
        FacilityDAOImpl.m_log.debug((Object)"findAllNode() : No Search Result");
        return null;
lbl-1000:
        // 1 sources

        {
            aResult = (SearchResult)results.nextElement();
            pk = new FacilityPK(String.valueOf(aResult.getName()) + "," + "ou=facility");
            ret.add(pk);
lbl40:
            // 2 sources

            ** while (results.hasMoreElements())
        }
lbl41:
        // 1 sources

        return ret;
    }

    public FacilityPK findByPrimaryKey(FacilityPK pk) throws FinderException {
        try {
            m_log.debug((Object)("findByPrimaryKey() : dn = " + pk.getDn()));
            DirContext ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            Attributes attrs = ctx.getAttributes(pk.getDn());
            return pk;
        }
        catch (NamingException ex) {
            if (ex instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            m_log.debug((Object)("findByPrimaryKey() : " + ex.getMessage()));
            throw new FinderException("dn=" + pk.getDn() + " not found.");
        }
    }

    public FacilityPK findByFacilityId(String facilityId) throws FinderException {
        m_log.debug((Object)("findByFacilityId() : FacilityId = " + facilityId));
        DirContext ctx = LdapConnectionManager.getConnectionManager().getDirContext();
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_FACILITY);
        search.append(")(");
        search.append("ccFacilityId");
        search.append("=");
        search.append(facilityId);
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        try {
            results = ctx.search(BASE_DN, search.toString(), constraints);
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            m_log.debug((Object)("findByFacilityId() : " + e.getMessage()));
            throw new FinderException("FacilityId=" + facilityId + " not found.");
        }
        if (results == null) {
            throw new FinderException("FacilityId=" + facilityId + " not found.");
        }
        SearchResult aResult = null;
        Attributes attrs = null;
        if (results.hasMoreElements()) {
            aResult = (SearchResult)results.nextElement();
            attrs = aResult.getAttributes();
        }
        if (attrs == null) {
            throw new FinderException("FacilityId=" + facilityId + " not found.");
        }
        FacilityPK pk = new FacilityPK(String.valueOf(aResult.getName()) + "," + BASE_DN);
        return pk;
    }

    /*
     * Unable to fully structure code
     */
    public Collection findNode(String facilityId, String facilityName, String description, String ipAddress, String osName, String osRelease, String managerName, String managerContact) throws FinderException {
        ret = new ArrayList<FacilityPK>();
        FacilityDAOImpl.m_log.debug((Object)("findNode() : FacilityId = " + facilityId + ", FacilityId = " + facilityId + ", FacilityName = " + facilityName + ", Description = " + description + ", ipAddress = " + ipAddress + ", osName = " + osName + ", osRelease = " + osRelease + ", managerName = " + managerName + ", managerContact = " + managerContact));
        ctx = LdapConnectionManager.getConnectionManager().getDirContext();
        constraints = new SearchControls();
        constraints.setSearchScope(2);
        search = new StringBuffer();
        search.append("(&(");
        search.append("objectClass");
        search.append("=");
        search.append("ccFacility");
        search.append(")(");
        search.append("objectClass");
        search.append("=");
        search.append("ccNode");
        if (facilityId != null && facilityId.compareTo("") != 0) {
            search.append(")(");
            search.append("ccFacilityId");
            search.append("=");
            search.append(facilityId);
        }
        if (facilityName != null && facilityName.compareTo("") != 0) {
            search.append(")(");
            search.append("cn");
            search.append("=");
            search.append(facilityName);
        }
        if (description != null && description.compareTo("") != 0) {
            search.append(")(");
            search.append("description");
            search.append("=");
            search.append(description);
        }
        if (ipAddress != null && ipAddress.compareTo("") != 0) {
            search.append(")(");
            search.append("ipNetworkNumber");
            search.append("=");
            search.append(ipAddress);
        }
        if (osName != null && osName.compareTo("") != 0) {
            search.append(")(");
            search.append("ccOsName");
            search.append("=");
            search.append(osName);
        }
        if (osRelease != null && osRelease.compareTo("") != 0) {
            search.append(")(");
            search.append("ccOsRelease");
            search.append("=");
            search.append(osRelease);
        }
        if (managerName != null && managerName.compareTo("") != 0) {
            search.append(")(");
            search.append("ccManagerName");
            search.append("=");
            search.append(managerName);
        }
        if (managerContact != null && managerContact.compareTo("") != 0) {
            search.append(")(");
            search.append("ccManagerContact");
            search.append("=");
            search.append(managerContact);
        }
        search.append("))");
        results = null;
        try {
            results = ctx.search("ou=facility", search.toString(), constraints);
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            FacilityDAOImpl.m_log.debug((Object)("findNode() : " + e.getMessage()));
        }
        if (results != null) ** GOTO lbl112
        FacilityDAOImpl.m_log.debug((Object)("findNode() : No Search Result : FacilityId = " + facilityId + ", FacilityId = " + facilityId + ", FacilityName = " + facilityName + ", Description = " + description + ", ipAddress = " + ipAddress + ", osName = " + osName + ", osRelease = " + osRelease + ", managerName = " + managerName + ", managerContact = " + managerContact));
        return ret;
lbl-1000:
        // 1 sources

        {
            aResult = (SearchResult)results.nextElement();
            pk = new FacilityPK(String.valueOf(aResult.getName()) + "," + "ou=facility");
            ret.add(pk);
lbl112:
            // 2 sources

            ** while (results.hasMoreElements())
        }
lbl113:
        // 1 sources

        return ret;
    }

    /*
     * Unable to fully structure code
     */
    public Collection findByIpAddress(String ipAddress) throws FinderException {
        ret = new ArrayList<FacilityPK>();
        FacilityDAOImpl.m_log.debug((Object)("findByIpAddress() : ipAddress = " + ipAddress));
        ctx = LdapConnectionManager.getConnectionManager().getDirContext();
        constraints = new SearchControls();
        constraints.setSearchScope(2);
        search = new StringBuffer();
        search.append("(&(");
        search.append("objectClass");
        search.append("=");
        search.append("ccFacility");
        search.append(")(");
        search.append("objectClass");
        search.append("=");
        search.append("ccNode");
        if (ipAddress != null && ipAddress.compareTo("") != 0) {
            search.append(")(");
            search.append("ipNetworkNumber");
            search.append("=");
            search.append(ipAddress);
        }
        search.append("))");
        results = null;
        try {
            results = ctx.search("ou=facility", search.toString(), constraints);
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            FacilityDAOImpl.m_log.debug((Object)("findByIpAddress() : " + e.getMessage()));
        }
        if (results != null) ** GOTO lbl49
        FacilityDAOImpl.m_log.debug((Object)("findByIpAddress() : No Search Result : ipAddress = " + ipAddress));
        return ret;
lbl-1000:
        // 1 sources

        {
            aResult = (SearchResult)results.nextElement();
            pk = new FacilityPK(String.valueOf(aResult.getName()) + "," + "ou=facility");
            ret.add(pk);
lbl49:
            // 2 sources

            ** while (results.hasMoreElements())
        }
lbl50:
        // 1 sources

        return ret;
    }

    /*
     * Unable to fully structure code
     */
    public Collection findByNodeName(String nodeName) throws FinderException {
        ret = new ArrayList<FacilityPK>();
        FacilityDAOImpl.m_log.debug((Object)("findByNodeName() : nodeName = " + nodeName));
        ctx = LdapConnectionManager.getConnectionManager().getDirContext();
        constraints = new SearchControls();
        constraints.setSearchScope(2);
        search = new StringBuffer();
        search.append("(&(");
        search.append("objectClass");
        search.append("=");
        search.append("ccFacility");
        search.append(")(");
        search.append("objectClass");
        search.append("=");
        search.append("ccNode");
        if (nodeName != null && nodeName.compareTo("") != 0) {
            search.append(")(");
            search.append("ccNodeName");
            search.append("=");
            search.append(nodeName);
        }
        search.append("))");
        results = null;
        try {
            results = ctx.search("ou=facility", search.toString(), constraints);
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            FacilityDAOImpl.m_log.debug((Object)("findByNodeName() : " + e.getMessage()));
        }
        if (results != null) ** GOTO lbl49
        FacilityDAOImpl.m_log.debug((Object)("findByNodeName() : No Search Result : nodeName = " + nodeName));
        return ret;
lbl-1000:
        // 1 sources

        {
            aResult = (SearchResult)results.nextElement();
            pk = new FacilityPK(String.valueOf(aResult.getName()) + "," + "ou=facility");
            ret.add(pk);
lbl49:
            // 2 sources

            ** while (results.hasMoreElements())
        }
lbl50:
        // 1 sources

        return ret;
    }

    public Boolean stringToBoolean(String value) {
        Boolean ret = null;
        ret = value.compareTo("TRUE") == 0 ? new Boolean(true) : new Boolean(false);
        return ret;
    }

    public String booleanToString(Boolean value) {
        String ret = null;
        ret = value != false ? "TRUE" : "FALSE";
        return ret;
    }

    public Date stringToDate(String value) {
        Date ret = null;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
        try {
            ret = formatter.parse(value);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return ret;
    }

    public String dateToString(Date value) {
        String ret = null;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss.SSSZ");
        ret = formatter.format(value);
        return ret;
    }

    protected void clearBean(FacilityBean ejb) {
        ejb.setAgentControl(null);
        ejb.setAgentWatch(null);
        ejb.setAgentWatchStatus(null);
        ejb.setCharSet(null);
        ejb.setCn(null);
        ejb.setCreateTimestamp(null);
        ejb.setCreatorsName(null);
        ejb.setDescription(null);
        ejb.setDhcpClient(null);
        ejb.setDn(null);
        ejb.setFacilityId(null);
        ejb.setHost(null);
        ejb.setIpNetworkNumber(null);
        ejb.setIpNetworkNumberV6(null);
        ejb.setIpProtocolNumber(null);
        ejb.setIpType(null);
        ejb.setLogWatch(null);
        ejb.setMachine(null);
        ejb.setManagerContact(null);
        ejb.setManagerName(null);
        ejb.setModifiersName(null);
        ejb.setModifyTimestamp(null);
        ejb.setNodeName(null);
        ejb.setOsName(null);
        ejb.setOsRelease(null);
        ejb.setOsVersion(null);
        ejb.setPingWatch(null);
        ejb.setPingWatchStatus(null);
        ejb.setPlatform(null);
        ejb.setStatusWatch(null);
    }
}

