/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.ejb.entity;

import com.clustercontrol.repository.ejb.entity.FacilityTreeHome;
import com.clustercontrol.repository.ejb.entity.FacilityTreeLocalHome;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.Remote;
import java.security.SecureRandom;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class FacilityTreeUtil {
    private static FacilityTreeHome cachedRemoteHome = null;
    private static FacilityTreeLocalHome cachedLocalHome = null;
    private static String hexServerIP = null;
    private static final SecureRandom seeder = new SecureRandom();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private static Object lookupHome(Hashtable environment, String jndiName, Class narrowTo) throws NamingException {
        InitialContext initialContext = new InitialContext(environment);
        try {
            Object objRef = initialContext.lookup(jndiName);
            if (Remote.class.isAssignableFrom(narrowTo)) {
                Object object = PortableRemoteObject.narrow((Object)objRef, (Class)narrowTo);
                return object;
            }
            Object object = objRef;
            return object;
        }
        finally {
            initialContext.close();
        }
    }

    public static FacilityTreeHome getHome() throws NamingException {
        if (cachedRemoteHome == null) {
            cachedRemoteHome = (FacilityTreeHome)FacilityTreeUtil.lookupHome(null, "FacilityTree", FacilityTreeHome.class);
        }
        return cachedRemoteHome;
    }

    public static FacilityTreeHome getHome(Hashtable environment) throws NamingException {
        return (FacilityTreeHome)FacilityTreeUtil.lookupHome(environment, "FacilityTree", FacilityTreeHome.class);
    }

    public static FacilityTreeLocalHome getLocalHome() throws NamingException {
        if (cachedLocalHome == null) {
            cachedLocalHome = (FacilityTreeLocalHome)FacilityTreeUtil.lookupHome(null, "FacilityTreeLocal", FacilityTreeLocalHome.class);
        }
        return cachedLocalHome;
    }

    public static final String generateGUID(Object o) {
        StringBuffer tmpBuffer = new StringBuffer(16);
        if (hexServerIP == null) {
            InetAddress localInetAddress = null;
            try {
                localInetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException uhe) {
                System.err.println("FacilityTreeUtil: Could not get the local IP address using InetAddress.getLocalHost()!");
                uhe.printStackTrace();
                return null;
            }
            byte[] serverIP = localInetAddress.getAddress();
            hexServerIP = FacilityTreeUtil.hexFormat(FacilityTreeUtil.getInt(serverIP), 8);
        }
        String hashcode = FacilityTreeUtil.hexFormat(System.identityHashCode(o), 8);
        tmpBuffer.append(hexServerIP);
        tmpBuffer.append(hashcode);
        long timeNow = System.currentTimeMillis();
        int timeLow = (int)timeNow & 0xFFFFFFFF;
        int node = seeder.nextInt();
        StringBuffer guid = new StringBuffer(32);
        guid.append(FacilityTreeUtil.hexFormat(timeLow, 8));
        guid.append(tmpBuffer.toString());
        guid.append(FacilityTreeUtil.hexFormat(node, 8));
        return guid.toString();
    }

    private static int getInt(byte[] bytes) {
        int i = 0;
        int j = 24;
        int k = 0;
        while (j >= 0) {
            int l = bytes[k] & 0xFF;
            i += l << j;
            j -= 8;
            ++k;
        }
        return i;
    }

    private static String hexFormat(int i, int j) {
        String s = Integer.toHexString(i);
        return String.valueOf(FacilityTreeUtil.padHex(s, j)) + s;
    }

    private static String padHex(String s, int i) {
        StringBuffer tmpBuffer = new StringBuffer();
        if (s.length() < i) {
            int j = 0;
            while (j < i - s.length()) {
                tmpBuffer.append('0');
                ++j;
            }
        }
        return tmpBuffer.toString();
    }
}

