/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.ejb.session;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.repository.factory.DeleteFacility;
import com.clustercontrol.repository.factory.ModifyFacility;
import com.clustercontrol.repository.factory.NodeFilterProperty;
import com.clustercontrol.repository.factory.NodeProperty;
import com.clustercontrol.repository.factory.ScopeProperty;
import com.clustercontrol.repository.factory.SelectFacility;
import com.clustercontrol.util.Messages;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class RepositoryControllerBean
implements SessionBean {
    protected static Log m_log = LogFactory.getLog(RepositoryControllerBean.class);
    private SessionContext m_context;
    public static final int ALL = 0;
    public static final int ONE_LEVEL = 1;
    static /* synthetic */ Class class$0;

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.m_context = ctx;
    }

    public FacilityTreeItem getFacilityTree(Locale locale) throws FinderException, NamingException {
        SelectFacility select = new SelectFacility();
        FacilityTreeItem item = select.getFacilityTree(locale);
        return item;
    }

    public FacilityTreeItem getScopeFacilityTree(Locale locale) throws FinderException, NamingException {
        SelectFacility select = new SelectFacility();
        FacilityTreeItem item = select.getScopeFacilityTree(locale);
        return item;
    }

    public ArrayList getNodeListTableDefine(Locale local) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"facility.id", (Locale)local), 12, 100, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"facility.name", (Locale)local), 13, 150, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"description", (Locale)local), -1, 200, 16384));
        return tableDefine;
    }

    public ArrayList getNodeScopeTableDefine(Locale local) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"scope", (Locale)local), -1, 300, 16384));
        return tableDefine;
    }

    public ArrayList getNodeScopeList(String facilityId) throws FinderException, NamingException {
        SelectFacility select = new SelectFacility();
        ArrayList list = select.getNodeScopeList(facilityId);
        return list;
    }

    public ArrayList getScopeListTableDefine(Locale local) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"facility.id", (Locale)local), 12, 100, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"facility.name", (Locale)local), 13, 150, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"description", (Locale)local), -1, 200, 16384));
        return tableDefine;
    }

    public ArrayList getScopeList(String parentFacilityId) throws FinderException, NamingException {
        SelectFacility select = new SelectFacility();
        ArrayList list = select.getScopeList(parentFacilityId);
        return list;
    }

    public ArrayList getNodeList() throws FinderException, NamingException {
        SelectFacility select = new SelectFacility();
        ArrayList list = select.getNodeList();
        return list;
    }

    public ArrayList getNodeList(String parentFacilityId, int level) throws FinderException, NamingException {
        SelectFacility select = new SelectFacility();
        ArrayList list = select.getNodeList(parentFacilityId, level);
        return list;
    }

    public ArrayList getNodeList(Property property) throws FinderException, NamingException {
        SelectFacility select = new SelectFacility();
        ArrayList list = select.getNodeList(property);
        return list;
    }

    public ArrayList getFacilityIdList(String parentFacilityId, int level) throws FinderException, NamingException {
        SelectFacility select = new SelectFacility();
        ArrayList list = select.getFacilityIdList(parentFacilityId, level);
        return list;
    }

    public ArrayList getNodeFacilityIdList(String parentFacilityId, int level) throws FinderException, NamingException {
        SelectFacility select = new SelectFacility();
        ArrayList list = select.getNodeFacilityIdList(parentFacilityId, level);
        return list;
    }

    public ArrayList getNodeFacilityIdList() throws FinderException, NamingException {
        SelectFacility select = new SelectFacility();
        ArrayList list = select.getNodeFacilityIdList();
        return list;
    }

    public ArrayList getDeviceList(String facilityId) throws FinderException, NamingException {
        SelectFacility select = new SelectFacility();
        ArrayList list = select.getDeviceList(facilityId);
        return list;
    }

    public HashMap getNodeDetail(String facilityId, ArrayList attributes) throws FinderException, NamingException {
        SelectFacility select = new SelectFacility();
        HashMap map = select.getNodeDetail(facilityId, attributes);
        return map;
    }

    public HashMap getNodeDetail(ArrayList facilityIdList, ArrayList attributes) throws FinderException, NamingException {
        SelectFacility select = new SelectFacility();
        HashMap map = select.getNodeDetail(facilityIdList, attributes);
        return map;
    }

    public void setNodeDetail(String facilityId, HashMap attributes) throws FinderException, NamingException {
        ModifyFacility modify = new ModifyFacility();
        modify.setNodeDetail(facilityId, attributes);
    }

    public void addScope(String parentFacilityId, Property property) throws RemoveException, CreateException, NamingException {
        ModifyFacility modify = new ModifyFacility();
        modify.addScope(parentFacilityId, property);
    }

    public void modifyScope(Property property) throws NamingException, FinderException {
        ModifyFacility modify = new ModifyFacility();
        modify.modifyScope(property);
    }

    public void addNode(Property property) throws NamingException, CreateException {
        Principal pri = this.m_context.getCallerPrincipal();
        ModifyFacility modify = new ModifyFacility();
        modify.addNode(property, pri.getName());
    }

    public void modifyNode(Property property) throws NamingException, FinderException, CreateException {
        Principal pri = this.m_context.getCallerPrincipal();
        ModifyFacility modify = new ModifyFacility();
        modify.modifyNode(property, pri.getName());
    }

    public void modifyNode(Property property, String parentFacilityId) throws NamingException, FinderException {
        Principal pri = this.m_context.getCallerPrincipal();
        ModifyFacility modify = new ModifyFacility();
        modify.modifyAllNode(property, parentFacilityId, pri.getName());
    }

    public void deleteNode(String facilityId) throws FinderException, RemoveException, NamingException {
        DeleteFacility delete = new DeleteFacility();
        delete.deleteNode(facilityId);
    }

    public void deleteScope(String facilityId) throws FinderException, NamingException, RemoveException {
        DeleteFacility delete = new DeleteFacility();
        delete.deleteScope(facilityId);
    }

    public void assignNodeScope(String parentFacilityId, String[] facilityIds) throws NamingException, CreateException {
        ModifyFacility modify = new ModifyFacility();
        modify.assignNodeScope(parentFacilityId, facilityIds);
    }

    public void releaseNodeScope(String parentFacilityId, String[] facilityIds) throws FinderException, NamingException, RemoveException {
        DeleteFacility delete = new DeleteFacility();
        delete.releaseNodeScope(parentFacilityId, facilityIds);
    }

    public Property getScopeProperty(String facilityId, int mode, Locale local) throws FinderException, NamingException {
        ScopeProperty scope = new ScopeProperty();
        return scope.getProperty(facilityId, mode, local);
    }

    public Property getNodeProperty(String facilityId, int mode, Locale local) throws FinderException, NamingException {
        NodeProperty node = new NodeProperty();
        return node.getProperty(facilityId, mode, local);
    }

    public Property getNodeFilterProperty(Locale local) {
        NodeFilterProperty node = new NodeFilterProperty();
        return node.getProperty(local);
    }

    public String getFacilityPath(String facilityId, String parentFacilityId) throws FinderException, NamingException {
        SelectFacility select = new SelectFacility();
        return select.getFacilityPath(facilityId, parentFacilityId);
    }

    public ArrayList getFacilityIdList(String hostName, String ipAddress) throws FinderException, NamingException {
        SelectFacility select = new SelectFacility();
        return select.getFacilityIdList(hostName, ipAddress);
    }

    public boolean isNode(String facilityId) throws FinderException, NamingException {
        SelectFacility select = new SelectFacility();
        return select.isNode(facilityId);
    }

    public String getSeparator() {
        return ">";
    }
}

