/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.util;

import com.clustercontrol.util.apllog.AplLogger;
import java.util.Date;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.InitialLdapContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapConnectionManager {
    protected static Log m_log = LogFactory.getLog(LdapConnectionManager.class);
    private static final int RECONNECT_INTERVAL = 60000;
    private static LdapConnectionManager m_instance = null;
    private DirContext m_ctx;
    private Date m_connectTime = null;
    static /* synthetic */ Class class$0;

    public static LdapConnectionManager getConnectionManager() {
        if (m_instance == null) {
            m_instance = new LdapConnectionManager();
        }
        return m_instance;
    }

    private LdapConnectionManager() {
    }

    public synchronized DirContext getDirContext() {
        long span = 0L;
        if (this.m_connectTime != null) {
            span = new Date().getTime() - this.m_connectTime.getTime();
        }
        if (this.m_ctx == null || span >= 60000L) {
            try {
                InitialContext iniCtx = new InitialContext();
                this.m_ctx = (InitialLdapContext)iniCtx.lookup("external/hinemos/ldap/provider");
            }
            catch (NamingException e) {
                m_log.debug((Object)("LdapConnectionManager() : LDAP Connection Error : " + e.getMessage()));
                try {
                    InitialContext iniCtx = new InitialContext();
                    this.m_ctx = (InitialLdapContext)iniCtx.lookup("external/hinemos/ldap/consumer");
                }
                catch (NamingException e1) {
                    m_log.debug((Object)("LdapConnectionManager() : LDAP Connection Error : " + e1.getMessage()));
                }
            }
            this.m_connectTime = new Date();
        }
        if (this.m_ctx == null) {
            AplLogger apllog = new AplLogger("REP", "rep");
            apllog.put("SYS", "001");
        }
        return this.m_ctx;
    }

    public synchronized void setDirContext(DirContext ctx) {
        try {
            if (this.m_ctx != null) {
                this.m_ctx.close();
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        this.m_ctx = ctx;
    }
}

