/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.ConstantPool;
import com.sun.java.util.jar.pack.Constants;
import com.sun.java.util.jar.pack.Fixups;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class Attribute
implements Comparable,
Constants {
    Layout def;
    byte[] bytes;
    Object fixups;
    private static final byte[] noBytes = new byte[0];
    private static final HashMap canonLists = new HashMap();
    private static final HashMap attributes = new HashMap();
    private static final HashMap standardDefs = new HashMap();
    static final byte EK_INT = 1;
    static final byte EK_BCI = 2;
    static final byte EK_BCO = 3;
    static final byte EK_FLAG = 4;
    static final byte EK_REPL = 5;
    static final byte EK_REF = 6;
    static final byte EK_UN = 7;
    static final byte EK_CASE = 8;
    static final byte EK_CALL = 9;
    static final byte EK_CBLE = 10;
    static final byte EF_SIGN = 1;
    static final byte EF_DELTA = 2;
    static final byte EF_NULL = 4;
    static final byte EF_BACK = 8;
    static final int NO_BAND_INDEX = -1;

    public String name() {
        return this.def.name();
    }

    public Layout layout() {
        return this.def;
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public int size() {
        return this.bytes.length;
    }

    public ConstantPool.Entry getNameRef() {
        return this.def.getNameRef();
    }

    private Attribute(Attribute attribute) {
        this.def = attribute.def;
        this.bytes = attribute.bytes;
        this.fixups = attribute.fixups;
    }

    public Attribute(Layout layout, byte[] byArray, Object object) {
        this.def = layout;
        this.bytes = byArray;
        this.fixups = object;
        Fixups.setBytes(object, byArray);
    }

    public Attribute(Layout layout, byte[] byArray) {
        this(layout, byArray, null);
    }

    public Attribute addContent(byte[] byArray, Object object) {
        assert (this.isCanonical());
        if (byArray.length == 0 && object == null) {
            return this;
        }
        Attribute attribute = new Attribute(this);
        attribute.bytes = byArray;
        attribute.fixups = object;
        Fixups.setBytes(object, byArray);
        return attribute;
    }

    public Attribute addContent(byte[] byArray) {
        return this.addContent(byArray, null);
    }

    public void finishRefs(ConstantPool.Index index) {
        if (this.fixups != null) {
            Fixups.finishRefs(this.fixups, this.bytes, index);
            this.fixups = null;
        }
    }

    public boolean isCanonical() {
        return this == this.def.canon;
    }

    public int compareTo(Object object) {
        Attribute attribute = (Attribute)object;
        return this.def.compareTo(attribute.def);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getCanonList(List list) {
        HashMap hashMap = canonLists;
        synchronized (hashMap) {
            List list2 = (ArrayList)canonLists.get(list);
            if (list2 == null) {
                list2 = new ArrayList(list.size());
                list2.addAll(list);
                list2 = Collections.unmodifiableList(list2);
                canonLists.put(list, list2);
            }
            return list2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Attribute find(int n2, String string, String string2) {
        Layout layout = Layout.makeKey(n2, string, string2);
        HashMap hashMap = attributes;
        synchronized (hashMap) {
            Attribute attribute = (Attribute)attributes.get(layout);
            if (attribute == null) {
                attribute = new Layout(n2, string, string2).canonicalInstance();
                attributes.put(layout, attribute);
            }
            return attribute;
        }
    }

    public static Object keyForLookup(int n2, String string) {
        return Layout.makeKey(n2, string);
    }

    public static Attribute lookup(Map map, int n2, String string) {
        if (map == null) {
            map = standardDefs;
        }
        return (Attribute)map.get(Layout.makeKey(n2, string));
    }

    public static Attribute define(Map map, int n2, String string, String string2) {
        Attribute attribute = Attribute.find(n2, string, string2);
        map.put(Layout.makeKey(n2, string), attribute);
        return attribute;
    }

    public static String contextName(int n2) {
        switch (n2) {
            case 0: {
                return "class";
            }
            case 1: {
                return "field";
            }
            case 2: {
                return "method";
            }
            case 3: {
                return "code";
            }
        }
        return null;
    }

    public static Map getStandardDefs() {
        return new HashMap(standardDefs);
    }

    void visitRefs(Holder holder, int n2, final Collection collection) {
        if (n2 == 0) {
            collection.add(this.getNameRef());
        }
        if (this.bytes.length == 0) {
            return;
        }
        if (!this.def.hasRefs) {
            return;
        }
        if (this.fixups != null) {
            Fixups.visitRefs(this.fixups, collection);
            return;
        }
        this.def.parse(holder, this.bytes, 0, this.bytes.length, new ValueStream(){

            public void putInt(int n2, int n3) {
            }

            public void putRef(int n2, ConstantPool.Entry entry) {
                collection.add(entry);
            }

            public int encodeBCI(int n2) {
                return n2;
            }
        });
    }

    public void parse(Holder holder, byte[] byArray, int n2, int n3, ValueStream valueStream) {
        this.def.parse(holder, byArray, n2, n3, valueStream);
    }

    public Object unparse(ValueStream valueStream, ByteArrayOutputStream byteArrayOutputStream) {
        return this.def.unparse(valueStream, byteArrayOutputStream);
    }

    public String toString() {
        return this.def + "{" + (this.bytes == null ? -1 : this.size()) + "}" + (this.fixups == null ? "" : this.fixups.toString());
    }

    public static String normalizeLayoutString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            int n4;
            int n5;
            char c2;
            if ((c2 = string.charAt(n2++)) <= ' ') continue;
            if (c2 == '#') {
                n5 = string.indexOf(10, n2);
                n4 = string.indexOf(13, n2);
                if (n5 < 0) {
                    n5 = n3;
                }
                if (n4 < 0) {
                    n4 = n3;
                }
                n2 = Math.min(n5, n4);
                continue;
            }
            if (c2 == '\\') {
                stringBuffer.append((int)string.charAt(n2++));
                continue;
            }
            if (c2 == '0' && string.startsWith("0x", n2 - 1)) {
                char c3;
                n5 = n2 - 1;
                for (n4 = n5 + 2; n4 < n3 && ((c3 = string.charAt(n4)) >= '0' && c3 <= '9' || c3 >= 'a' && c3 <= 'f'); ++n4) {
                }
                if (n4 > n5) {
                    String string2 = string.substring(n5, n4);
                    stringBuffer.append(Integer.decode(string2));
                    n2 = n4;
                    continue;
                }
                stringBuffer.append(c2);
                continue;
            }
            stringBuffer.append(c2);
        }
        String string3 = stringBuffer.toString();
        return string3;
    }

    static Layout.Element[] tokenizeLayout(Layout layout, int n2, String string) {
        ArrayList arrayList = new ArrayList(string.length());
        Attribute.tokenizeLayout(layout, n2, string, arrayList);
        Layout.Element[] elementArray = new Layout.Element[arrayList.size()];
        arrayList.toArray(elementArray);
        return elementArray;
    }

    static void tokenizeLayout(Layout layout, int n2, String string, ArrayList arrayList) {
        boolean bl2 = false;
        int n3 = string.length();
        int n4 = 0;
        block30: while (n4 < n3) {
            int n5;
            int n6 = n4;
            Layout.Element element = layout.new Layout.Element();
            block0 : switch (string.charAt(n4++)) {
                case 'B': 
                case 'H': 
                case 'I': 
                case 'V': {
                    n5 = 1;
                    --n4;
                    n4 = Attribute.tokenizeUInt(element, string, n4);
                    break;
                }
                case 'S': {
                    n5 = 1;
                    --n4;
                    n4 = Attribute.tokenizeSInt(element, string, n4);
                    break;
                }
                case 'P': {
                    n5 = 2;
                    if (string.charAt(n4++) == 'O') {
                        element.flags = (byte)(element.flags | 2);
                        if (!bl2) {
                            n4 = -n4;
                            continue block30;
                        }
                        ++n4;
                    }
                    --n4;
                    n4 = Attribute.tokenizeUInt(element, string, n4);
                    break;
                }
                case 'O': {
                    n5 = 3;
                    element.flags = (byte)(element.flags | 2);
                    if (!bl2) {
                        n4 = -n4;
                        continue block30;
                    }
                    n4 = Attribute.tokenizeSInt(element, string, n4);
                    break;
                }
                case 'F': {
                    n5 = 4;
                    n4 = Attribute.tokenizeUInt(element, string, n4);
                    break;
                }
                case 'N': {
                    n5 = 5;
                    n4 = Attribute.tokenizeUInt(element, string, n4);
                    if (string.charAt(n4++) != '[') {
                        n4 = -n4;
                        continue block30;
                    }
                    int n7 = n4;
                    n4 = Attribute.skipBody(string, n7);
                    element.body = Attribute.tokenizeLayout(layout, n2, string.substring(n7, n4++));
                    break;
                }
                case 'T': {
                    Layout.Element[] elementArray;
                    int n8;
                    Object object;
                    int n9;
                    int n7;
                    n5 = 7;
                    n4 = Attribute.tokenizeSInt(element, string, n4);
                    ArrayList<Layout.Element> arrayList2 = new ArrayList<Layout.Element>();
                    block31: while (true) {
                        if (string.charAt(n4++) != '(') {
                            n4 = -n4;
                            break;
                        }
                        n9 = n4;
                        n4 = string.indexOf(41, n4);
                        object = string.substring(n9, n4++);
                        n8 = ((String)object).length();
                        if (string.charAt(n4++) != '[') {
                            n4 = -n4;
                            break;
                        }
                        if (string.charAt(n4) == ']') {
                            n7 = n4;
                        } else {
                            n7 = n4;
                            n4 = Attribute.skipBody(string, n7);
                        }
                        elementArray = Attribute.tokenizeLayout(layout, n2, string.substring(n7, n4++));
                        if (n8 == 0) {
                            Layout.Element element2 = layout.new Layout.Element();
                            element2.body = elementArray;
                            element2.kind = (byte)8;
                            element2.removeBand();
                            arrayList2.add(element2);
                            break;
                        }
                        int n10 = 0;
                        while (true) {
                            String string2;
                            int n11;
                            if ((n11 = ((String)object).indexOf(44, n10)) < 0) {
                                n11 = n8;
                            }
                            Layout.Element element3 = layout.new Layout.Element();
                            element3.body = elementArray;
                            element3.kind = (byte)8;
                            element3.removeBand();
                            if (n10 > 0) {
                                element3.flags = (byte)(element3.flags | 8);
                            }
                            if ((string2 = ((String)object).substring(n10, n11)).length() == 0) {
                                string2 = "empty";
                            }
                            element3.value = Integer.parseInt(string2);
                            arrayList2.add(element3);
                            if (n11 == n8) continue block31;
                            n10 = n11 + 1;
                        }
                        break;
                    }
                    element.body = new Layout.Element[arrayList2.size()];
                    arrayList2.toArray(element.body);
                    element.kind = (byte)n5;
                    for (n9 = 0; n9 < element.body.length - 1; ++n9) {
                        object = element.body[n9];
                        if (Attribute.matchCase(element, ((Layout.Element)object).value) == object) continue;
                        n4 = -n4;
                        break block0;
                    }
                    break;
                }
                case '(': {
                    n5 = 9;
                    element.removeBand();
                    n4 = string.indexOf(41, n4);
                    String string3 = string.substring(n6 + 1, n4++);
                    int n12 = Integer.parseInt(string3);
                    int n8 = n2 + n12;
                    if (!(n12 + "").equals(string3) || layout.elems == null || n8 < 0 || n8 >= layout.elems.length) {
                        n4 = -n4;
                        continue block30;
                    }
                    Layout.Element[] elementArray = layout.elems[n8];
                    assert (elementArray.kind == 10);
                    element.value = n8;
                    element.body = new Layout.Element[]{elementArray};
                    if (n12 > 0) break;
                    element.flags = (byte)(element.flags | 8);
                    elementArray.flags = (byte)(elementArray.flags | 8);
                    break;
                }
                case 'K': {
                    n5 = 6;
                    switch (string.charAt(n4++)) {
                        case 'I': {
                            element.refKind = (byte)3;
                            break block0;
                        }
                        case 'J': {
                            element.refKind = (byte)5;
                            break block0;
                        }
                        case 'F': {
                            element.refKind = (byte)4;
                            break block0;
                        }
                        case 'D': {
                            element.refKind = (byte)6;
                            break block0;
                        }
                        case 'S': {
                            element.refKind = (byte)8;
                            break block0;
                        }
                        case 'Q': {
                            element.refKind = (byte)20;
                            break block0;
                        }
                    }
                    n4 = -n4;
                    continue block30;
                }
                case 'R': {
                    n5 = 6;
                    switch (string.charAt(n4++)) {
                        case 'C': {
                            element.refKind = (byte)7;
                            break block0;
                        }
                        case 'S': {
                            element.refKind = (byte)13;
                            break block0;
                        }
                        case 'D': {
                            element.refKind = (byte)12;
                            break block0;
                        }
                        case 'F': {
                            element.refKind = (byte)9;
                            break block0;
                        }
                        case 'M': {
                            element.refKind = (byte)10;
                            break block0;
                        }
                        case 'I': {
                            element.refKind = (byte)11;
                            break block0;
                        }
                        case 'U': {
                            element.refKind = 1;
                            break block0;
                        }
                        case 'Q': {
                            element.refKind = (byte)19;
                            break block0;
                        }
                    }
                    n4 = -n4;
                    continue block30;
                }
                default: {
                    n4 = -n4;
                    continue block30;
                }
            }
            if (n5 == 6) {
                if (string.charAt(n4++) == 'N') {
                    element.flags = (byte)(element.flags | 4);
                    ++n4;
                }
                --n4;
                n4 = Attribute.tokenizeUInt(element, string, n4);
                layout.hasRefs = true;
            }
            bl2 = n5 == 2;
            element.kind = (byte)n5;
            element.layout = string.substring(n6, n4);
            arrayList.add(element);
        }
    }

    static String[] splitBodies(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2++) != '[') {
                string.charAt(-i2);
            }
            int n2 = i2;
            i2 = Attribute.skipBody(string, n2);
            arrayList.add(string.substring(n2, i2));
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private static int skipBody(String string, int n2) {
        assert (string.charAt(n2 - 1) == '[');
        if (string.charAt(n2) == ']') {
            return -n2;
        }
        int n3 = 1;
        while (n3 > 0) {
            switch (string.charAt(n2++)) {
                case '[': {
                    ++n3;
                    break;
                }
                case ']': {
                    --n3;
                }
            }
        }
        assert (string.charAt(--n2) == ']');
        return n2;
    }

    private static int tokenizeUInt(Layout.Element element, String string, int n2) {
        switch (string.charAt(n2++)) {
            case 'V': {
                element.len = 0;
                break;
            }
            case 'B': {
                element.len = 1;
                break;
            }
            case 'H': {
                element.len = (byte)2;
                break;
            }
            case 'I': {
                element.len = (byte)4;
                break;
            }
            default: {
                return -n2;
            }
        }
        return n2;
    }

    private static int tokenizeSInt(Layout.Element element, String string, int n2) {
        if (string.charAt(n2) == 'S') {
            element.flags = (byte)(element.flags | 1);
            ++n2;
        }
        return Attribute.tokenizeUInt(element, string, n2);
    }

    static int parseUsing(Layout.Element[] elementArray, Holder holder, byte[] byArray, int n2, int n3, ValueStream valueStream) {
        int n4 = 0;
        int n5 = 0;
        int n6 = n2 + n3;
        int[] nArray = new int[]{0};
        block10: for (int i2 = 0; i2 < elementArray.length; ++i2) {
            Layout.Element element = elementArray[i2];
            int n7 = element.bandIndex;
            switch (element.kind) {
                case 1: {
                    n2 = Attribute.parseInt(element, byArray, n2, nArray);
                    int n8 = nArray[0];
                    valueStream.putInt(n7, n8);
                    continue block10;
                }
                case 2: {
                    n2 = Attribute.parseInt(element, byArray, n2, nArray);
                    int n9 = nArray[0];
                    int n10 = valueStream.encodeBCI(n9);
                    int n8 = !element.flagTest((byte)2) ? n10 : n10 - n5;
                    n4 = n9;
                    n5 = n10;
                    valueStream.putInt(n7, n8);
                    continue block10;
                }
                case 3: {
                    assert (element.flagTest((byte)2));
                    n2 = Attribute.parseInt(element, byArray, n2, nArray);
                    int n9 = n4 + nArray[0];
                    int n10 = valueStream.encodeBCI(n9);
                    int n8 = n10 - n5;
                    n4 = n9;
                    n5 = n10;
                    valueStream.putInt(n7, n8);
                    continue block10;
                }
                case 4: {
                    n2 = Attribute.parseInt(element, byArray, n2, nArray);
                    int n8 = nArray[0];
                    valueStream.putInt(n7, n8);
                    continue block10;
                }
                case 5: {
                    n2 = Attribute.parseInt(element, byArray, n2, nArray);
                    int n8 = nArray[0];
                    valueStream.putInt(n7, n8);
                    for (int i3 = 0; i3 < n8; ++i3) {
                        n2 = Attribute.parseUsing(element.body, holder, byArray, n2, n6 - n2, valueStream);
                    }
                    continue block10;
                }
                case 7: {
                    n2 = Attribute.parseInt(element, byArray, n2, nArray);
                    int n8 = nArray[0];
                    valueStream.putInt(n7, n8);
                    Layout.Element element2 = Attribute.matchCase(element, n8);
                    n2 = Attribute.parseUsing(element2.body, holder, byArray, n2, n6 - n2, valueStream);
                    continue block10;
                }
                case 9: {
                    assert (element.body.length == 1);
                    assert (element.body[0].kind == 10);
                    if (element.flagTest((byte)8)) {
                        valueStream.noteBackCall(element.value);
                    }
                    n2 = Attribute.parseUsing(element.body[0].body, holder, byArray, n2, n6 - n2, valueStream);
                    continue block10;
                }
                case 6: {
                    ConstantPool.Entry entry;
                    n2 = Attribute.parseInt(element, byArray, n2, nArray);
                    int n11 = nArray[0];
                    if (n11 == 0) {
                        entry = null;
                    } else {
                        entry = holder.getCPMap()[n11];
                        if (element.refKind == 13 && entry.getTag() == 1) {
                            String string = entry.stringValue();
                            entry = ConstantPool.getSignatureEntry(string);
                        } else if (element.refKind == 20) {
                            assert (entry.getTag() >= 3);
                            assert (entry.getTag() <= 8);
                        } else if (element.refKind != 19) assert (element.refKind == entry.getTag());
                    }
                    valueStream.putRef(n7, entry);
                    continue block10;
                }
                default: {
                    assert (false);
                    continue block10;
                }
            }
        }
        return n2;
    }

    static Layout.Element matchCase(Layout.Element element, int n2) {
        assert (element.kind == 7);
        int n3 = element.body.length - 1;
        for (int i2 = 0; i2 < n3; ++i2) {
            Layout.Element element2 = element.body[i2];
            assert (element2.kind == 8);
            if (n2 != element2.value) continue;
            return element2;
        }
        return element.body[n3];
    }

    private static int parseInt(Layout.Element element, byte[] byArray, int n2, int[] nArray) {
        int n3;
        int n4 = 0;
        int n5 = n3 = element.len * 8;
        while ((n5 -= 8) >= 0) {
            n4 += (byArray[n2++] & 0xFF) << n5;
        }
        if (n3 < 32 && element.flagTest((byte)1)) {
            n5 = 32 - n3;
            n4 = n4 << n5 >> n5;
        }
        nArray[0] = n4;
        return n2;
    }

    static void unparseUsing(Layout.Element[] elementArray, Object[] objectArray, ValueStream valueStream, ByteArrayOutputStream byteArrayOutputStream) {
        int n2 = 0;
        int n3 = 0;
        block10: for (int i2 = 0; i2 < elementArray.length; ++i2) {
            Layout.Element element = elementArray[i2];
            int n4 = element.bandIndex;
            switch (element.kind) {
                case 1: {
                    int n5 = valueStream.getInt(n4);
                    Attribute.unparseInt(element, n5, byteArrayOutputStream);
                    continue block10;
                }
                case 2: {
                    int n5 = valueStream.getInt(n4);
                    int n6 = !element.flagTest((byte)2) ? n5 : n3 + n5;
                    assert (n2 == valueStream.decodeBCI(n3));
                    int n7 = valueStream.decodeBCI(n6);
                    Attribute.unparseInt(element, n7, byteArrayOutputStream);
                    n2 = n7;
                    n3 = n6;
                    continue block10;
                }
                case 3: {
                    int n5 = valueStream.getInt(n4);
                    assert (element.flagTest((byte)2));
                    assert (n2 == valueStream.decodeBCI(n3));
                    int n6 = n3 + n5;
                    int n7 = valueStream.decodeBCI(n6);
                    Attribute.unparseInt(element, n7 - n2, byteArrayOutputStream);
                    n2 = n7;
                    n3 = n6;
                    continue block10;
                }
                case 4: {
                    int n5 = valueStream.getInt(n4);
                    Attribute.unparseInt(element, n5, byteArrayOutputStream);
                    continue block10;
                }
                case 5: {
                    int n5 = valueStream.getInt(n4);
                    Attribute.unparseInt(element, n5, byteArrayOutputStream);
                    for (int i3 = 0; i3 < n5; ++i3) {
                        Attribute.unparseUsing(element.body, objectArray, valueStream, byteArrayOutputStream);
                    }
                    continue block10;
                }
                case 7: {
                    int n5 = valueStream.getInt(n4);
                    Attribute.unparseInt(element, n5, byteArrayOutputStream);
                    Layout.Element element2 = Attribute.matchCase(element, n5);
                    Attribute.unparseUsing(element2.body, objectArray, valueStream, byteArrayOutputStream);
                    continue block10;
                }
                case 9: {
                    assert (element.body.length == 1);
                    assert (element.body[0].kind == 10);
                    Attribute.unparseUsing(element.body[0].body, objectArray, valueStream, byteArrayOutputStream);
                    continue block10;
                }
                case 6: {
                    int n8;
                    ConstantPool.Entry entry = valueStream.getRef(n4);
                    if (entry != null) {
                        objectArray[0] = Fixups.add(objectArray[0], null, byteArrayOutputStream.size(), 0, entry);
                        n8 = 0;
                    } else {
                        n8 = 0;
                    }
                    Attribute.unparseInt(element, n8, byteArrayOutputStream);
                    continue block10;
                }
                default: {
                    assert (false);
                    continue block10;
                }
            }
        }
    }

    private static void unparseInt(Layout.Element element, int n2, ByteArrayOutputStream byteArrayOutputStream) {
        int n3;
        int n4 = element.len * 8;
        if (n4 == 0) {
            return;
        }
        if (n4 < 32) {
            n3 = 32 - n4;
            int n5 = element.flagTest((byte)1) ? n2 << n3 >> n3 : n2 << n3 >>> n3;
            if (n5 != n2) {
                throw new InternalError("cannot code in " + element.len + " bytes: " + n2);
            }
        }
        n3 = n4;
        while ((n3 -= 8) >= 0) {
            byteArrayOutputStream.write((byte)(n2 >>> n3));
        }
    }

    static {
        String[] stringArray = standardDefs;
        Attribute.define((Map)stringArray, 0, "Signature", "RSH");
        Attribute.define((Map)stringArray, 0, "Synthetic", "");
        Attribute.define((Map)stringArray, 0, "Deprecated", "");
        Attribute.define((Map)stringArray, 0, "SourceFile", "RUH");
        Attribute.define((Map)stringArray, 0, "EnclosingMethod", "RCHRDNH");
        Attribute.define((Map)stringArray, 0, "InnerClasses", "NH[RCHRCNHRUNHFH]");
        Attribute.define((Map)stringArray, 1, "Signature", "RSH");
        Attribute.define((Map)stringArray, 1, "Synthetic", "");
        Attribute.define((Map)stringArray, 1, "Deprecated", "");
        Attribute.define((Map)stringArray, 1, "ConstantValue", "KQH");
        Attribute.define((Map)stringArray, 2, "Signature", "RSH");
        Attribute.define((Map)stringArray, 2, "Synthetic", "");
        Attribute.define((Map)stringArray, 2, "Deprecated", "");
        Attribute.define((Map)stringArray, 2, "Exceptions", "NH[RCH]");
        Attribute.define((Map)stringArray, 3, "StackMap", "[NH[PHNH[(1)]NH[(1)]]][TB(7)[RCH](8,9)[PH]()[]]");
        Attribute.define((Map)stringArray, 3, "LineNumberTable", "NH[PHH]");
        Attribute.define((Map)stringArray, 3, "LocalVariableTable", "NH[PHOHRUHRSHH]");
        Attribute.define((Map)stringArray, 3, "LocalVariableTypeTable", "NH[PHOHRUHRSHH]");
        stringArray = new String[]{Attribute.normalizeLayoutString("\n  # parameter_annotations :=\n  [ NB[(1)] ]     # forward call to annotations"), Attribute.normalizeLayoutString("\n  # annotations :=\n  [ NH[(1)] ]     # forward call to annotation\n  \n  # annotation :=\n  [RSH\n    NH[RUH (1)]   # forward call to value\n    ]"), Attribute.normalizeLayoutString("\n  # value :=\n  [TB # Callable 2 encodes one tagged value.\n    (\\B,\\C,\\I,\\S,\\Z)[KIH]\n    (\\D)[KDH]\n    (\\F)[KFH]\n    (\\J)[KJH]\n    (\\c)[RSH]\n    (\\e)[RSH RUH]\n    (\\s)[RUH]\n    (\\[)[NH[(0)]] # backward self-call to value\n    (\\@)[RSH NH[RUH (0)]] # backward self-call to value\n    ()[] ]")};
        HashMap hashMap = standardDefs;
        String string = stringArray[2];
        String string2 = stringArray[1] + stringArray[2];
        String string3 = stringArray[0] + string2;
        for (int i2 = 0; i2 < 4; ++i2) {
            if (i2 == 3) continue;
            Attribute.define(hashMap, i2, "RuntimeVisibleAnnotations", string2);
            Attribute.define(hashMap, i2, "RuntimeInvisibleAnnotations", string2);
            if (i2 != 2) continue;
            Attribute.define(hashMap, i2, "RuntimeVisibleParameterAnnotations", string3);
            Attribute.define(hashMap, i2, "RuntimeInvisibleParameterAnnotations", string3);
            Attribute.define(hashMap, i2, "AnnotationDefault", string);
        }
    }

    public static class FormatException
    extends RuntimeException {
        int ctype;
        String name;
        String layout;

        public FormatException(String string, int n2, String string2, String string3) {
            super(Constants.ATTR_CONTEXT_NAME[n2] + "." + string2 + (string == null ? "" : ": " + string));
            this.ctype = n2;
            this.name = string2;
            this.layout = string3;
        }

        public FormatException(String string, int n2, String string2) {
            this(string, n2, string2, null);
        }
    }

    public static abstract class Holder {
        protected int flags;
        protected List attributes;
        static final List noAttributes = Arrays.asList(new Object[0]);

        protected abstract ConstantPool.Entry[] getCPMap();

        public int attributeSize() {
            return this.attributes == null ? 0 : this.attributes.size();
        }

        public void trimToSize() {
            if (this.attributes == null) {
                return;
            }
            if (this.attributes.size() == 0) {
                this.attributes = null;
                return;
            }
            if (this.attributes instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)this.attributes;
                arrayList.trimToSize();
                boolean bl2 = true;
                for (Attribute attribute : arrayList) {
                    if (!attribute.isCanonical()) {
                        bl2 = false;
                    }
                    if (attribute.fixups == null) continue;
                    assert (!attribute.isCanonical());
                    attribute.fixups = Fixups.trimToSize(attribute.fixups);
                }
                if (bl2) {
                    this.attributes = Attribute.getCanonList(arrayList);
                }
            }
        }

        public void addAttribute(Attribute attribute) {
            if (this.attributes == null) {
                this.attributes = new ArrayList(3);
            } else if (!(this.attributes instanceof ArrayList)) {
                this.attributes = new ArrayList(this.attributes);
            }
            this.attributes.add(attribute);
        }

        public Attribute removeAttribute(Attribute attribute) {
            if (this.attributes == null) {
                return null;
            }
            if (!this.attributes.contains(attribute)) {
                return null;
            }
            if (!(this.attributes instanceof ArrayList)) {
                this.attributes = new ArrayList(this.attributes);
            }
            this.attributes.remove(attribute);
            return attribute;
        }

        public Attribute getAttribute(int n2) {
            return (Attribute)this.attributes.get(n2);
        }

        protected void visitRefs(int n2, Collection collection) {
            if (this.attributes == null) {
                return;
            }
            for (Attribute attribute : this.attributes) {
                attribute.visitRefs(this, n2, collection);
            }
        }

        public List getAttributes() {
            if (this.attributes == null) {
                return noAttributes;
            }
            return this.attributes;
        }

        public void setAttributes(List list) {
            this.attributes = list.isEmpty() ? null : list;
        }

        public Attribute getAttribute(String string) {
            if (this.attributes == null) {
                return null;
            }
            for (Attribute attribute : this.attributes) {
                if (!attribute.name().equals(string)) continue;
                return attribute;
            }
            return null;
        }

        public Attribute getAttribute(Layout layout) {
            if (this.attributes == null) {
                return null;
            }
            for (Attribute attribute : this.attributes) {
                if (attribute.layout() != layout) continue;
                return attribute;
            }
            return null;
        }

        public Attribute removeAttribute(String string) {
            return this.removeAttribute(this.getAttribute(string));
        }

        public Attribute removeAttribute(Layout layout) {
            return this.removeAttribute(this.getAttribute(layout));
        }

        public void strip(String string) {
            this.removeAttribute(this.getAttribute(string));
        }
    }

    public static class Layout
    implements Comparable {
        int ctype;
        String name;
        boolean hasRefs;
        String layout;
        int bandCount;
        Element[] elems;
        Attribute canon;
        private ConstantPool.Entry nameRef;
        private static final Element[] noElems = new Element[0];

        public int ctype() {
            return this.ctype;
        }

        public String name() {
            return this.name;
        }

        public String layout() {
            return this.layout;
        }

        public Attribute canonicalInstance() {
            return this.canon;
        }

        public ConstantPool.Entry getNameRef() {
            ConstantPool.Entry entry = this.nameRef;
            if (entry == null) {
                this.nameRef = entry = ConstantPool.getUtf8Entry(this.name());
            }
            return entry;
        }

        public boolean isEmpty() {
            return this.layout == "";
        }

        public Layout(int n2, String string, String string2) {
            this.ctype = n2;
            this.name = string.intern();
            this.layout = string2.intern();
            assert (n2 < 4);
            boolean bl2 = string2.startsWith("[");
            try {
                if (!bl2) {
                    this.elems = Attribute.tokenizeLayout(this, -1, string2);
                } else {
                    Element element;
                    int n3;
                    String[] stringArray = Attribute.splitBodies(string2);
                    Element[] elementArray = new Element[stringArray.length];
                    this.elems = elementArray;
                    for (n3 = 0; n3 < elementArray.length; ++n3) {
                        element = new Element();
                        element.kind = (byte)10;
                        element.removeBand();
                        element.bandIndex = -1;
                        element.layout = stringArray[n3];
                        elementArray[n3] = element;
                    }
                    for (n3 = 0; n3 < elementArray.length; ++n3) {
                        element = elementArray[n3];
                        element.body = Attribute.tokenizeLayout(this, n3, stringArray[n3]);
                    }
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                throw new RuntimeException("Bad attribute layout: " + string2, stringIndexOutOfBoundsException);
            }
            this.canon = new Attribute(this, noBytes);
        }

        private Layout() {
        }

        static Layout makeKey(int n2, String string, String string2) {
            Layout layout = new Layout();
            layout.ctype = n2;
            layout.name = string.intern();
            layout.layout = string2.intern();
            assert (n2 < 4);
            return layout;
        }

        static Layout makeKey(int n2, String string) {
            return Layout.makeKey(n2, string, "");
        }

        public Attribute addContent(byte[] byArray, Object object) {
            return this.canon.addContent(byArray, object);
        }

        public Attribute addContent(byte[] byArray) {
            return this.canon.addContent(byArray, null);
        }

        public boolean equals(Object object) {
            return object instanceof Layout && this.equals((Layout)object);
        }

        public boolean equals(Layout layout) {
            return this.name == layout.name && this.layout == layout.layout && this.ctype == layout.ctype;
        }

        public int hashCode() {
            return ((17 + this.name.hashCode()) * 37 + this.layout.hashCode()) * 37 + this.ctype;
        }

        public int compareTo(Object object) {
            Layout layout = (Layout)object;
            int n2 = this.name.compareTo(layout.name);
            if (n2 != 0) {
                return n2;
            }
            n2 = this.layout.compareTo(layout.layout);
            if (n2 != 0) {
                return n2;
            }
            return this.ctype - layout.ctype;
        }

        public String toString() {
            String string = Attribute.contextName(this.ctype) + "." + this.name + "[" + this.layout + "]";
            assert ((string = this.stringForDebug()) != null);
            return string;
        }

        private String stringForDebug() {
            return Attribute.contextName(this.ctype) + "." + this.name + Arrays.asList(this.elems);
        }

        public boolean hasCallables() {
            return this.elems.length > 0 && this.elems[0].kind == 10;
        }

        public Element[] getCallables() {
            if (this.hasCallables()) {
                return this.elems;
            }
            return noElems;
        }

        public Element[] getEntryPoint() {
            if (this.hasCallables()) {
                return this.elems[0].body;
            }
            return this.elems;
        }

        public void parse(Holder holder, byte[] byArray, int n2, int n3, ValueStream valueStream) {
            int n4 = Attribute.parseUsing(this.getEntryPoint(), holder, byArray, n2, n3, valueStream);
            if (n4 != n2 + n3) {
                throw new InternalError("layout parsed " + (n4 - n2) + " out of " + n3 + " bytes");
            }
        }

        public Object unparse(ValueStream valueStream, ByteArrayOutputStream byteArrayOutputStream) {
            Object[] objectArray = new Object[]{null};
            Attribute.unparseUsing(this.getEntryPoint(), objectArray, valueStream, byteArrayOutputStream);
            return objectArray[0];
        }

        public class Element {
            String layout;
            byte flags;
            byte kind;
            byte len;
            byte refKind;
            int bandIndex;
            int value;
            Element[] body;

            boolean flagTest(byte by) {
                return (this.flags & by) != 0;
            }

            Element() {
                this.bandIndex = Layout.this.bandCount++;
            }

            void removeBand() {
                --Layout.this.bandCount;
                assert (this.bandIndex == Layout.this.bandCount);
                this.bandIndex = -1;
            }

            public boolean hasBand() {
                return this.bandIndex >= 0;
            }

            public String toString() {
                String string = this.layout;
                assert ((string = this.stringForDebug()) != null);
                return string;
            }

            private String stringForDebug() {
                Element[] elementArray = this.body;
                switch (this.kind) {
                    case 9: {
                        elementArray = null;
                        break;
                    }
                    case 8: {
                        if (!this.flagTest((byte)8)) break;
                        elementArray = null;
                    }
                }
                return this.layout + (!this.hasBand() ? "" : "#" + this.bandIndex) + "<" + (this.flags == 0 ? "" : "" + this.flags) + this.kind + this.len + (this.refKind == 0 ? "" : "" + this.refKind) + ">" + (this.value == 0 ? "" : "(" + this.value + ")") + (elementArray == null ? "" : "" + Arrays.asList(elementArray));
            }
        }
    }

    public static abstract class ValueStream {
        public int getInt(int n2) {
            throw this.undef();
        }

        public void putInt(int n2, int n3) {
            throw this.undef();
        }

        public ConstantPool.Entry getRef(int n2) {
            throw this.undef();
        }

        public void putRef(int n2, ConstantPool.Entry entry) {
            throw this.undef();
        }

        public int decodeBCI(int n2) {
            throw this.undef();
        }

        public int encodeBCI(int n2) {
            throw this.undef();
        }

        public void noteBackCall(int n2) {
        }

        private RuntimeException undef() {
            return new UnsupportedOperationException("ValueStream method");
        }
    }
}

