/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractDataLine;
import com.sun.media.sound.AbstractMixer;
import com.sun.media.sound.AutoClosingClip;
import com.sun.media.sound.DirectAudioDeviceProvider;
import com.sun.media.sound.EventDispatcher;
import com.sun.media.sound.JSSecurityManager;
import com.sun.media.sound.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;

class DirectAudioDevice
extends AbstractMixer {
    private static final int CLIP_BUFFER_TIME = 1000;
    private static final int DEFAULT_LINE_BUFFER_TIME = 500;
    private int deviceCountOpened = 0;
    private int deviceCountStarted = 0;

    DirectAudioDevice(DirectAudioDeviceProvider.DirectAudioDeviceInfo directAudioDeviceInfo) {
        super(directAudioDeviceInfo, null, null, null);
        DirectDLI directDLI = this.createDataLineInfo(true);
        if (directDLI != null) {
            this.sourceLineInfo = new Line.Info[2];
            this.sourceLineInfo[0] = directDLI;
            this.sourceLineInfo[1] = new DirectDLI(Clip.class, directDLI.getFormats(), directDLI.getHardwareFormats(), 32, -1);
        } else {
            this.sourceLineInfo = new Line.Info[0];
        }
        DirectDLI directDLI2 = this.createDataLineInfo(false);
        if (directDLI2 != null) {
            this.targetLineInfo = new Line.Info[1];
            this.targetLineInfo[0] = directDLI2;
        } else {
            this.targetLineInfo = new Line.Info[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectDLI createDataLineInfo(boolean bl2) {
        Vector vector = new Vector();
        AudioFormat[] audioFormatArray = null;
        AudioFormat[] audioFormatArray2 = null;
        Vector vector2 = vector;
        synchronized (vector2) {
            DirectAudioDevice.nGetFormats(this.getMixerIndex(), this.getDeviceID(), bl2, vector);
            if (vector.size() > 0) {
                boolean bl3;
                int n2;
                int n3;
                int n4;
                int n5 = n4 = vector.size();
                audioFormatArray = new AudioFormat[n4];
                for (n3 = 0; n3 < n4; ++n3) {
                    AudioFormat audioFormat;
                    audioFormatArray[n3] = audioFormat = (AudioFormat)vector.elementAt(n3);
                    int n6 = audioFormat.getSampleSizeInBits();
                    n2 = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED);
                    bl3 = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED);
                    if (n2 == 0 && !bl3) continue;
                    ++n5;
                }
                audioFormatArray2 = new AudioFormat[n5];
                n3 = 0;
                for (int i2 = 0; i2 < n4; ++i2) {
                    AudioFormat audioFormat = audioFormatArray[i2];
                    audioFormatArray2[n3++] = audioFormat;
                    n2 = audioFormat.getSampleSizeInBits();
                    bl3 = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED);
                    boolean bl4 = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED);
                    if (n2 == 8) {
                        if (bl3) {
                            audioFormatArray2[n3++] = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, audioFormat.getSampleRate(), n2, audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getSampleRate(), audioFormat.isBigEndian());
                            continue;
                        }
                        if (!bl4) continue;
                        audioFormatArray2[n3++] = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), n2, audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getSampleRate(), audioFormat.isBigEndian());
                        continue;
                    }
                    if (n2 <= 8 || !bl3 && !bl4) continue;
                    audioFormatArray2[n3++] = new AudioFormat(audioFormat.getEncoding(), audioFormat.getSampleRate(), n2, audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getSampleRate(), !audioFormat.isBigEndian());
                }
            }
        }
        if (audioFormatArray2 != null) {
            return new DirectDLI(bl2 ? SourceDataLine.class : TargetDataLine.class, audioFormatArray2, audioFormatArray, 32, -1);
        }
        return null;
    }

    public Line getLine(Line.Info info) throws LineUnavailableException {
        Line.Info info2 = this.getLineInfo(info);
        if (info2 == null) {
            throw new IllegalArgumentException("Line unsupported: " + info);
        }
        if (info2 instanceof DataLine.Info) {
            AudioFormat audioFormat;
            DataLine.Info info3 = (DataLine.Info)info2;
            int n2 = -1;
            AudioFormat[] audioFormatArray = null;
            if (info instanceof DataLine.Info) {
                audioFormatArray = ((DataLine.Info)info).getFormats();
                n2 = ((DataLine.Info)info).getMaxBufferSize();
            }
            if (audioFormatArray == null || audioFormatArray.length == 0) {
                audioFormat = null;
            } else {
                audioFormat = audioFormatArray[audioFormatArray.length - 1];
                if (!Toolkit.isFullySpecifiedPCMFormat(audioFormat)) {
                    audioFormat = null;
                }
            }
            if (info3.getLineClass().isAssignableFrom(DirectSDL.class)) {
                return new DirectSDL(info3, audioFormat, n2, this);
            }
            if (info3.getLineClass().isAssignableFrom(DirectClip.class)) {
                return new DirectClip(info3, audioFormat, n2, this);
            }
            if (info3.getLineClass().isAssignableFrom(DirectTDL.class)) {
                return new DirectTDL(info3, audioFormat, n2, this);
            }
        }
        throw new IllegalArgumentException("Line unsupported: " + info);
    }

    public int getMaxLines(Line.Info info) {
        Line.Info info2 = this.getLineInfo(info);
        if (info2 == null) {
            return 0;
        }
        if (info2 instanceof DataLine.Info) {
            return this.getMaxSimulLines();
        }
        return 0;
    }

    protected void implOpen() throws LineUnavailableException {
    }

    protected void implClose() {
    }

    protected void implStart() {
    }

    protected void implStop() {
    }

    int getMixerIndex() {
        return ((DirectAudioDeviceProvider.DirectAudioDeviceInfo)this.getMixerInfo()).getIndex();
    }

    int getDeviceID() {
        return ((DirectAudioDeviceProvider.DirectAudioDeviceInfo)this.getMixerInfo()).getDeviceID();
    }

    int getMaxSimulLines() {
        return ((DirectAudioDeviceProvider.DirectAudioDeviceInfo)this.getMixerInfo()).getMaxSimulLines();
    }

    private static void addFormat(Vector vector, int n2, int n3, int n4, float f2, int n5, boolean bl2, boolean bl3) {
        AudioFormat.Encoding encoding = null;
        switch (n5) {
            case 0: {
                encoding = bl2 ? AudioFormat.Encoding.PCM_SIGNED : AudioFormat.Encoding.PCM_UNSIGNED;
                break;
            }
            case 1: {
                encoding = AudioFormat.Encoding.ULAW;
                if (n2 == 8) break;
                n2 = 8;
                n3 = n4;
                break;
            }
            case 2: {
                encoding = AudioFormat.Encoding.ALAW;
                if (n2 == 8) break;
                n2 = 8;
                n3 = n4;
            }
        }
        if (encoding == null) {
            return;
        }
        if (n3 <= 0) {
            n3 = n4 > 0 ? (n2 + 7) / 8 * n4 : -1;
        }
        vector.add(new AudioFormat(encoding, f2, n2, n4, n3, f2, bl3));
    }

    protected static AudioFormat getSignOrEndianChangedFormat(AudioFormat audioFormat) {
        boolean bl2 = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED);
        boolean bl3 = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED);
        if (audioFormat.getSampleSizeInBits() > 8 && bl2) {
            return new AudioFormat(audioFormat.getEncoding(), audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), !audioFormat.isBigEndian());
        }
        if (audioFormat.getSampleSizeInBits() == 8 && (bl2 || bl3)) {
            return new AudioFormat(bl2 ? AudioFormat.Encoding.PCM_UNSIGNED : AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), audioFormat.isBigEndian());
        }
        return null;
    }

    private static native void nGetFormats(int var0, int var1, boolean var2, Vector var3);

    private static native long nOpen(int var0, int var1, boolean var2, int var3, float var4, int var5, int var6, int var7, boolean var8, boolean var9, int var10) throws LineUnavailableException;

    private static native void nStart(long var0, boolean var2);

    private static native void nStop(long var0, boolean var2);

    private static native void nClose(long var0, boolean var2);

    private static native int nWrite(long var0, byte[] var2, int var3, int var4, int var5, float var6, float var7);

    private static native int nRead(long var0, byte[] var2, int var3, int var4, int var5);

    private static native int nGetBufferSize(long var0, boolean var2);

    private static native boolean nIsStillDraining(long var0, boolean var2);

    private static native void nFlush(long var0, boolean var2);

    private static native int nAvailable(long var0, boolean var2);

    private static native long nGetBytePosition(long var0, boolean var2, long var3);

    private static native void nSetBytePosition(long var0, boolean var2, long var3);

    private static native boolean nRequiresServicing(long var0, boolean var2);

    private static native void nService(long var0, boolean var2);

    private static class DirectBAOS
    extends ByteArrayOutputStream {
        public byte[] getInternalBuffer() {
            return this.buf;
        }
    }

    private static class DirectClip
    extends DirectDL
    implements Clip,
    Runnable,
    AutoClosingClip {
        private Thread thread;
        private byte[] audioData = null;
        private int frameSize;
        private int m_lengthInFrames;
        private int loopCount;
        private int clipBytePosition;
        private int newFramePosition;
        private int loopStartFrame;
        private int loopEndFrame;
        private boolean autoclosing = false;

        private DirectClip(DataLine.Info info, AudioFormat audioFormat, int n2, DirectAudioDevice directAudioDevice) {
            super(info, directAudioDevice, audioFormat, n2, directAudioDevice.getMixerIndex(), directAudioDevice.getDeviceID(), true);
        }

        public void open(AudioFormat audioFormat, byte[] byArray, int n2, int n3) throws LineUnavailableException {
            Toolkit.isFullySpecifiedAudioFormat(audioFormat);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
            this.open(audioFormat, byArray, n3 / audioFormat.getFrameSize());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void open(AudioFormat audioFormat, byte[] byArray, int n2) throws LineUnavailableException {
            Toolkit.isFullySpecifiedAudioFormat(audioFormat);
            AbstractMixer abstractMixer = this.mixer;
            synchronized (abstractMixer) {
                if (this.isOpen()) {
                    throw new IllegalStateException("Clip is already open with format " + this.getFormat() + " and frame lengh of " + this.getFrameLength());
                }
                this.audioData = byArray;
                this.frameSize = audioFormat.getFrameSize();
                this.m_lengthInFrames = n2;
                this.bytePosition = 0L;
                this.clipBytePosition = 0;
                this.newFramePosition = -1;
                this.loopStartFrame = 0;
                this.loopEndFrame = n2 - 1;
                this.loopCount = 0;
                try {
                    this.open(audioFormat, (int)Toolkit.millis2bytes(audioFormat, 1000L));
                }
                catch (LineUnavailableException lineUnavailableException) {
                    this.audioData = null;
                    throw lineUnavailableException;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.audioData = null;
                    throw illegalArgumentException;
                }
                int n3 = 6;
                this.thread = JSSecurityManager.createThread(this, "Direct Clip", true, n3, false);
                this.thread.start();
            }
            if (this.isAutoClosing()) {
                this.getEventDispatcher().autoClosingClipOpened(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void open(AudioInputStream audioInputStream) throws LineUnavailableException, IOException {
            Toolkit.isFullySpecifiedAudioFormat(this.format);
            AbstractMixer abstractMixer = this.mixer;
            synchronized (abstractMixer) {
                byte[] byArray = null;
                if (this.isOpen()) {
                    throw new IllegalStateException("Clip is already open with format " + this.getFormat() + " and frame lengh of " + this.getFrameLength());
                }
                int n2 = (int)audioInputStream.getFrameLength();
                int n3 = 0;
                if (n2 != -1) {
                    int n4 = n2 * audioInputStream.getFormat().getFrameSize();
                    byArray = new byte[n4];
                    int n5 = n4;
                    int n6 = 0;
                    while (n5 > 0 && n6 >= 0) {
                        n6 = audioInputStream.read(byArray, n3, n5);
                        if (n6 > 0) {
                            n3 += n6;
                            n5 -= n6;
                            continue;
                        }
                        if (n6 != 0) continue;
                        Thread.yield();
                    }
                } else {
                    int n7 = 16384;
                    DirectBAOS directBAOS = new DirectBAOS();
                    byte[] byArray2 = new byte[n7];
                    int n8 = 0;
                    while (n8 >= 0) {
                        n8 = audioInputStream.read(byArray2, 0, byArray2.length);
                        if (n8 > 0) {
                            directBAOS.write(byArray2, 0, n8);
                            n3 += n8;
                            continue;
                        }
                        if (n8 != 0) continue;
                        Thread.yield();
                    }
                    byArray = directBAOS.getInternalBuffer();
                }
                n2 = n3 / audioInputStream.getFormat().getFrameSize();
                this.open(audioInputStream.getFormat(), byArray, n2);
            }
        }

        public int getFrameLength() {
            return this.m_lengthInFrames;
        }

        public long getMicrosecondLength() {
            return Toolkit.frames2micros(this.getFormat(), this.getFrameLength());
        }

        public void setFramePosition(int n2) {
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 >= this.getFrameLength()) {
                n2 = this.getFrameLength();
            }
            if (this.doIO) {
                this.newFramePosition = n2;
            } else {
                this.clipBytePosition = n2 * this.frameSize;
                this.newFramePosition = -1;
            }
            this.bytePosition = n2 * this.frameSize;
            this.flush();
            this.nativeRefCounter.increment();
            DirectAudioDevice.nSetBytePosition(this.id, this.isSource, n2 * this.frameSize);
            this.nativeRefCounter.decrement();
        }

        public long getLongFramePosition() {
            return super.getLongFramePosition();
        }

        public synchronized void setMicrosecondPosition(long l2) {
            long l3 = Toolkit.micros2frames(this.getFormat(), l2);
            this.setFramePosition((int)l3);
        }

        public void setLoopPoints(int n2, int n3) {
            if (n2 < 0 || n2 >= this.getFrameLength()) {
                throw new IllegalArgumentException("illegal value for start: " + n2);
            }
            if (n3 >= this.getFrameLength()) {
                throw new IllegalArgumentException("illegal value for end: " + n3);
            }
            if (n3 == -1 && (n3 = this.getFrameLength() - 1) < 0) {
                n3 = 0;
            }
            if (n3 < n2) {
                throw new IllegalArgumentException("End position " + n3 + "  preceeds start position " + n2);
            }
            this.loopStartFrame = n2;
            this.loopEndFrame = n3;
        }

        public void loop(int n2) {
            this.loopCount = n2;
            this.start();
        }

        void implOpen(AudioFormat audioFormat, int n2) throws LineUnavailableException {
            if (this.audioData == null) {
                throw new IllegalArgumentException("illegal call to open() in interface Clip");
            }
            super.implOpen(audioFormat, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void implClose() {
            Thread thread = this.thread;
            this.thread = null;
            this.doIO = false;
            if (thread != null) {
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
                try {
                    thread.join(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            super.implClose();
            this.audioData = null;
            this.newFramePosition = -1;
            this.getEventDispatcher().autoClosingClipClosed(this);
        }

        void implStart() {
            super.implStart();
        }

        void implStop() {
            super.implStop();
            this.loopCount = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.thread != null) {
                if (!this.doIO) {
                    Object object = this.lock;
                    synchronized (object) {
                        try {
                            this.lock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                while (this.doIO) {
                    long l2;
                    int n2;
                    int n3;
                    if (this.newFramePosition >= 0) {
                        this.clipBytePosition = this.newFramePosition * this.frameSize;
                        this.newFramePosition = -1;
                    }
                    int n4 = this.getFrameLength() - 1;
                    if (this.loopCount > 0 || this.loopCount == -1) {
                        n4 = this.loopEndFrame;
                    }
                    if ((n3 = (n2 = (int)((long)n4 - (l2 = (long)(this.clipBytePosition / this.frameSize)) + 1L)) * this.frameSize) > this.getBufferSize()) {
                        n3 = Toolkit.align(this.getBufferSize(), this.frameSize);
                    }
                    int n5 = this.write(this.audioData, this.clipBytePosition, n3);
                    this.clipBytePosition += n5;
                    if (!this.doIO || this.newFramePosition >= 0 || n5 < 0 || (l2 = (long)(this.clipBytePosition / this.frameSize)) <= (long)n4) continue;
                    if (this.loopCount > 0 || this.loopCount == -1) {
                        if (this.loopCount != -1) {
                            --this.loopCount;
                        }
                        this.newFramePosition = this.loopStartFrame;
                        continue;
                    }
                    this.drain();
                    this.stop();
                }
            }
        }

        public boolean isAutoClosing() {
            return this.autoclosing;
        }

        public void setAutoClosing(boolean bl2) {
            if (bl2 != this.autoclosing) {
                if (this.isOpen()) {
                    if (bl2) {
                        this.getEventDispatcher().autoClosingClipOpened(this);
                    } else {
                        this.getEventDispatcher().autoClosingClipClosed(this);
                    }
                }
                this.autoclosing = bl2;
            }
        }

        protected boolean requiresServicing() {
            return false;
        }
    }

    private static class DirectDL
    extends AbstractDataLine
    implements EventDispatcher.LineMonitor {
        protected int mixerIndex;
        protected int deviceID;
        protected long id;
        protected int waitTime;
        protected volatile boolean flushing = false;
        protected boolean isSource;
        protected long bytePosition;
        protected volatile boolean doIO = false;
        protected volatile boolean stoppedWritten = false;
        protected volatile boolean drained = false;
        protected boolean monitoring = false;
        protected int softwareConversionSize = 0;
        protected AudioFormat hardwareFormat;
        private Gain gainControl = new Gain();
        private Mute muteControl = new Mute();
        private Balance balanceControl = new Balance();
        private Pan panControl = new Pan();
        private float leftGain;
        private float rightGain;
        protected volatile boolean noService = false;
        protected NativeRefCounter nativeRefCounter = new NativeRefCounter();

        protected DirectDL(DataLine.Info info, DirectAudioDevice directAudioDevice, AudioFormat audioFormat, int n2, int n3, int n4, boolean bl2) {
            super(info, directAudioDevice, null, audioFormat, n2);
            this.mixerIndex = n3;
            this.deviceID = n4;
            this.waitTime = 10;
            this.isSource = bl2;
        }

        void implOpen(AudioFormat audioFormat, int n2) throws LineUnavailableException {
            AudioFormat audioFormat2;
            Toolkit.isFullySpecifiedAudioFormat(audioFormat);
            if (!this.isSource) {
                JSSecurityManager.checkRecordPermission();
            }
            int n3 = 0;
            if (audioFormat.getEncoding().equals(AudioFormat.Encoding.ULAW)) {
                n3 = 1;
            } else if (audioFormat.getEncoding().equals(AudioFormat.Encoding.ALAW)) {
                n3 = 2;
            }
            if (n2 <= -1) {
                n2 = (int)Toolkit.millis2bytes(audioFormat, 500L);
            }
            DirectDLI directDLI = null;
            if (this.info instanceof DirectDLI) {
                directDLI = (DirectDLI)this.info;
            }
            if (this.isSource) {
                if (!audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) && !audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
                    this.controls = new Control[0];
                } else if (audioFormat.getChannels() > 2 || audioFormat.getSampleSizeInBits() > 16) {
                    this.controls = new Control[0];
                } else {
                    if (audioFormat.getChannels() == 1) {
                        this.controls = new Control[2];
                    } else {
                        this.controls = new Control[4];
                        this.controls[2] = this.balanceControl;
                        this.controls[3] = this.panControl;
                    }
                    this.controls[0] = this.gainControl;
                    this.controls[1] = this.muteControl;
                }
            }
            this.hardwareFormat = audioFormat;
            this.softwareConversionSize = 0;
            if (directDLI != null && !directDLI.isFormatSupportedInHardware(audioFormat) && directDLI.isFormatSupportedInHardware(audioFormat2 = DirectAudioDevice.getSignOrEndianChangedFormat(audioFormat))) {
                this.hardwareFormat = audioFormat2;
                this.softwareConversionSize = audioFormat.getFrameSize() / audioFormat.getChannels();
            }
            n2 = n2 / audioFormat.getFrameSize() * audioFormat.getFrameSize();
            this.id = DirectAudioDevice.nOpen(this.mixerIndex, this.deviceID, this.isSource, n3, this.hardwareFormat.getSampleRate(), this.hardwareFormat.getSampleSizeInBits(), this.hardwareFormat.getFrameSize(), this.hardwareFormat.getChannels(), this.hardwareFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED), this.hardwareFormat.isBigEndian(), n2);
            if (this.id == 0L) {
                throw new LineUnavailableException("line with format " + audioFormat + " not supported.");
            }
            this.bufferSize = DirectAudioDevice.nGetBufferSize(this.id, this.isSource);
            if (this.bufferSize < 1) {
                this.bufferSize = n2;
            }
            this.format = audioFormat;
            this.waitTime = (int)Toolkit.bytes2millis(audioFormat, this.bufferSize) / 4;
            if (this.waitTime < 10) {
                this.waitTime = 1;
            } else if (this.waitTime > 1000) {
                this.waitTime = 1000;
            }
            this.bytePosition = 0L;
            this.stoppedWritten = false;
            this.doIO = false;
            this.calcVolume();
        }

        void implStart() {
            if (!this.isSource) {
                JSSecurityManager.checkRecordPermission();
            }
            this.nativeRefCounter.increment();
            DirectAudioDevice.nStart(this.id, this.isSource);
            this.monitoring = this.requiresServicing();
            if (this.monitoring) {
                this.getEventDispatcher().addLineMonitor(this);
            }
            this.nativeRefCounter.decrement();
            this.doIO = true;
            if (this.isSource && this.stoppedWritten) {
                this.setStarted(true);
                this.setActive(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void implStop() {
            if (!this.isSource) {
                JSSecurityManager.checkRecordPermission();
            }
            this.nativeRefCounter.increment();
            if (this.monitoring) {
                this.getEventDispatcher().removeLineMonitor(this);
                this.monitoring = false;
            }
            DirectAudioDevice.nStop(this.id, this.isSource);
            this.nativeRefCounter.decrement();
            this.doIO = false;
            this.drained = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
            this.setActive(false);
            this.setStarted(false);
            this.stoppedWritten = false;
        }

        void implClose() {
            if (!this.isSource) {
                JSSecurityManager.checkRecordPermission();
            }
            if (this.monitoring) {
                this.getEventDispatcher().removeLineMonitor(this);
                this.monitoring = false;
            }
            this.doIO = false;
            long l2 = this.id;
            this.id = 0L;
            while (this.nativeRefCounter.value() > 0) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
            DirectAudioDevice.nClose(l2, this.isSource);
            this.bytePosition = 0L;
            this.softwareConversionSize = 0;
        }

        public int available() {
            if (this.id == 0L) {
                return 0;
            }
            int n2 = 0;
            this.nativeRefCounter.increment();
            n2 = DirectAudioDevice.nAvailable(this.id, this.isSource);
            this.nativeRefCounter.decrement();
            return n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drain() {
            this.noService = true;
            int n2 = 0;
            long l2 = this.getLongFramePosition();
            boolean bl2 = false;
            while (!this.drained && this.id != 0L && DirectAudioDevice.nIsStillDraining(this.id, this.isSource) && this.doIO) {
                if (n2 % 5 == 4) {
                    long l3 = this.getLongFramePosition();
                    bl2 |= l3 != l2;
                    if (n2 % 50 > 45) {
                        if (!bl2) break;
                        bl2 = false;
                        l2 = l3;
                    }
                }
                ++n2;
                Object object = this.lock;
                synchronized (object) {
                    try {
                        this.lock.wait(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this.doIO && this.id != 0L) {
                this.drained = true;
            }
            this.noService = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() {
            if (this.id != 0L) {
                this.flushing = true;
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
                while (this.nativeRefCounter.value() > 0) {
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.id != 0L) {
                    this.nativeRefCounter.increment();
                    DirectAudioDevice.nFlush(this.id, this.isSource);
                    this.nativeRefCounter.decrement();
                }
                this.drained = true;
            }
        }

        public long getLongFramePosition() {
            this.nativeRefCounter.increment();
            long l2 = DirectAudioDevice.nGetBytePosition(this.id, this.isSource, this.bytePosition);
            this.nativeRefCounter.decrement();
            if (l2 < 0L) {
                l2 = 0L;
            }
            return l2 / (long)this.getFormat().getFrameSize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int write(byte[] byArray, int n2, int n3) {
            this.flushing = false;
            if (n3 == 0) {
                return 0;
            }
            if (n3 < 0) {
                throw new IllegalArgumentException("illegal len: " + n3);
            }
            if (n3 % this.getFormat().getFrameSize() != 0) {
                throw new IllegalArgumentException("illegal request to write non-integral number of frames (" + n3 + " bytes, " + "frameSize = " + this.getFormat().getFrameSize() + " bytes)");
            }
            if (n2 < 0) {
                throw new ArrayIndexOutOfBoundsException(n2);
            }
            if (n2 + n3 > byArray.length) {
                throw new ArrayIndexOutOfBoundsException(byArray.length);
            }
            if (!this.isActive() && this.doIO) {
                this.setActive(true);
                this.setStarted(true);
            }
            int n4 = 0;
            while (!this.flushing) {
                this.nativeRefCounter.increment();
                int n5 = DirectAudioDevice.nWrite(this.id, byArray, n2, n3, this.softwareConversionSize, this.leftGain, this.rightGain);
                this.nativeRefCounter.decrement();
                if (n5 < 0) break;
                n3 -= n5;
                this.bytePosition += (long)n5;
                n4 += n5;
                if (n5 > 0) {
                    this.drained = false;
                }
                if (!this.doIO || n3 <= 0) break;
                n2 += n5;
                Object object = this.lock;
                synchronized (object) {
                    try {
                        this.lock.wait(this.waitTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (n4 > 0 && !this.doIO) {
                this.stoppedWritten = true;
            }
            return n4;
        }

        protected boolean requiresServicing() {
            return DirectAudioDevice.nRequiresServicing(this.id, this.isSource);
        }

        public void checkLine() {
            if (this.monitoring && this.doIO && this.id != 0L && !this.flushing && !this.noService && this.nativeRefCounter.value() == 0) {
                DirectAudioDevice.nService(this.id, this.isSource);
            }
        }

        private void calcVolume() {
            if (this.getFormat() == null) {
                return;
            }
            if (this.muteControl.getValue()) {
                this.leftGain = 0.0f;
                this.rightGain = 0.0f;
                return;
            }
            float f2 = this.gainControl.getLinearGain();
            if (this.getFormat().getChannels() == 1) {
                this.leftGain = f2;
                this.rightGain = f2;
            } else {
                float f3 = this.balanceControl.getValue();
                if (f3 < 0.0f) {
                    this.leftGain = f2;
                    this.rightGain = f2 * (f3 + 1.0f);
                } else {
                    this.leftGain = f2 * (1.0f - f3);
                    this.rightGain = f2;
                }
            }
        }

        private class Balance
        extends FloatControl {
            private Balance() {
                super(FloatControl.Type.BALANCE, -1.0f, 1.0f, 0.0078125f, -1, 0.0f, "", "Left", "Center", "Right");
            }

            public void setValue(float f2) {
                this.setValueImpl(f2);
                DirectDL.this.panControl.setValueImpl(f2);
                DirectDL.this.calcVolume();
            }

            void setValueImpl(float f2) {
                super.setValue(f2);
            }
        }

        protected class Gain
        extends FloatControl {
            private float linearGain;

            private Gain() {
                super(FloatControl.Type.MASTER_GAIN, Toolkit.linearToDB(0.0f), Toolkit.linearToDB(2.0f), Math.abs(Toolkit.linearToDB(1.0f) - Toolkit.linearToDB(0.0f)) / 128.0f, -1, 0.0f, "dB", "Minimum", "", "Maximum");
                this.linearGain = 1.0f;
            }

            public void setValue(float f2) {
                float f3 = Toolkit.dBToLinear(f2);
                super.setValue(Toolkit.linearToDB(f3));
                this.linearGain = f3;
                DirectDL.this.calcVolume();
            }

            float getLinearGain() {
                return this.linearGain;
            }
        }

        private class Mute
        extends BooleanControl {
            private Mute() {
                super(BooleanControl.Type.MUTE, false, "True", "False");
            }

            public void setValue(boolean bl2) {
                super.setValue(bl2);
                DirectDL.this.calcVolume();
            }
        }

        protected class NativeRefCounter {
            private volatile int counter = 0;

            protected NativeRefCounter() {
            }

            public synchronized int increment() {
                return ++this.counter;
            }

            public synchronized int decrement() {
                return --this.counter;
            }

            public int value() {
                return this.counter;
            }
        }

        private class Pan
        extends FloatControl {
            private Pan() {
                super(FloatControl.Type.PAN, -1.0f, 1.0f, 0.0078125f, -1, 0.0f, "", "Left", "Center", "Right");
            }

            public void setValue(float f2) {
                this.setValueImpl(f2);
                DirectDL.this.balanceControl.setValueImpl(f2);
                DirectDL.this.calcVolume();
            }

            void setValueImpl(float f2) {
                super.setValue(f2);
            }
        }
    }

    private static class DirectDLI
    extends DataLine.Info {
        AudioFormat[] hardwareFormats;

        private DirectDLI(Class clazz, AudioFormat[] audioFormatArray, AudioFormat[] audioFormatArray2, int n2, int n3) {
            super(clazz, audioFormatArray, n2, n3);
            this.hardwareFormats = audioFormatArray2;
        }

        public boolean isFormatSupportedInHardware(AudioFormat audioFormat) {
            if (audioFormat == null) {
                return false;
            }
            for (int i2 = 0; i2 < this.hardwareFormats.length; ++i2) {
                if (!audioFormat.matches(this.hardwareFormats[i2])) continue;
                return true;
            }
            return false;
        }

        private AudioFormat[] getHardwareFormats() {
            return this.hardwareFormats;
        }
    }

    private static class DirectSDL
    extends DirectDL
    implements SourceDataLine {
        private DirectSDL(DataLine.Info info, AudioFormat audioFormat, int n2, DirectAudioDevice directAudioDevice) {
            super(info, directAudioDevice, audioFormat, n2, directAudioDevice.getMixerIndex(), directAudioDevice.getDeviceID(), true);
        }
    }

    private static class DirectTDL
    extends DirectDL
    implements TargetDataLine {
        private DirectTDL(DataLine.Info info, AudioFormat audioFormat, int n2, DirectAudioDevice directAudioDevice) {
            super(info, directAudioDevice, audioFormat, n2, directAudioDevice.getMixerIndex(), directAudioDevice.getDeviceID(), false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray, int n2, int n3) {
            this.flushing = false;
            if (n3 == 0) {
                return 0;
            }
            if (n3 < 0) {
                throw new IllegalArgumentException("illegal len: " + n3);
            }
            if (n3 % this.getFormat().getFrameSize() != 0) {
                throw new IllegalArgumentException("illegal request to read non-integral number of frames (" + n3 + " bytes, " + "frameSize = " + this.getFormat().getFrameSize() + " bytes)");
            }
            if (n2 < 0) {
                throw new ArrayIndexOutOfBoundsException(n2);
            }
            if (n2 + n3 > byArray.length) {
                throw new ArrayIndexOutOfBoundsException(byArray.length);
            }
            if (!this.isActive() && this.doIO) {
                this.setActive(true);
                this.setStarted(true);
            }
            int n4 = 0;
            while (this.doIO && !this.flushing) {
                this.nativeRefCounter.increment();
                int n5 = DirectAudioDevice.nRead(this.id, byArray, n2, n3, this.softwareConversionSize);
                this.nativeRefCounter.decrement();
                if (n5 < 0) break;
                n3 -= n5;
                this.bytePosition += (long)n5;
                n4 += n5;
                if (n5 > 0) {
                    this.drained = false;
                }
                if (n3 <= 0) break;
                n2 += n5;
                Object object = this.lock;
                synchronized (object) {
                    try {
                        this.lock.wait(this.waitTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this.flushing) {
                n4 = 0;
            }
            return n4;
        }
    }
}

