/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.Encoder;
import java.beans.Expression;
import java.beans.Introspector;
import java.beans.NameGenerator;
import java.beans.ReflectionUtils;
import java.beans.Statement;
import java.beans.XMLDecoder;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Vector;

public class XMLEncoder
extends Encoder {
    private static String encoding = "UTF-8";
    private OutputStream out;
    private Object owner;
    private int indentation = 0;
    private boolean internal = false;
    private Map valueToExpression;
    private Map targetToStatementList;
    private boolean preambleWritten = false;
    private NameGenerator nameGenerator;

    public XMLEncoder(OutputStream outputStream) {
        this.out = outputStream;
        this.valueToExpression = new IdentityHashMap();
        this.targetToStatementList = new IdentityHashMap();
        this.nameGenerator = new NameGenerator();
    }

    public void setOwner(Object object) {
        this.owner = object;
        this.writeExpression(new Expression(this, "getOwner", new Object[0]));
    }

    public Object getOwner() {
        return this.owner;
    }

    public void writeObject(Object object) {
        if (this.internal) {
            super.writeObject(object);
        } else {
            this.writeStatement(new Statement(this, "writeObject", new Object[]{object}));
        }
    }

    private Vector statementList(Object object) {
        Vector vector = (Vector)this.targetToStatementList.get(object);
        if (vector != null) {
            return vector;
        }
        vector = new Vector();
        this.targetToStatementList.put(object, vector);
        return vector;
    }

    private void mark(Object object, boolean bl2) {
        if (object == null || object == this) {
            return;
        }
        ValueData valueData = this.getValueData(object);
        Expression expression = valueData.exp;
        if (object.getClass() == String.class && expression == null) {
            return;
        }
        if (bl2) {
            ++valueData.refs;
        }
        if (valueData.marked) {
            return;
        }
        valueData.marked = true;
        Object object2 = expression.getTarget();
        if (!(object2 instanceof Class)) {
            this.statementList(object2).add(expression);
            ++valueData.refs;
        }
        this.mark(expression);
    }

    private void mark(Statement statement) {
        Object[] objectArray = statement.getArguments();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object = objectArray[i2];
            this.mark(object, true);
        }
        this.mark(statement.getTarget(), false);
    }

    public void writeStatement(Statement statement) {
        boolean bl2 = this.internal;
        this.internal = true;
        try {
            super.writeStatement(statement);
            this.mark(statement);
            this.statementList(statement.getTarget()).add(statement);
        }
        catch (Exception exception) {
            this.getExceptionListener().exceptionThrown(new Exception("XMLEncoder: discarding statement " + statement, exception));
        }
        this.internal = bl2;
    }

    public void writeExpression(Expression expression) {
        boolean bl2 = this.internal;
        this.internal = true;
        Object object = this.getValue(expression);
        if (this.get(object) == null || object instanceof String && !bl2) {
            this.getValueData((Object)object).exp = expression;
            super.writeExpression(expression);
        }
        this.internal = bl2;
    }

    public void flush() {
        if (!this.preambleWritten) {
            this.writeln("<?xml version=" + this.quote("1.0") + " encoding=" + this.quote(encoding) + "?>");
            this.writeln("<java version=" + this.quote(System.getProperty("java.version")) + " class=" + this.quote(XMLDecoder.class.getName()) + ">");
            this.preambleWritten = true;
        }
        ++this.indentation;
        Vector vector = this.statementList(this);
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            Statement statement = (Statement)vector.get(i2);
            if ("writeObject".equals(statement.getMethodName())) {
                this.outputValue(statement.getArguments()[0], this, true);
                continue;
            }
            this.outputStatement(statement, this, false);
        }
        --this.indentation;
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            this.getExceptionListener().exceptionThrown(iOException);
        }
        this.clear();
    }

    void clear() {
        super.clear();
        this.nameGenerator.clear();
        this.valueToExpression.clear();
        this.targetToStatementList.clear();
    }

    public void close() {
        this.flush();
        this.writeln("</java>");
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            this.getExceptionListener().exceptionThrown(iOException);
        }
    }

    private String quote(String string) {
        return "\"" + string + "\"";
    }

    private ValueData getValueData(Object object) {
        ValueData valueData = (ValueData)this.valueToExpression.get(object);
        if (valueData == null) {
            valueData = new ValueData();
            this.valueToExpression.put(object, valueData);
        }
        return valueData;
    }

    private static String quoteCharacters(String string) {
        StringBuffer stringBuffer = null;
        int n2 = string.length();
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            String string2 = null;
            if (c2 == '&') {
                string2 = "&amp;";
            } else if (c2 == '<') {
                string2 = "&lt;";
            } else if (c2 == '\r') {
                string2 = "&#13;";
            } else if (c2 == '>') {
                string2 = "&gt;";
            } else if (c2 == '\"') {
                string2 = "&quot;";
            } else if (c2 == '\'') {
                string2 = "&apos;";
            }
            if (string2 == null) continue;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(string);
            }
            stringBuffer.replace(i2 + n3, i2 + n3 + 1, string2);
            n3 += string2.length() - 1;
        }
        if (stringBuffer == null) {
            return string;
        }
        return stringBuffer.toString();
    }

    private void writeln(String string) {
        try {
            for (int i2 = 0; i2 < this.indentation; ++i2) {
                this.out.write(32);
            }
            this.out.write(string.getBytes(encoding));
            this.out.write(" \n".getBytes(encoding));
        }
        catch (IOException iOException) {
            this.getExceptionListener().exceptionThrown(iOException);
        }
    }

    private void outputValue(Object object, Object object2, boolean bl2) {
        if (object == null) {
            this.writeln("<null/>");
            return;
        }
        if (object instanceof Class) {
            this.writeln("<class>" + ((Class)object).getName() + "</class>");
            return;
        }
        ValueData valueData = this.getValueData(object);
        if (valueData.exp != null) {
            Object object3 = valueData.exp.getTarget();
            String string = valueData.exp.getMethodName();
            if (object3 == null || string == null) {
                throw new NullPointerException((object3 == null ? "target" : "methodName") + " should not be null");
            }
            if (object3 instanceof Field && string.equals("get")) {
                Field field = (Field)object3;
                this.writeln("<object class=" + this.quote(field.getDeclaringClass().getName()) + " field=" + this.quote(field.getName()) + "/>");
                return;
            }
            Class clazz = ReflectionUtils.primitiveTypeFor(object.getClass());
            if (clazz != null && object3 == object.getClass() && string.equals("new")) {
                String string2 = clazz.getName();
                if (clazz == Character.TYPE) {
                    object = XMLEncoder.quoteCharacters(((Character)object).toString());
                }
                this.writeln("<" + string2 + ">" + object + "</" + string2 + ">");
                return;
            }
        } else if (object instanceof String) {
            this.writeln("<string>" + XMLEncoder.quoteCharacters((String)object) + "</string>");
            return;
        }
        if (valueData.name != null) {
            this.writeln("<object idref=" + this.quote(valueData.name) + "/>");
            return;
        }
        this.outputStatement(valueData.exp, object2, bl2);
    }

    private void outputStatement(Statement statement, Object object, boolean bl2) {
        int n2;
        Object object2;
        Object object3 = statement.getTarget();
        String string = statement.getMethodName();
        if (object3 == null || string == null) {
            throw new NullPointerException((object3 == null ? "target" : "methodName") + " should not be null");
        }
        Object[] objectArray = statement.getArguments();
        boolean bl3 = statement.getClass() == Expression.class;
        Object object4 = bl3 ? this.getValue((Expression)statement) : null;
        String string2 = bl3 && bl2 ? "object" : "void";
        String string3 = "";
        ValueData valueData = this.getValueData(object4);
        if (bl3 && valueData.refs > 1) {
            object2 = this.nameGenerator.instanceName(object4);
            valueData.name = object2;
            string3 = string3 + " id=" + this.quote((String)object2);
        }
        if (object3 != object) {
            if (object3 == Array.class && string.equals("newInstance")) {
                string2 = "array";
                string3 = string3 + " class=" + this.quote(((Class)objectArray[0]).getName());
                string3 = string3 + " length=" + this.quote(objectArray[1].toString());
                objectArray = new Object[]{};
            } else if (object3.getClass() == Class.class) {
                string3 = string3 + " class=" + this.quote(((Class)object3).getName());
            } else {
                valueData.refs = 2;
                this.outputValue(object3, object, false);
                this.outputValue(object4, object, false);
                return;
            }
        }
        if (!bl3 && string.equals("set") && objectArray.length == 2 && objectArray[0] instanceof Integer || bl3 && string.equals("get") && objectArray.length == 1 && objectArray[0] instanceof Integer) {
            Object[] objectArray2;
            string3 = string3 + " index=" + this.quote(objectArray[0].toString());
            if (objectArray.length == 1) {
                objectArray2 = new Object[]{};
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray2 = objectArray3;
                objectArray3[0] = objectArray[1];
            }
            objectArray = objectArray2;
        } else if (!bl3 && string.startsWith("set") && objectArray.length == 1 || bl3 && string.startsWith("get") && objectArray.length == 0) {
            string3 = string3 + " property=" + this.quote(Introspector.decapitalize(string.substring(3)));
        } else if (!string.equals("new") && !string.equals("newInstance")) {
            string3 = string3 + " method=" + this.quote(string);
        }
        object2 = this.statementList(object4);
        if (objectArray.length == 0 && ((Vector)object2).size() == 0) {
            this.writeln("<" + string2 + string3 + "/>");
            return;
        }
        this.writeln("<" + string2 + string3 + ">");
        ++this.indentation;
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            this.outputValue(objectArray[n2], null, true);
        }
        for (n2 = 0; n2 < ((Vector)object2).size(); ++n2) {
            Statement statement2 = (Statement)((Vector)object2).get(n2);
            this.outputStatement(statement2, object4, false);
        }
        --this.indentation;
        this.writeln("</" + string2 + ">");
    }

    private class ValueData {
        public int refs = 0;
        public boolean marked = false;
        public String name = null;
        public Expression exp = null;

        private ValueData() {
        }
    }
}

