/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import javax.swing.JFrame;
import javax.swing.JPanel;
import sun.awt.im.CompositionAreaHandler;
import sun.awt.im.InputContext;
import sun.awt.im.InputMethodContext;
import sun.awt.im.InputMethodWindow;

public class CompositionArea
extends JPanel
implements InputMethodListener {
    private CompositionAreaHandler handler;
    private TextLayout composedTextLayout;
    private TextHitInfo caret = null;
    private JFrame compositionWindow;
    private static final int TEXT_ORIGIN_X = 5;
    private static final int TEXT_ORIGIN_Y = 15;

    CompositionArea() {
        String string = Toolkit.getProperty("AWT.CompositionWindowTitle", "Input Window");
        this.compositionWindow = (JFrame)InputMethodContext.createInputMethodWindow(string, null, true);
        this.setPreferredSize(new Dimension(480, 18));
        this.setOpaque(true);
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.enableInputMethods(true);
        this.enableEvents(8L);
        this.compositionWindow.getContentPane().add(this);
        this.compositionWindow.addWindowListener(new FrameWindowAdapter());
        this.addInputMethodListener(this);
        this.compositionWindow.enableInputMethods(false);
        this.compositionWindow.pack();
        Dimension dimension = this.compositionWindow.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        this.compositionWindow.setLocation(dimension2.width - dimension.width - 20, dimension2.height - dimension.height - 100);
        this.compositionWindow.setVisible(false);
    }

    synchronized void setHandlerInfo(CompositionAreaHandler compositionAreaHandler, InputContext inputContext) {
        this.handler = compositionAreaHandler;
        ((InputMethodWindow)((Object)this.compositionWindow)).setInputContext(inputContext);
    }

    public InputMethodRequests getInputMethodRequests() {
        return this.handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Rectangle getCaretRectangle(TextHitInfo textHitInfo) {
        int n2 = 0;
        TextLayout textLayout = this.composedTextLayout;
        if (textLayout != null) {
            n2 = Math.round(textLayout.getCaretInfo(textHitInfo)[0]);
        }
        Graphics graphics = this.getGraphics();
        FontMetrics fontMetrics = null;
        try {
            fontMetrics = graphics.getFontMetrics();
        }
        finally {
            graphics.dispose();
        }
        return new Rectangle(5 + n2, 15 - fontMetrics.getAscent(), 0, fontMetrics.getAscent() + fontMetrics.getDescent());
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setColor(this.getForeground());
        TextLayout textLayout = this.composedTextLayout;
        if (textLayout != null) {
            textLayout.draw((Graphics2D)graphics, 5.0f, 15.0f);
        }
        if (this.caret != null) {
            Rectangle rectangle = this.getCaretRectangle(this.caret);
            graphics.setXORMode(this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, 1, rectangle.height);
            graphics.setPaintMode();
        }
    }

    public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
        this.handler.inputMethodTextChanged(inputMethodEvent);
    }

    public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
        this.handler.caretPositionChanged(inputMethodEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setText(AttributedCharacterIterator attributedCharacterIterator, TextHitInfo textHitInfo) {
        this.composedTextLayout = null;
        if (attributedCharacterIterator == null) {
            this.compositionWindow.setVisible(false);
            this.caret = null;
        } else {
            Graphics graphics = this.getGraphics();
            FontRenderContext fontRenderContext = null;
            try {
                fontRenderContext = ((Graphics2D)graphics).getFontRenderContext();
            }
            finally {
                graphics.dispose();
            }
            this.composedTextLayout = new TextLayout(attributedCharacterIterator, fontRenderContext);
            this.caret = textHitInfo;
            this.updateWindowLocation();
            if (!this.compositionWindow.isVisible()) {
                this.compositionWindow.setVisible(true);
            }
            graphics = this.getGraphics();
            try {
                this.paint(graphics);
            }
            finally {
                graphics.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCaret(TextHitInfo textHitInfo) {
        this.caret = textHitInfo;
        if (this.compositionWindow.isVisible()) {
            Graphics graphics = this.getGraphics();
            try {
                this.paint(graphics);
            }
            finally {
                graphics.dispose();
            }
        }
    }

    void updateWindowLocation() {
        InputMethodRequests inputMethodRequests = this.handler.getClientInputMethodRequests();
        if (inputMethodRequests == null) {
            return;
        }
        Point point = new Point();
        Rectangle rectangle = inputMethodRequests.getTextLocation(null);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.compositionWindow.getSize();
        point.x = rectangle.x + dimension2.width > dimension.width ? dimension.width - dimension2.width : rectangle.x;
        point.y = rectangle.y + rectangle.height + 2 + dimension2.height > dimension.height ? rectangle.y - 2 - dimension2.height : rectangle.y + rectangle.height + 2;
        this.compositionWindow.setLocation(point);
    }

    Rectangle getTextLocation(TextHitInfo textHitInfo) {
        Rectangle rectangle = this.getCaretRectangle(textHitInfo);
        Point point = this.getLocationOnScreen();
        rectangle.translate(point.x, point.y);
        return rectangle;
    }

    TextHitInfo getLocationOffset(int n2, int n3) {
        TextLayout textLayout = this.composedTextLayout;
        if (textLayout == null) {
            return null;
        }
        Point point = this.getLocationOnScreen();
        if (textLayout.getBounds().contains(n2 -= point.x + 5, n3 -= point.y + 15)) {
            return textLayout.hitTestChar(n2, n3);
        }
        return null;
    }

    class FrameWindowAdapter
    extends WindowAdapter {
        FrameWindowAdapter() {
        }

        public void windowActivated(WindowEvent windowEvent) {
            CompositionArea.this.requestFocus();
        }
    }
}

