/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import sun.awt.image.PixelConverter;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.opengl.OGLContext;
import sun.java2d.opengl.OGLSurfaceData;
import sun.java2d.pipe.LoopPipe;
import sun.java2d.pipe.PixelDrawPipe;
import sun.java2d.pipe.PixelFillPipe;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.java2d.pipe.ShapeSpanIterator;
import sun.java2d.pipe.SpanIterator;

public abstract class OGLRenderer
implements PixelDrawPipe,
PixelFillPipe,
ShapeDrawPipe {
    abstract long getContext(SunGraphics2D var1);

    abstract void releaseContext(long var1);

    native void enableGradientPaint(long var1, boolean var3, double var4, double var6, double var8, int var10, int var11);

    native void disableGradientPaint(long var1);

    native void enableTexturePaint(long var1, long var3, boolean var5, double var6, double var8, double var10, double var12, double var14, double var16);

    native void disableTexturePaint(long var1);

    protected long getContext(SunGraphics2D sunGraphics2D, int n2, boolean bl2) {
        int n3 = bl2 ? 6 : 2;
        OGLSurfaceData oGLSurfaceData = (OGLSurfaceData)sunGraphics2D.surfaceData;
        return OGLContext.getContext(oGLSurfaceData, oGLSurfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, null, n2, n3);
    }

    native void doDrawLine(long var1, int var3, int var4, int var5, int var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawLine(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5) {
        Object object = OGLContext.LOCK;
        synchronized (object) {
            long l2 = this.getContext(sunGraphics2D);
            int n6 = sunGraphics2D.transX;
            int n7 = sunGraphics2D.transY;
            this.doDrawLine(l2, n2 + n6, n3 + n7, n4 + n6, n5 + n7);
            this.releaseContext(l2);
        }
    }

    native void doDrawRect(long var1, int var3, int var4, int var5, int var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawRect(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5) {
        Object object = OGLContext.LOCK;
        synchronized (object) {
            long l2 = this.getContext(sunGraphics2D);
            this.doDrawRect(l2, n2 + sunGraphics2D.transX, n3 + sunGraphics2D.transY, n4, n5);
            this.releaseContext(l2);
        }
    }

    public void drawRoundRect(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.draw(sunGraphics2D, new RoundRectangle2D.Float(n2, n3, n4, n5, n6, n7));
    }

    public void drawOval(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5) {
        this.draw(sunGraphics2D, new Ellipse2D.Float(n2, n3, n4, n5));
    }

    public void drawArc(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.draw(sunGraphics2D, new Arc2D.Float(n2, n3, n4, n5, n6, n7, 0));
    }

    native void doDrawPoly(long var1, int var3, int var4, int[] var5, int[] var6, int var7, boolean var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPolyline(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n2) {
        Object object = OGLContext.LOCK;
        synchronized (object) {
            long l2 = this.getContext(sunGraphics2D);
            this.doDrawPoly(l2, sunGraphics2D.transX, sunGraphics2D.transY, nArray, nArray2, n2, false);
            this.releaseContext(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n2) {
        Object object = OGLContext.LOCK;
        synchronized (object) {
            long l2 = this.getContext(sunGraphics2D);
            this.doDrawPoly(l2, sunGraphics2D.transX, sunGraphics2D.transY, nArray, nArray2, n2, true);
            this.releaseContext(l2);
        }
    }

    native void doFillRect(long var1, int var3, int var4, int var5, int var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillRect(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5) {
        Object object = OGLContext.LOCK;
        synchronized (object) {
            long l2 = this.getContext(sunGraphics2D);
            this.doFillRect(l2, n2 + sunGraphics2D.transX, n3 + sunGraphics2D.transY, n4, n5);
            this.releaseContext(l2);
        }
    }

    public void fillRoundRect(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.fill(sunGraphics2D, new RoundRectangle2D.Float(n2, n3, n4, n5, n6, n7));
    }

    public void fillOval(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5) {
        this.fill(sunGraphics2D, new Ellipse2D.Float(n2, n3, n4, n5));
    }

    public void fillArc(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.fill(sunGraphics2D, new Arc2D.Float(n2, n3, n4, n5, n6, n7, 2));
    }

    public void fillPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n2) {
        this.fill(sunGraphics2D, new Polygon(nArray, nArray2, n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(SunGraphics2D sunGraphics2D, Shape shape) {
        block21: {
            if (sunGraphics2D.strokeState == 0) {
                AffineTransform affineTransform;
                if (sunGraphics2D.transformState < 3) {
                    if (shape instanceof Polygon) {
                        Polygon polygon = (Polygon)shape;
                        this.drawPolygon(sunGraphics2D, polygon.xpoints, polygon.ypoints, polygon.npoints);
                        return;
                    }
                    affineTransform = null;
                } else {
                    affineTransform = sunGraphics2D.transform;
                }
                PathIterator pathIterator = shape.getPathIterator(affineTransform, 0.5);
                Polygon polygon = new Polygon();
                float[] fArray = new float[2];
                while (!pathIterator.isDone()) {
                    switch (pathIterator.currentSegment(fArray)) {
                        case 0: {
                            if (polygon.npoints > 1) {
                                this.drawPolyline(sunGraphics2D, polygon.xpoints, polygon.ypoints, polygon.npoints);
                            }
                            polygon.reset();
                            polygon.addPoint((int)Math.floor(fArray[0]), (int)Math.floor(fArray[1]));
                            break;
                        }
                        case 1: {
                            if (polygon.npoints == 0) {
                                throw new IllegalPathStateException("missing initial moveto in path definition");
                            }
                            polygon.addPoint((int)Math.floor(fArray[0]), (int)Math.floor(fArray[1]));
                            break;
                        }
                        case 4: {
                            if (polygon.npoints <= 0) break;
                            polygon.addPoint(polygon.xpoints[0], polygon.ypoints[0]);
                            break;
                        }
                        default: {
                            throw new IllegalPathStateException("path not flattened");
                        }
                    }
                    pathIterator.next();
                }
                if (polygon.npoints > 1) {
                    this.drawPolyline(sunGraphics2D, polygon.xpoints, polygon.ypoints, polygon.npoints);
                }
            } else {
                if (sunGraphics2D.strokeState < 3) {
                    ShapeSpanIterator shapeSpanIterator = LoopPipe.getStrokeSpans(sunGraphics2D, shape);
                    try {
                        Object object = OGLContext.LOCK;
                        synchronized (object) {
                            long l2 = this.getContext(sunGraphics2D);
                            this.devFillSpans(l2, shapeSpanIterator, shapeSpanIterator.getNativeIterator(), 0, 0);
                            this.releaseContext(l2);
                            break block21;
                        }
                    }
                    finally {
                        shapeSpanIterator.dispose();
                    }
                }
                this.fill(sunGraphics2D, sunGraphics2D.stroke.createStrokedShape(shape));
            }
        }
    }

    native void devFillSpans(long var1, SpanIterator var3, long var4, int var6, int var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fill(SunGraphics2D sunGraphics2D, Shape shape) {
        int n2;
        int n3;
        AffineTransform affineTransform;
        if (sunGraphics2D.transformState < 3) {
            affineTransform = null;
            n3 = sunGraphics2D.transX;
            n2 = sunGraphics2D.transY;
        } else {
            affineTransform = sunGraphics2D.transform;
            n2 = 0;
            n3 = 0;
        }
        ShapeSpanIterator shapeSpanIterator = new ShapeSpanIterator(sunGraphics2D, false);
        try {
            Region region = sunGraphics2D.getCompClip();
            shapeSpanIterator.setOutputAreaXYXY(region.getLoX() - n3, region.getLoY() - n2, region.getHiX() - n3, region.getHiY() - n2);
            shapeSpanIterator.appendPath(shape.getPathIterator(affineTransform));
            Object object = OGLContext.LOCK;
            synchronized (object) {
                long l2 = this.getContext(sunGraphics2D);
                this.devFillSpans(l2, shapeSpanIterator, shapeSpanIterator.getNativeIterator(), n3, n2);
                this.releaseContext(l2);
            }
        }
        finally {
            shapeSpanIterator.dispose();
        }
    }

    native void devCopyArea(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10);

    public OGLRenderer traceWrap() {
        return new Tracer(this);
    }

    public static class Gradient
    extends OGLRenderer {
        protected long getContext(SunGraphics2D sunGraphics2D) {
            double d2;
            double d3;
            double d4;
            GradientPaint gradientPaint = (GradientPaint)sunGraphics2D.paint;
            boolean bl2 = gradientPaint.getTransparency() == 1;
            long l2 = this.getContext(sunGraphics2D, -1, bl2);
            PixelConverter pixelConverter = PixelConverter.RgbaPre.instance;
            Color color = gradientPaint.getColor1();
            int n2 = pixelConverter.rgbToPixel(color.getRGB(), null);
            Color color2 = gradientPaint.getColor2();
            int n3 = pixelConverter.rgbToPixel(color2.getRGB(), null);
            AffineTransform affineTransform = (AffineTransform)sunGraphics2D.transform.clone();
            Point2D point2D = gradientPaint.getPoint1();
            double d5 = point2D.getX();
            double d6 = point2D.getY();
            affineTransform.translate(d5, d6);
            point2D = gradientPaint.getPoint2();
            d5 = point2D.getX() - d5;
            d6 = point2D.getY() - d6;
            double d7 = Math.sqrt(d5 * d5 + d6 * d6);
            affineTransform.rotate(Math.atan2(d6, d5));
            affineTransform.scale(2.0 * d7, 1.0);
            affineTransform.translate(-0.25, 0.0);
            try {
                affineTransform = affineTransform.createInverse();
                d4 = affineTransform.getScaleX();
                d3 = affineTransform.getShearX();
                d2 = affineTransform.getTranslateX();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                d2 = 0.0;
                d3 = 0.0;
                d4 = 0.0;
            }
            this.enableGradientPaint(l2, gradientPaint.isCyclic(), d4, d3, d2, n2, n3);
            return l2;
        }

        protected void releaseContext(long l2) {
            this.disableGradientPaint(l2);
        }
    }

    public static class Solid
    extends OGLRenderer {
        protected long getContext(SunGraphics2D sunGraphics2D) {
            int n2;
            return this.getContext(sunGraphics2D, n2, (n2 = sunGraphics2D.pixel) >>> 24 == 255);
        }

        protected void releaseContext(long l2) {
        }
    }

    public static class Texture
    extends OGLRenderer {
        public static boolean isPaintValid(SunGraphics2D sunGraphics2D, TexturePaint texturePaint) {
            SurfaceData surfaceData;
            OGLSurfaceData oGLSurfaceData = (OGLSurfaceData)sunGraphics2D.surfaceData;
            BufferedImage bufferedImage = texturePaint.getImage();
            if (!oGLSurfaceData.isTexNonPow2Available()) {
                int n2 = bufferedImage.getWidth();
                int n3 = bufferedImage.getHeight();
                if ((n2 & n2 - 1) != 0 || (n3 & n3 - 1) != 0) {
                    return false;
                }
            }
            if (!((surfaceData = SurfaceData.getSourceSurfaceData(bufferedImage, oGLSurfaceData, CompositeType.SrcOver, null, false)) instanceof OGLSurfaceData) && !((surfaceData = SurfaceData.getSourceSurfaceData(bufferedImage, oGLSurfaceData, CompositeType.SrcOver, null, false)) instanceof OGLSurfaceData)) {
                return false;
            }
            OGLSurfaceData oGLSurfaceData2 = (OGLSurfaceData)surfaceData;
            return oGLSurfaceData2.getType() == 4;
        }

        protected long getContext(SunGraphics2D sunGraphics2D) {
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            SurfaceData surfaceData;
            TexturePaint texturePaint = (TexturePaint)sunGraphics2D.paint;
            boolean bl2 = texturePaint.getTransparency() == 1;
            long l2 = this.getContext(sunGraphics2D, -1, bl2);
            BufferedImage bufferedImage = texturePaint.getImage();
            SurfaceData surfaceData2 = SurfaceData.getSourceSurfaceData(bufferedImage, surfaceData = sunGraphics2D.surfaceData, CompositeType.SrcOver, null, false);
            if (!(surfaceData2 instanceof OGLSurfaceData)) {
                return l2;
            }
            boolean bl3 = sunGraphics2D.interpolationType != 1;
            AffineTransform affineTransform = (AffineTransform)sunGraphics2D.transform.clone();
            Rectangle2D rectangle2D = texturePaint.getAnchorRect();
            affineTransform.translate(rectangle2D.getX(), rectangle2D.getY());
            affineTransform.scale(rectangle2D.getWidth(), rectangle2D.getHeight());
            try {
                affineTransform = affineTransform.createInverse();
                d7 = affineTransform.getScaleX();
                d6 = affineTransform.getShearX();
                d5 = affineTransform.getTranslateX();
                d4 = affineTransform.getShearY();
                d3 = affineTransform.getScaleY();
                d2 = affineTransform.getTranslateY();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                d2 = 0.0;
                d3 = 0.0;
                d4 = 0.0;
                d5 = 0.0;
                d6 = 0.0;
                d7 = 0.0;
            }
            long l3 = surfaceData2.getNativeOps();
            this.enableTexturePaint(l2, l3, bl3, d7, d6, d5, d4, d3, d2);
            return l2;
        }

        protected void releaseContext(long l2) {
            this.disableTexturePaint(l2);
        }
    }

    private class Tracer
    extends OGLRenderer {
        private OGLRenderer oglr;

        public Tracer(OGLRenderer oGLRenderer2) {
            this.oglr = oGLRenderer2;
        }

        long getContext(SunGraphics2D sunGraphics2D) {
            return this.oglr.getContext(sunGraphics2D);
        }

        void releaseContext(long l2) {
            this.oglr.releaseContext(l2);
        }

        void doDrawLine(long l2, int n2, int n3, int n4, int n5) {
            GraphicsPrimitive.tracePrimitive("OGLDrawLine");
            this.oglr.doDrawLine(l2, n2, n3, n4, n5);
        }

        void doDrawRect(long l2, int n2, int n3, int n4, int n5) {
            GraphicsPrimitive.tracePrimitive("OGLDrawRect");
            this.oglr.doDrawRect(l2, n2, n3, n4, n5);
        }

        void doDrawPoly(long l2, int n2, int n3, int[] nArray, int[] nArray2, int n4, boolean bl2) {
            GraphicsPrimitive.tracePrimitive("OGLDrawPoly");
            this.oglr.doDrawPoly(l2, n2, n3, nArray, nArray2, n4, bl2);
        }

        void doFillRect(long l2, int n2, int n3, int n4, int n5) {
            GraphicsPrimitive.tracePrimitive("OGLFillRect");
            this.oglr.doFillRect(l2, n2, n3, n4, n5);
        }

        void devFillSpans(long l2, SpanIterator spanIterator, long l3, int n2, int n3) {
            GraphicsPrimitive.tracePrimitive("OGLFillSpans");
            this.oglr.devFillSpans(l2, spanIterator, l3, n2, n3);
        }

        void devCopyArea(long l2, long l3, int n2, int n3, int n4, int n5, int n6, int n7) {
            GraphicsPrimitive.tracePrimitive("OGLCopyArea");
            this.oglr.devCopyArea(l2, l3, n2, n3, n4, n5, n6, n7);
        }
    }
}

