/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.agent;

import com.clustercontrol.agent.SendQueue;
import com.clustercontrol.jobmanagement.message.RunInstructionInfo;
import com.clustercontrol.jobmanagement.message.RunResultInfo;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CheckSumThread
extends Thread {
    protected static final String ALGORITHM = "MD5";
    protected RunInstructionInfo m_info = null;
    protected SendQueue m_sendQueue;
    private static Log log = LogFactory.getLog(CheckSumThread.class);
    static /* synthetic */ Class class$0;

    public CheckSumThread(RunInstructionInfo info, SendQueue sendQueue) {
        this.m_info = info;
        this.m_sendQueue = sendQueue;
    }

    public void run() {
        log.debug((Object)"run start");
        RunResultInfo info = new RunResultInfo();
        info.setSessionId(this.m_info.getSessionId());
        info.setJobId(this.m_info.getJobId());
        info.setFacilityId(this.m_info.getFacilityId());
        info.setCommand(this.m_info.getCommand());
        info.setCommandType(this.m_info.getCommandType());
        info.setStatus(0);
        info.setTime(new Date());
        log.info((Object)("run SessionID=" + this.m_info.getSessionId() + ", JobID=" + this.m_info.getJobId()));
        this.m_sendQueue.put(info);
        if (this.m_info.getCommand().equals("getCheckSum")) {
            String checksum = this.getCheckSum(this.m_info.getFilePath());
            if (checksum != null) {
                info.setStatus(1);
                info.setCheckSum(checksum);
                info.setTime(new Date());
                info.setErrorMessage("");
                info.setMessage("");
                info.setEndValue(0);
            } else {
                info.setStatus(2);
                info.setTime(new Date());
                info.setErrorMessage("");
                info.setMessage("");
                info.setEndValue(-1);
            }
        } else if (this.m_info.getCommand().equals("checkCheckSum")) {
            String checksum = this.getCheckSum(this.m_info.getFilePath());
            if (checksum.equals(this.m_info.getCheckSum())) {
                info.setStatus(1);
                info.setTime(new Date());
                info.setErrorMessage("");
                info.setMessage("");
                info.setEndValue(0);
            } else {
                info.setStatus(2);
                info.setTime(new Date());
                info.setErrorMessage("");
                info.setMessage("");
                info.setEndValue(-1);
            }
        }
        this.m_sendQueue.put(info);
        log.debug((Object)"run end");
    }

    protected String getCheckSum(String path) {
        log.debug((Object)"get checksum start");
        String checksum = null;
        try {
            int len;
            MessageDigest md = MessageDigest.getInstance(ALGORITHM);
            FileInputStream inputStream = new FileInputStream(path);
            byte[] readData = new byte[256];
            while ((len = inputStream.read(readData)) >= 0) {
                md.update(readData, 0, len);
            }
            inputStream.close();
            checksum = this.changeString(md.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        log.debug((Object)"get checksum end");
        return checksum;
    }

    protected String changeString(byte[] digest) {
        StringBuilder hashString = new StringBuilder();
        int i = 0;
        while (i < digest.length) {
            int d = digest[i];
            if (d < 0) {
                d += 256;
            }
            if (d < 16) {
                hashString.append("0");
            }
            hashString.append(Integer.toString(d, 16));
            ++i;
        }
        return hashString.toString();
    }
}

