/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.agent;

import com.clustercontrol.agent.SendQueue;
import com.clustercontrol.jobmanagement.message.RunInstructionInfo;
import com.clustercontrol.jobmanagement.message.RunResultInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommandThread
extends Thread {
    protected RunInstructionInfo m_info = null;
    protected SendQueue m_sendQueue;
    protected String m_resultMsg = "";
    protected String m_errMsg = "";
    protected int m_exitValue;
    private static Log log = LogFactory.getLog(CommandThread.class);
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        CommandThread agent = new CommandThread();
        agent.execCommand(new String[]{"java -version"});
        agent.execCommand(new String[]{"cmd /c \"dir c;\\ /s \" "});
        agent.execCommand(new String[]{"notepad"});
    }

    public CommandThread() {
    }

    public CommandThread(RunInstructionInfo info, SendQueue sendQueue) {
        super("CommandThread:" + info.getCommand());
        this.m_info = info;
        this.m_sendQueue = sendQueue;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void run() {
        log.debug((Object)"run start");
        RunResultInfo info = new RunResultInfo();
        info.setSessionId(this.m_info.getSessionId());
        info.setJobId(this.m_info.getJobId());
        info.setFacilityId(this.m_info.getFacilityId());
        info.setCommand(this.m_info.getCommand());
        info.setCommandType(this.m_info.getCommandType());
        info.setStatus(0);
        info.setTime(new Date());
        log.info((Object)("run SessionID=" + this.m_info.getSessionId() + ", JobID=" + this.m_info.getJobId()));
        this.m_sendQueue.put(info);
        String sysUserName = System.getProperty("user.name");
        String execCommand = this.m_info.getCommand();
        String[] cmd = new String[3];
        if (!sysUserName.equals(this.m_info.getUser())) {
            if (!sysUserName.equals("root")) {
                info.setStatus(2);
                info.setTime(new Date());
                info.setErrorMessage("The execution user of the command and agent's user are different. ");
                info.setMessage("");
                this.m_sendQueue.put(info);
                log.error((Object)"The execution user of the command and agent's user are different. ");
                log.info((Object)"run end");
                return;
            }
            cmd = new String[]{"su", "-c " + execCommand, this.m_info.getUser()};
        } else {
            cmd = execCommand.split(" ");
        }
        boolean ret = this.execCommand(cmd);
        if (ret) {
            info.setStatus(1);
            info.setEndValue(this.m_exitValue);
        } else {
            info.setStatus(2);
        }
        info.setTime(new Date());
        info.setErrorMessage(this.m_errMsg);
        info.setMessage(this.m_resultMsg);
        this.m_sendQueue.put(info);
        log.debug((Object)"run end");
    }

    public boolean execCommand(String[] cmd) {
        Process process;
        Runtime runtime = Runtime.getRuntime();
        try {
            if (log.isInfoEnabled()) {
                int i = 0;
                while (i < cmd.length) {
                    log.info((Object)("Command Execute:" + cmd[i]));
                    ++i;
                }
            }
            process = runtime.exec(cmd);
        }
        catch (IOException e) {
            log.error((Object)e);
            this.m_errMsg = e.getMessage();
            return false;
        }
        try {
            StreamReader errStreamReader = new StreamReader(process.getErrorStream());
            errStreamReader.start();
            StreamReader inStreamReader = new StreamReader(process.getInputStream());
            inStreamReader.start();
            try {
                this.m_exitValue = process.waitFor();
            }
            catch (InterruptedException e) {
                log.error((Object)e);
                this.m_errMsg = e.getMessage();
                process.destroy();
                return false;
            }
            log.debug((Object)("ExitCoe:" + this.m_exitValue));
            try {
                inStreamReader.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.m_resultMsg = inStreamReader.getResult();
            log.debug((Object)inStreamReader.getResult());
            try {
                errStreamReader.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.m_errMsg = errStreamReader.getResult();
            log.debug((Object)this.m_errMsg);
            return true;
        }
        finally {
            process.destroy();
        }
    }

    protected class StreamReader
    extends Thread {
        InputStream m_ist;
        StringBuffer m_result;

        public StreamReader(InputStream ist) {
            this.m_ist = ist;
            this.m_result = new StringBuffer();
        }

        public void run() {
            byte[] buff = new byte[64];
            while (true) {
                try {
                    int length = this.m_ist.read(buff);
                    if (length == -1) break;
                    this.m_result.append(new String(buff, 0, length));
                }
                catch (IOException e) {
                    log.error((Object)e);
                    break;
                }
            }
            try {
                this.m_ist.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getResult() {
            return this.m_result.toString();
        }
    }
}

